/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.utils;

import javafx.scene.input.Dragboard;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.dnd.ElementDropContext;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IPrototypeService;

public final class FXDNDUtils {
    public static boolean canCompose(Dragboard db, EObject container) {
        Prototype proto = FXDNDUtils.extractPrototype(db);
        if (proto != null) {
            return IElementCompositorService.getInstance().canCompose(container, proto.getPrototypeCopy(), null);
        }
        return false;
    }

    public static boolean canCompose(Dragboard db, DiagramCoordinate location, EObject container, boolean isRootContainer, double zoom) {
        Prototype proto = FXDNDUtils.extractPrototype(db);
        if (proto != null) {
            ElementDropContext ctx = FXDNDUtils.createElementDropContext(location, container, isRootContainer, zoom);
            return IElementCompositorService.getInstance().canCompose(container, proto.getPrototypeCopy(), (IElementCompositionContext)ctx);
        }
        return false;
    }

    public static boolean compose(Dragboard db, EObject container) {
        Prototype proto = FXDNDUtils.extractPrototype(db);
        if (proto != null) {
            EObject copy = proto.getPrototypeCopy();
            return FXDNDUtils.doElementComposition(container, copy, null);
        }
        return false;
    }

    public static boolean compose(Dragboard db, DiagramCoordinate location, EObject container, boolean isRootContainer, double zoom) {
        Prototype proto = FXDNDUtils.extractPrototype(db);
        if (proto != null) {
            EObject copy = proto.getPrototypeCopy();
            ElementDropContext ctx = FXDNDUtils.createElementDropContext(location, container, isRootContainer, zoom);
            return FXDNDUtils.doElementComposition(container, copy, ctx);
        }
        return false;
    }

    private static boolean doElementComposition(EObject container, EObject contained, ElementDropContext context) {
        IElementCompositorService ecs = IElementCompositorService.getInstance();
        if (ecs.canCompose(container, contained, (IElementCompositionContext)context)) {
            ICommandStackService.getInstance().runAsCommand(container, () -> ecs.compose(container, contained, (IElementCompositionContext)context));
            return true;
        }
        return false;
    }

    private static ElementDropContext createElementDropContext(DiagramCoordinate location, EObject container, boolean isRootContainer, double zoom) {
        Point dcLocation = LayoutModelElementFactory.createPoint((int)((int)location.getX()), (int)((int)location.getY()), (String)"");
        ElementDropContext ctx = new ElementDropContext(container, dcLocation, isRootContainer, zoom);
        return ctx;
    }

    private static Prototype extractPrototype(Dragboard db) {
        Object data = db.getContent(IPrototypeService.PROTOTYPE_DATA_FORMAT);
        if (data instanceof String) {
            return IPrototypeService.getInstance().getPrototypeByUniqueID((String)data);
        }
        return null;
    }

    private FXDNDUtils() {
    }
}

