/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.utils;

import java.util.Deque;
import java.util.LinkedList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.swt.SWTResourceManager;

public final class GCStateManager {
    private final GC gc;
    private final Deque<Object> state = new LinkedList<Object>();

    public GCStateManager(GC gc) {
        this.gc = gc;
    }

    public GC GC() {
        return this.gc;
    }

    public GCStateManager alphaStoreAndSet(int alpha) {
        this.state.push(new Integer(this.gc.getAlpha()));
        this.gc.setAlpha(alpha);
        return this;
    }

    public GCStateManager alphaRestore() {
        this.gc.setAlpha(((Integer)this.state.pop()).intValue());
        return this;
    }

    public GCStateManager foregroundStoreAndCreate(RGB rgb) {
        this.state.push(this.gc.getForeground());
        this.gc.setForeground(SWTResourceManager.getColor((RGB)rgb));
        return this;
    }

    public GCStateManager foregroundRestoreAndDispose() {
        this.gc.getForeground().dispose();
        this.gc.setForeground((Color)this.state.pop());
        return this;
    }

    public GCStateManager backgroundStoreAndCreate(RGB rgb) {
        this.state.push(this.gc.getBackground());
        this.gc.setBackground(SWTResourceManager.getColor((RGB)rgb));
        return this;
    }

    public GCStateManager backgroundRestoreAndDispose() {
        this.gc.getBackground().dispose();
        this.gc.setBackground((Color)this.state.pop());
        return this;
    }

    public GCStateManager fontStoreAndCreate(FontData fontData) {
        this.state.push(this.gc.getFont());
        this.gc.setFont(new Font((Device)Display.getCurrent(), fontData));
        return this;
    }

    public GCStateManager fontRestoreAndDispose() {
        this.gc.getFont().dispose();
        this.gc.setFont((Font)this.state.pop());
        return this;
    }

    public GCStateManager lineStoreAndSet(int width, int style) {
        this.state.push(this.gc.getLineWidth());
        this.gc.setLineWidth(width);
        this.state.push(this.gc.getLineStyle());
        this.gc.setLineStyle(style);
        return this;
    }

    public GCStateManager lineRestore() {
        this.gc.setLineStyle(((Integer)this.state.pop()).intValue());
        this.gc.setLineWidth(((Integer)this.state.pop()).intValue());
        return this;
    }
}

