/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.utils;

import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.paint.Color;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.MVCBundleTag;
import org.fortiss.tooling.kernel.service.IConnectionCompositorService;

public final class LWFXEditorUtils {
    public static Color LINK_DENIED_COLOR = Color.rgb((int)255, (int)0, (int)0, (double)0.25);
    public static Color LINK_ALLOWED_COLOR = Color.rgb((int)0, (int)255, (int)0, (double)0.25);

    public static DiagramCoordinate computeLinkToAnchorLocation(Rectangle2D anchorBounds, DiagramCoordinate target) {
        double x = 0.0;
        if (target.getX() < anchorBounds.getMinX()) {
            x = -1.0;
        } else if (target.getX() > anchorBounds.getMaxX()) {
            x = 1.0;
        }
        double y = 0.0;
        if (target.getY() < anchorBounds.getMinY()) {
            y = -1.0;
        } else if (target.getY() > anchorBounds.getMaxY()) {
            y = 1.0;
        }
        double w2 = anchorBounds.getWidth() / 2.0;
        double h2 = anchorBounds.getHeight() / 2.0;
        x = anchorBounds.getMinX() + w2 + x * w2;
        y = anchorBounds.getMinY() + h2 + y * h2;
        return new DiagramCoordinate(x, y);
    }

    public static EOrientation convertSideToEOrientation(Side s) {
        switch (s) {
            case TOP: {
                return EOrientation.NORTH;
            }
            case BOTTOM: {
                return EOrientation.SOUTH;
            }
            case LEFT: {
                return EOrientation.WEST;
            }
            case RIGHT: {
                return EOrientation.EAST;
            }
        }
        return null;
    }

    public static Side convertEOrientationToSide(EOrientation eo) {
        switch (eo) {
            case NORTH: {
                return Side.TOP;
            }
            case SOUTH: {
                return Side.BOTTOM;
            }
            case WEST: {
                return Side.LEFT;
            }
            case EAST: {
                return Side.RIGHT;
            }
        }
        return null;
    }

    public static DiagramCoordinate computeLinkToCircleLocation(Rectangle2D bounds, Point2D target) {
        double sx = bounds.getMinX() + bounds.getWidth() / 2.0;
        double sy = bounds.getMinY() + bounds.getHeight() / 2.0;
        double a = Math.atan2(target.getY() - sy, target.getX() - sx);
        double nx = sx + Math.cos(a) * (bounds.getWidth() / 2.0 - 1.0);
        double ny = sy + Math.sin(a) * (bounds.getHeight() / 2.0 - 1.0);
        return new DiagramCoordinate(nx, ny);
    }

    public static boolean stickyConnectorHasVisibleConnections(IConnector connector) {
        IHierarchicElement elem = connector.getOwner();
        if (elem == null) {
            return true;
        }
        IHierarchicElementContainer diagram = elem.getContainer();
        for (IConnection conn : connector.getIncoming()) {
            if (conn.getOwner() != diagram) continue;
            return true;
        }
        for (IConnection conn : connector.getOutgoing()) {
            if (conn.getOwner() != diagram) continue;
            return true;
        }
        return false;
    }

    public static boolean freeConnectorHasVisibleConnections(IConnector connector) {
        IHierarchicElement diagram = connector.getOwner();
        if (diagram == null) {
            return true;
        }
        for (IConnection conn : connector.getIncoming()) {
            if (conn.getOwner() != diagram) continue;
            return true;
        }
        for (IConnection conn : connector.getOutgoing()) {
            if (conn.getOwner() != diagram) continue;
            return true;
        }
        return false;
    }

    public static Point convertDiagramCoordinateToPoint(DiagramCoordinate coordinate) {
        return LayoutModelElementFactory.createPoint((int)((int)coordinate.getX()), (int)((int)coordinate.getY()), (String)"");
    }

    public static MVCBundleTag getLinkTargetEffectForMoveLink(ILinkMVCBundle linkBundle, IAnchorageMVCBundle movedAnchorageBundle, ILayoutedModelElement newTargetModel) {
        EObject srcModel = (EObject)linkBundle.getStartAnchorage().getModel();
        EObject trgModel = (EObject)linkBundle.getEndAnchorage().getModel();
        EObject movedAnchorageModel = (EObject)movedAnchorageBundle.getModel();
        IConnectionCompositorService srv = IConnectionCompositorService.getInstance();
        EObject connectionModel = (EObject)linkBundle.getModel();
        if (movedAnchorageModel == srcModel ? srv.canReconnect(connectionModel, (EObject)newTargetModel, trgModel, null) : srv.canReconnect(connectionModel, srcModel, (EObject)newTargetModel, null)) {
            return DiagramViewerDefaultTags.LINK_TARGET_ALLOWED_TAG;
        }
        return DiagramViewerDefaultTags.LINK_TARGET_DENIED_TAG;
    }

    private LWFXEditorUtils() {
    }
}

