/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.utils;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.OffsetOrientation;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.base.utils.RectangleLayoutUtils;

public class RectangleLayoutUIUtils {
    public static OffsetOrientation calculateRectangleBorderOrientation(Point source, Dimension rectangleSize, int inset) {
        org.fortiss.tooling.base.model.layout.Point modelPoint = LayoutModelElementFactory.createPoint((int)source.x(), (int)source.y(), (String)(source.toString() + "_element"));
        org.fortiss.tooling.base.model.layout.Dimension modelDimension = LayoutModelElementFactory.createDimension((int)rectangleSize.width(), (int)rectangleSize.height(), (String)(rectangleSize.toString() + "_model"));
        return RectangleLayoutUtils.calculateRectangleBorderOrientation((org.fortiss.tooling.base.model.layout.Point)modelPoint, (org.fortiss.tooling.base.model.layout.Dimension)modelDimension, (int)inset);
    }

    public static Dimension clampRectangularShapeSize(Dimension oldSize, int minimumWidth, int minimumHeight) {
        Dimension newSize = new Dimension(oldSize.width < minimumWidth ? minimumWidth : oldSize.width, oldSize.height < minimumHeight ? minimumHeight : oldSize.height);
        return newSize;
    }

    public static Dimension retainMinimumRectangularShapeSize(Dimension oldSize) {
        return RectangleLayoutUIUtils.clampRectangularShapeSize(oldSize, 108, 72);
    }

    public static Rectangle getAbsoluteConnectorBounds(ILayoutedModelElement connector, ILayoutedModelElement parent) {
        Rectangle result = new Rectangle(0, 0, 24, 24);
        OffsetOrientation orient = LayoutDataUtils.getConnectorOffsetOrientation((ILayoutedModelElement)connector);
        org.fortiss.tooling.base.model.layout.Dimension parentSize = LayoutDataUtils.getNodeSize((ILayoutedModelElement)parent);
        org.fortiss.tooling.base.model.layout.Point pos = LayoutDataUtils.getAbsolute((OffsetOrientation)orient, (org.fortiss.tooling.base.model.layout.Dimension)parentSize, (int)12);
        org.fortiss.tooling.base.model.layout.Point parentPos = LayoutDataUtils.getNodePosition((ILayoutedModelElement)parent);
        int maxX = parentSize.getWidth() - 24;
        int maxY = parentSize.getHeight() - 24;
        result.x = parentPos.getX() + (pos.getX() > maxX ? maxX : pos.getX());
        result.y = parentPos.getY() + (pos.getY() > maxY ? maxY : pos.getY());
        return result;
    }
}

