/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.utils;

import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class TableViewerUtils {
    public static TableViewerColumn createColumn(TableViewer viewer, int width, String title, String tooltip, ColumnLabelProvider labelProvider) {
        TableViewerColumn column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setWidth(width);
        column.getColumn().setText(title);
        column.getColumn().setToolTipText(tooltip);
        column.setLabelProvider((CellLabelProvider)labelProvider);
        return column;
    }

    public static TableViewerColumn createWeightedColumn(TableViewer viewer, int widthWeight, String title, String tooltip, ColumnLabelProvider labelProvider) {
        TableViewerColumn column = new TableViewerColumn(viewer, 16384);
        column.getColumn().setText(title);
        column.getColumn().setToolTipText(tooltip);
        column.setLabelProvider((CellLabelProvider)labelProvider);
        Composite viewerParent = viewer.getTable().getParent();
        TableColumnLayout tableColumnLayout = viewerParent.getLayout() instanceof TableColumnLayout ? (TableColumnLayout)viewerParent.getLayout() : new TableColumnLayout();
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(widthWeight));
        viewerParent.setLayout((Layout)tableColumnLayout);
        return column;
    }

    public static TableViewerColumn createWeightedColumn(TableViewer viewer, int widthWeight, String title, String tooltip, ColumnLabelProvider labelProvider, EditingSupport editingSupport) {
        TableViewerColumn column = TableViewerUtils.createColumn(viewer, widthWeight, title, tooltip, labelProvider);
        column.setEditingSupport(editingSupport);
        return column;
    }

    public static TableViewerColumn createColumn(TableViewer viewer, int width, String title, String tooltip, ColumnLabelProvider labelProvider, EditingSupport editingSupport) {
        TableViewerColumn column = TableViewerUtils.createColumn(viewer, width, title, tooltip, labelProvider);
        column.setEditingSupport(editingSupport);
        return column;
    }

    public static void allowTabing(TableViewer table) {
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(table, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)table));
        ColumnViewerEditorActivationStrategy activationSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)table);
        TableViewerEditor.create((TableViewer)table, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)activationSupport, (int)58);
    }

    public static abstract class IntegerEditingSupport
    extends EditingSupport {
        private Composite parent;

        public IntegerEditingSupport(ColumnViewer viewer, Composite parent) {
            super(viewer);
            this.parent = parent;
        }

        protected CellEditor getCellEditor(Object element) {
            TextCellEditor ce = new TextCellEditor(this.parent);
            ce.setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    try {
                        Integer.parseInt(value.toString());
                    }
                    catch (NumberFormatException nfe) {
                        return "Not a valid integer";
                    }
                    return null;
                }
            });
            return ce;
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }
}

