/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.utils;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.fortiss.tooling.base.ui.utils.SnapToGridUtils;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.base.utils.ZoomUtils;

public class ZoomUIUtils {
    private static int ZOOM_ALIGN_FACTOR = 20;

    public static double determineZoom(RootEditPart rootEditPart) {
        if (rootEditPart instanceof ScalableRootEditPart) {
            return ((ScalableRootEditPart)rootEditPart).getZoomManager().getZoom();
        }
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            return ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager().getZoom();
        }
        return 1.0;
    }

    public static void fixChangeBoundRequest(ChangeBoundsRequest request, double zoom) {
        if (zoom <= 0.0 || zoom == 1.0) {
            return;
        }
        Integer numElem = (Integer)request.getExtendedData().get("SELECTED_ELEM_NUM");
        if (numElem == null) {
            return;
        }
        if (numElem != 1) {
            zoom = 1.0 - (1.0 - zoom) / (double)numElem.intValue();
            zoom = Math.floor(zoom * (double)ZOOM_ALIGN_FACTOR) / (double)ZOOM_ALIGN_FACTOR;
        }
        request.setMoveDelta(ZoomUIUtils.screenToInternalPoint(request.getMoveDelta(), zoom));
        request.setSizeDelta(ZoomUIUtils.screenToInternalDimension(request.getSizeDelta(), zoom));
        Point reqPoint = request.getMoveDelta();
        SnapToGridUtils.snapToGrid(reqPoint, (int)Math.round(12.0 * zoom));
    }

    public static Point screenToInternalPoint(Point pos, double zoom) {
        org.fortiss.tooling.base.model.layout.Point modelPoint = LayoutModelElementFactory.createPoint((int)pos.x(), (int)pos.y(), (String)pos.toString());
        modelPoint = ZoomUtils.screenToInternalPoint((org.fortiss.tooling.base.model.layout.Point)modelPoint, (double)zoom);
        pos.setLocation(modelPoint.getX(), modelPoint.getY());
        return pos;
    }

    public static Point internalToScreenPoint(Point pos, double zoom) {
        org.fortiss.tooling.base.model.layout.Point modelPoint = LayoutModelElementFactory.createPoint((int)pos.x(), (int)pos.y(), (String)pos.toString());
        modelPoint = ZoomUtils.internalToScreenPoint((org.fortiss.tooling.base.model.layout.Point)modelPoint, (double)zoom);
        pos.setLocation(modelPoint.getX(), modelPoint.getY());
        return pos;
    }

    public static Dimension screenToInternalDimension(Dimension dim, double zoom) {
        org.fortiss.tooling.base.model.layout.Dimension modelDim = LayoutModelElementFactory.createDimension((int)dim.width(), (int)dim.height(), (String)dim.toString());
        modelDim = ZoomUtils.screenToInternalDimension((org.fortiss.tooling.base.model.layout.Dimension)modelDim, (double)zoom);
        dim.setSize(modelDim.getWidth(), modelDim.getHeight());
        return dim;
    }
}

