/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.viewers;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.tooling.base.utils.SystemUtils;

public abstract class CheckBoxLabelProvider
extends ColumnLabelProvider {
    private static final String CHECKED_KEY = "CHECKED";
    private static final String UNCHECKED_KEY = "UNCHECKED";
    private static final String DISABLED_UNCHECKED_KEY = "DISABLED_UNCHECKED";
    private static final String DISABLED_CHECKED_KEY = "DISABLED_CHECKED";
    public static final String UNCHECKED_LABEL = "\u25a1";
    public static final String CHECKED_LABEL = "\u2612";

    public static boolean useTextIcon() {
        return SystemUtils.isMacOSXPlatform() || SystemUtils.isLinuxPlatform();
    }

    private static Image makeShot(boolean selected, boolean enabled) {
        Shell shell = new Shell(8);
        Display display = shell.getDisplay();
        Color greenScreen = new Color((Device)display, 222, 223, 224);
        shell.setBackground(greenScreen);
        Button button = new Button((Composite)shell, 32);
        button.setBackground(greenScreen);
        button.setSelection(selected);
        button.setEnabled(enabled);
        button.setLocation(1, 1);
        Point bsize = button.computeSize(-1, -1);
        bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
        bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
        button.setSize(bsize);
        shell.setSize(bsize);
        shell.open();
        if (Platform.getBundle((String)"org.eclipse.swt.gtk.linux.x86_64") != null || Platform.getBundle((String)"org.eclipse.swt.gtk.linux.x86") != null) {
            Shell shellGtkQuirk = new Shell(shell, 8);
            shellGtkQuirk.open();
            shellGtkQuirk.close();
        }
        GC gc = new GC((Drawable)shell);
        Image image = new Image((Device)display, bsize.x, bsize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        shell.close();
        ImageData imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(greenScreen.getRGB());
        image.dispose();
        greenScreen.dispose();
        return new Image((Device)display, imageData);
    }

    public static Image getImage(boolean checked, boolean enabled) {
        if (CheckBoxLabelProvider.useTextIcon()) {
            return null;
        }
        ImageRegistry imgReg = JFaceResources.getImageRegistry();
        if (imgReg.getDescriptor(CHECKED_KEY) == null) {
            imgReg.put(UNCHECKED_KEY, CheckBoxLabelProvider.makeShot(false, true));
            imgReg.put(CHECKED_KEY, CheckBoxLabelProvider.makeShot(true, true));
            imgReg.put(DISABLED_UNCHECKED_KEY, CheckBoxLabelProvider.makeShot(false, false));
            imgReg.put(DISABLED_CHECKED_KEY, CheckBoxLabelProvider.makeShot(true, false));
        }
        if (enabled) {
            return checked ? imgReg.get(CHECKED_KEY) : imgReg.get(UNCHECKED_KEY);
        }
        return checked ? imgReg.get(DISABLED_CHECKED_KEY) : imgReg.get(DISABLED_UNCHECKED_KEY);
    }

    public Image getImage(Object element) {
        return CheckBoxLabelProvider.getImage(this.isChecked(element), this.isEnabled(element));
    }

    public String getText(Object element) {
        if (CheckBoxLabelProvider.useTextIcon() && this.isEnabled(element)) {
            return this.isChecked(element) ? CHECKED_LABEL : UNCHECKED_LABEL;
        }
        return null;
    }

    protected abstract boolean isChecked(Object var1);

    protected abstract boolean isEnabled(Object var1);
}

