/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task;

import org.eclipse.core.runtime.Plugin;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Receiver;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.Transceiver;
import org.fortiss.af3.platform.model.Transmitter;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.platform.model.generic.GenericExecutionUnit;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.TaskPort;
import org.fortiss.af3.task.model.TaskQueuingInputPort;
import org.fortiss.af3.task.model.TaskQueuingOutputPort;
import org.fortiss.af3.task.model.TaskSamplingInputPort;
import org.fortiss.af3.task.model.TaskSamplingOutputPort;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.model.allocation.InputPortToTaskInputPortAllocationEntry;
import org.fortiss.af3.task.model.allocation.OutputPortToTaskOutputPortAllocationEntry;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskInputPortToReceiverAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskMemoryAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskOutputPortMemoryAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskOutputPortToTransmitterAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskPortToTransceiverAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskWcetEntry;
import org.fortiss.af3.task.model.allocation.TaskWcetTable;
import org.fortiss.af3.task.model.timing.SignalReceiveEvent;
import org.fortiss.af3.task.model.timing.SignalSendEvent;
import org.fortiss.af3.task.model.timing.TaskStartEvent;
import org.fortiss.af3.task.model.timing.TaskTerminateEvent;
import org.fortiss.af3.task.quality.AllocationTableMetricProvider;
import org.fortiss.af3.task.reuse.TaskReuseProvider;
import org.fortiss.af3.task.variability.TaskDependingElementProvider;
import org.fortiss.af3.timing.ITimingSpecificationService;
import org.fortiss.tooling.ext.quality.data.MetricKey;
import org.fortiss.tooling.ext.quality.service.IMetricProvider;
import org.fortiss.tooling.ext.quality.service.IModelQualityService;
import org.fortiss.tooling.ext.reuse.service.IReuseProvider;
import org.fortiss.tooling.ext.reuse.service.IReuseProviderService;
import org.fortiss.tooling.ext.variability.service.IDependingElementProvider;
import org.fortiss.tooling.ext.variability.service.IDependingElementProviderService;
import org.osgi.framework.BundleContext;

public class AF3TaskActivator
extends Plugin {
    public static final String PLUGIN_ID = AF3TaskActivator.class.getPackage().getName();
    private static AF3TaskActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.setupComponentToTaskAllocations();
        this.setupTaskToExecutionUnitAllocations();
        this.setupWcetTables();
        this.setupMemoryTables();
        this.setupCoveredAllocations();
        this.setupTimingSpecificationModel();
        IReuseProviderService rps = IReuseProviderService.getInstance();
        rps.registerReuseProvider((IReuseProvider)new TaskReuseProvider(), Task.class);
        IModelQualityService mqs = IModelQualityService.getInstance();
        mqs.registerMetricKey("TASK_ALLOCATED_COMPONENTS", MetricKey.MetricKeyType.METRIC_KEY_INTEGER, false);
        mqs.registerMetricKey("EXECUTION_UNIT_ALLOCATED_TASKS", MetricKey.MetricKeyType.METRIC_KEY_INTEGER, false);
        mqs.registerMetricProvider((IMetricProvider)new AllocationTableMetricProvider(), AllocationTable.class);
        IDependingElementProviderService.getInstance().registerDependingElementProvider((IDependingElementProvider)new TaskDependingElementProvider(), Task.class);
    }

    private void setupComponentToTaskAllocations() {
        IAllocationService as = IAllocationService.getInstance();
        as.addAllocationTableType(ComponentToTaskAllocationTable.class, ComponentArchitecture.class, TaskArchitecture.class);
        as.addAllocationEntryType(ComponentToTaskAllocationTable.class, ComponentToTaskAllocationEntry.class, Component.class, Task.class);
        as.addAllocationEntryType(ComponentToTaskAllocationTable.class, InputPortToTaskInputPortAllocationEntry.class, InputPort.class, TaskInputPort.class, ComponentToTaskAllocationEntry.class);
        as.addAllocationEntryType(ComponentToTaskAllocationTable.class, OutputPortToTaskOutputPortAllocationEntry.class, OutputPort.class, TaskOutputPort.class, ComponentToTaskAllocationEntry.class);
    }

    private void setupTaskToExecutionUnitAllocations() {
        IAllocationService as = IAllocationService.getInstance();
        as.addAllocationTableType(TaskToExecutionUnitAllocationTable.class, TaskArchitecture.class, PlatformArchitecture.class);
        as.addAllocationEntryType(TaskToExecutionUnitAllocationTable.class, TaskToExecutionUnitAllocationEntry.class, Task.class, GenericExecutionUnit.class);
        as.addAllocationEntryType(TaskToExecutionUnitAllocationTable.class, TaskInputPortToReceiverAllocationEntry.class, TaskInputPort.class, Receiver.class, TaskToExecutionUnitAllocationEntry.class);
        as.addAllocationEntryType(TaskToExecutionUnitAllocationTable.class, TaskOutputPortToTransmitterAllocationEntry.class, TaskOutputPort.class, Transmitter.class, TaskToExecutionUnitAllocationEntry.class);
        as.addAllocationEntryType(TaskToExecutionUnitAllocationTable.class, TaskPortToTransceiverAllocationEntry.class, TaskPort.class, Transceiver.class, TaskToExecutionUnitAllocationEntry.class);
        as.addSourceEntityMutualEntryTypeExclusion(TaskPortToTransceiverAllocationEntry.class, TaskInputPortToReceiverAllocationEntry.class);
        as.addSourceEntityMutualEntryTypeExclusion(TaskPortToTransceiverAllocationEntry.class, TaskOutputPortToTransmitterAllocationEntry.class);
        as.addAllocationEntryType(TaskToExecutionUnitAllocationTable.class, SignalToRouteAllocationEntry.class, Signal.class, Route.class);
    }

    private void setupWcetTables() {
        IAllocationService as = IAllocationService.getInstance();
        as.addAllocationTableType(TaskWcetTable.class, TaskArchitecture.class, PlatformArchitecture.class, true);
        as.addAllocationEntryType(TaskWcetTable.class, TaskWcetEntry.class, Task.class, GenericExecutionUnit.class);
        as.addAdmissibleAllocationTablePair(TaskWcetTable.class, TaskToExecutionUnitAllocationTable.class);
    }

    private void setupMemoryTables() {
        IAllocationService as = IAllocationService.getInstance();
        as.addAllocationTableType(TaskMemoryAllocationTable.class, TaskArchitecture.class, PlatformArchitecture.class, true);
        as.addAdmissibleAllocationTablePair(TaskMemoryAllocationTable.class, TaskToExecutionUnitAllocationTable.class);
        as.addAdmissibleAllocationTablePair(TaskMemoryAllocationTable.class, TaskWcetTable.class);
        as.addSourceEntityMutualEntryTypeExclusion(TaskOutputPortMemoryAllocationEntry.class, TaskOutputPortMemoryAllocationEntry.class);
    }

    private void setupCoveredAllocations() {
        IAllocationService as = IAllocationService.getInstance();
        as.addCoveredModelType(ComponentToExecutionUnitAllocationTable.class, TaskArchitecture.class);
    }

    private void setupTimingSpecificationModel() {
        ITimingSpecificationService tss = ITimingSpecificationService.getInstance();
        tss.addRootElementType(TaskArchitecture.class);
        tss.addEntityEventElementType(TaskStartEvent.class, Task.class);
        tss.addEventTypeName(TaskStartEvent.class, "Task started");
        tss.addEntityEventElementType(TaskTerminateEvent.class, Task.class);
        tss.addEventTypeName(TaskTerminateEvent.class, "Task terminated");
        tss.addEntityEventElementType(SignalSendEvent.class, TaskQueuingOutputPort.class);
        tss.addEntityEventElementType(SignalSendEvent.class, TaskSamplingOutputPort.class);
        tss.addEventTypeName(SignalSendEvent.class, "Task Signal sent");
        tss.addEntityEventElementType(SignalReceiveEvent.class, TaskQueuingInputPort.class);
        tss.addEntityEventElementType(SignalReceiveEvent.class, TaskSamplingInputPort.class);
        tss.addEventTypeName(SignalReceiveEvent.class, "Task Signal received");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AF3TaskActivator getDefault() {
        return plugin;
    }
}

