/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task.compositor;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.TaskQueuingInputPort;
import org.fortiss.af3.task.model.TaskQueuingOutputPort;
import org.fortiss.af3.task.model.TaskSamplingInputPort;
import org.fortiss.af3.task.model.TaskSamplingOutputPort;
import org.fortiss.af3.task.util.TaskModelElementFactory;
import org.fortiss.tooling.base.compose.ConnectionCompositorBase;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class TaskConnectionCompositor
extends ConnectionCompositorBase<IHierarchicElement, EObject, EObject> {
    public boolean canConnect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        return target instanceof TaskQueuingInputPort && source instanceof TaskQueuingOutputPort || target instanceof TaskSamplingInputPort && source instanceof TaskSamplingOutputPort;
    }

    public boolean connect(EObject source, EObject target, IHierarchicElement parent, IConnectionCompositionContext context) {
        TaskArchitecture taskArchitecture = (TaskArchitecture)parent;
        EList<Signal> signals = taskArchitecture.getSignals();
        boolean isSignalExisiting = signals.stream().anyMatch(s -> s.getSource().equals(source) && s.getTarget().equals(target));
        if (isSignalExisiting) {
            return false;
        }
        Signal connection = this.createConnection();
        UniqueIDUtils.prepareUniqueID((EObject)connection, (EObject)parent);
        taskArchitecture.getConnections().add((Object)connection);
        connection.setSource((IConnector)source);
        connection.setTarget((IConnector)target);
        return true;
    }

    protected Signal createConnection() {
        return TaskModelElementFactory.createSignal("Signal");
    }

    public boolean canDisconnect(EObject connection) {
        return connection instanceof Signal;
    }
}

