/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task.generator.fmu;

import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.ManyToOneAllocationEntry;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.generator.common.model.fmu.AF3GeneratorCommonFMUFactory;
import org.fortiss.af3.generator.common.model.fmu.FMUArchivePackage;
import org.fortiss.af3.generator.common.model.fmu.FMUConnection;
import org.fortiss.af3.generator.common.model.fmu.FMUMultiArchivePackage;
import org.fortiss.af3.generator.common.model.fmu.IFMUVariable;
import org.fortiss.af3.generator.common.utils.FMUUtils;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.af3.project.utils.TypeScopeUtils;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.TaskPort;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.model.allocation.InputPortToTaskInputPortAllocationEntry;
import org.fortiss.af3.task.model.allocation.OutputPortToTaskOutputPortAllocationEntry;
import org.fortiss.tooling.kernel.extension.ITransformationProvider;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class ComponentToTaskAllocationToFMUMultiArchivePackageTransformation
implements ITransformationProvider {
    public Class<?> getTargetClass() {
        return FMUMultiArchivePackage.class;
    }

    public boolean canHandleChainTransformation(Class<?> sourceClass, ITransformationContext context) {
        return ComponentToTaskAllocationTable.class.isAssignableFrom(sourceClass);
    }

    public boolean canTransform(Object source, ITransformationContext context) {
        if (!(source instanceof ComponentToTaskAllocationTable)) {
            return false;
        }
        ComponentToTaskAllocationTable table = (ComponentToTaskAllocationTable)source;
        boolean hasCorrectTaskAllocation = table.getTasks().stream().allMatch(task -> table.getComponents((Task)task).size() == 1);
        boolean hasCorrectTaskPortAllocation = table.getAllocationEntries(ManyToOneAllocationEntry.class).stream().filter(entry -> entry.getTargetElement() instanceof TaskPort).allMatch(entry -> entry.getSourceElements().size() == 1);
        return hasCorrectTaskAllocation && hasCorrectTaskPortAllocation;
    }

    public Object transform(Object source, ITransformationContext context) throws TransformationFailedException {
        ComponentToTaskAllocationTable table = (ComponentToTaskAllocationTable)source;
        FMUMultiArchivePackage fmuMultiPackage = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUMultiArchivePackage();
        for (Task task : table.getTaskArchitecture().getTasks()) {
            Component component = this.getComponentToTransform(table, task);
            FMUArchivePackage slave = (FMUArchivePackage)TransformationUtils.createTransformedObjectFor((EObject)component, FMUArchivePackage.class, (ITransformationContext)context);
            slave.getModelDescription().setName(FMUUtils.toLegalName((String)task.getName()));
            fmuMultiPackage.getSlaves().add((Object)slave);
        }
        this.addConnections(table, fmuMultiPackage);
        this.addPortMaps(table, fmuMultiPackage);
        return fmuMultiPackage;
    }

    private void addConnections(ComponentToTaskAllocationTable table, FMUMultiArchivePackage fmuMultiPackage) throws TransformationFailedException {
        for (Task task : table.getTaskArchitecture().getTasks()) {
            ITypeDefinition portTypeDefinition;
            Component component = this.getComponentToTransform(table, task);
            for (TaskOutputPort taskOutputPort : task.getTaskOutputPorts()) {
                OutputPort outputPort = this.getOutputPortToTransform(table, taskOutputPort);
                portTypeDefinition = TypeScopeUtils.getTypeDefinition((IType)outputPort.getVariableType(), (EObject)component);
                if (portTypeDefinition instanceof Structure) {
                    for (StructureMember member : ((Structure)portTypeDefinition).getMembers()) {
                        this.createInnerAndOutgoingConnections(table, fmuMultiPackage, taskOutputPort, member);
                    }
                    continue;
                }
                this.createInnerAndOutgoingConnections(table, fmuMultiPackage, taskOutputPort);
            }
            for (TaskInputPort taskInputPort : task.getTaskInputPorts()) {
                InputPort inputPort = this.getInputPortToTransform(table, taskInputPort);
                portTypeDefinition = TypeScopeUtils.getTypeDefinition((IType)inputPort.getVariableType(), (EObject)component);
                if (portTypeDefinition instanceof Structure) {
                    for (StructureMember member : ((Structure)portTypeDefinition).getMembers()) {
                        this.createIncomingConnections(table, fmuMultiPackage, taskInputPort, member);
                    }
                    continue;
                }
                this.createIncomingConnections(table, fmuMultiPackage, taskInputPort);
            }
        }
    }

    private OutputPort getOutputPortToTransform(ComponentToTaskAllocationTable table, TaskOutputPort taskOutputPort) throws TransformationFailedException {
        Task task = taskOutputPort.getTask();
        Component component = this.getComponentToTransform(table, task);
        Optional<OutputPort> optionalPort = component.getOutputPorts().stream().filter(port -> table.getTaskOutputPorts((OutputPort)port).contains((Object)taskOutputPort)).findAny();
        if (!optionalPort.isPresent()) {
            throw new TransformationFailedException(String.format("The output port %s of task %s must have a logical port allocated to it.", taskOutputPort.getName(), task.getName()), (ITransformationProvider)this, null, null);
        }
        return optionalPort.get();
    }

    private InputPort getInputPortToTransform(ComponentToTaskAllocationTable table, TaskInputPort taskInputPort) throws TransformationFailedException {
        Task task = taskInputPort.getTask();
        Component component = this.getComponentToTransform(table, task);
        Optional<InputPort> optionalPort = component.getInputPorts().stream().filter(port -> table.getTaskInputPorts((InputPort)port).contains((Object)taskInputPort)).findAny();
        if (!optionalPort.isPresent()) {
            throw new TransformationFailedException(String.format("The input port %s of task %s must have a logical port allocated to it.", taskInputPort.getName(), task.getName()), (ITransformationProvider)this, null, null);
        }
        return optionalPort.get();
    }

    private Component getComponentToTransform(ComponentToTaskAllocationTable table, Task task) throws TransformationFailedException {
        boolean hasExactlyOneComponent;
        EList<Component> components = table.getComponents(task);
        boolean bl = hasExactlyOneComponent = components.size() == 1;
        if (!hasExactlyOneComponent) {
            throw new TransformationFailedException(String.format("The task %s must have exactly one logical component allocated to it.", task.getName()), (ITransformationProvider)this, null, null);
        }
        return (Component)components.get(0);
    }

    private void createIncomingConnections(ComponentToTaskAllocationTable table, FMUMultiArchivePackage fmuMultiPackage, TaskInputPort taskInputPort) throws TransformationFailedException {
        this.createIncomingConnections(table, fmuMultiPackage, taskInputPort, null);
    }

    private void createIncomingConnections(ComponentToTaskAllocationTable table, FMUMultiArchivePackage fmuMultiPackage, TaskInputPort taskInputPort, StructureMember member) throws TransformationFailedException {
        boolean isIncoming;
        boolean bl = isIncoming = taskInputPort.getIncomingSignal() == null;
        if (isIncoming) {
            IFMUVariable variable = this.getVariable(table, fmuMultiPackage, taskInputPort, member);
            fmuMultiPackage.getIncomingConnections().add((Object)variable);
        }
    }

    private void createInnerAndOutgoingConnections(ComponentToTaskAllocationTable table, FMUMultiArchivePackage fmuMultiPackage, TaskOutputPort taskOutputPort) throws TransformationFailedException {
        this.createInnerAndOutgoingConnections(table, fmuMultiPackage, taskOutputPort, null);
    }

    private void createInnerAndOutgoingConnections(ComponentToTaskAllocationTable table, FMUMultiArchivePackage fmuMultiPackage, TaskOutputPort taskOutputPort, StructureMember member) throws TransformationFailedException {
        IFMUVariable source = this.getVariable(table, fmuMultiPackage, taskOutputPort, member);
        FMUConnection innerConnection = AF3GeneratorCommonFMUFactory.eINSTANCE.createFMUConnection();
        innerConnection.setSource(source);
        boolean isOutgoing = taskOutputPort.getOutGoingSignals().isEmpty();
        if (isOutgoing) {
            fmuMultiPackage.getOutgoingConnections().add((Object)source);
        } else {
            for (Signal signal : taskOutputPort.getOutGoingSignals()) {
                TaskInputPort taskInputPort = signal.getTargetTaskPort();
                IFMUVariable sink = this.getVariable(table, fmuMultiPackage, taskInputPort, member);
                innerConnection.getSinks().add((Object)sink);
            }
        }
        if (innerConnection.getSinks().size() != 0) {
            fmuMultiPackage.getSlaveConnections().add((Object)innerConnection);
        }
    }

    private IFMUVariable getVariable(ComponentToTaskAllocationTable table, FMUMultiArchivePackage fmuMultiPackage, TaskPort taskPort, StructureMember member) throws TransformationFailedException {
        IFMUVariable fmuVariable;
        Port componentPort = (Port)table.getAllocationEntries(ManyToOneAllocationEntry.class).stream().filter(entry -> entry.getTargetElement() == taskPort).findAny().get().getSourceElements().stream().findAny().get();
        String packageName = FMUUtils.toLegalName((String)taskPort.getTask().getName());
        String variableName = componentPort.getName() + (String)(member != null ? "__" + member.getName() : "");
        FMUArchivePackage fmuPackage = fmuMultiPackage.getSlaves().stream().filter(slave -> slave.getModelDescription().getName().equals(packageName)).findAny().get();
        try {
            fmuVariable = Streams.concat((Stream[])new Stream[]{fmuPackage.getInputs().stream(), fmuPackage.getOutputs().stream()}).filter(variable -> variable.getName().equals(variableName)).findAny().get();
        }
        catch (NoSuchElementException e) {
            throw new TransformationFailedException("Matching port " + variableName + " for component " + ((INamedElement)componentPort.eContainer()).getName() + " was not found. Please make sure there is no other identical named component in the Component Architecture.", (ITransformationProvider)this, null, null);
        }
        return fmuVariable;
    }

    private void addPortMaps(ComponentToTaskAllocationTable table, FMUMultiArchivePackage fmuMultiPackage) {
        fmuMultiPackage.setInputStructures(new HashMap());
        fmuMultiPackage.setOutputStructures(new HashMap());
        table.getAllocationEntries(InputPortToTaskInputPortAllocationEntry.class).stream().flatMap(entry -> entry.getInputPorts().stream()).forEach(port -> {
            ITypeDefinition typeDefinition = TypeScopeUtils.getTypeDefinition((IType)port.getVariableType(), (EObject)port.eContainer());
            if (typeDefinition instanceof Structure) {
                fmuMultiPackage.getInputStructures().put(port.getName(), typeDefinition);
            }
        });
        table.getAllocationEntries(OutputPortToTaskOutputPortAllocationEntry.class).stream().flatMap(entry -> entry.getOutputPorts().stream()).forEach(port -> {
            ITypeDefinition typeDefinition = TypeScopeUtils.getTypeDefinition((IType)port.getVariableType(), (EObject)port.eContainer());
            if (typeDefinition instanceof Structure) {
                fmuMultiPackage.getOutputStructures().put(port.getName(), typeDefinition);
            }
        });
    }
}

