/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task.model.allocation.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.annotation.Frequency;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.TaskWcetEntry;
import org.fortiss.af3.task.model.allocation.TaskWcetTable;
import org.fortiss.af3.timing.model.annotation.Wcet;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class TaskWcetTableStaticImpl {
    public static BigDecimal getWcet(TaskWcetTable taskWcetTable, Task task, ExecutionUnit executionUnit, long frequency) {
        Frequency freq;
        BigDecimal wcet = TaskWcetTableStaticImpl.getWcet(taskWcetTable, task, executionUnit);
        if (wcet == null) {
            wcet = TaskWcetTableStaticImpl.getWcet(task);
        }
        if ((freq = (Frequency)AnnotationUtils.getAnnotation((IModelElement)executionUnit, Frequency.class)) == null || freq.getBaseFrequencyHz() == null) {
            return wcet;
        }
        Long baseFrequency = freq.getBaseFrequencyHz();
        if (!freq.getFrequenciesHz().contains((Object)frequency)) {
            return null;
        }
        return wcet.multiply(BigDecimal.valueOf(baseFrequency)).divide(BigDecimal.valueOf(frequency), RoundingMode.HALF_UP);
    }

    public static BigDecimal getWcet(TaskWcetTable taskWcetTable, Task task, ExecutionUnit executionUnit) {
        Wcet wcet = (Wcet)taskWcetTable.getParameter((IModelElement)task, (IModelElement)executionUnit, TaskWcetEntry.class, Wcet.class);
        return wcet != null ? wcet.getValue() : null;
    }

    public static BigDecimal getWcet(Task task) {
        return ((Wcet)AnnotationUtils.getAnnotation((IModelElement)task, Wcet.class)).getValue();
    }

    public static TaskArchitecture getTaskArchitecture(TaskWcetTable taskWcetTable) {
        return (TaskArchitecture)taskWcetTable.getSourceView();
    }

    public static PlatformArchitecture getPlatformArchitecture(TaskWcetTable taskWcetTable) {
        return (PlatformArchitecture)taskWcetTable.getTargetView();
    }

    public static EList<Task> getTasks(TaskWcetTable taskWcetTable) {
        return EcoreUtils.convertList(Task.class, (EList)taskWcetTable.getSourceElements(TaskWcetEntry.class));
    }

    public static EList<ExecutionUnit> getExecutionUnits(TaskWcetTable taskWcetTable) {
        return EcoreUtils.convertList(ExecutionUnit.class, (EList)taskWcetTable.getTargetElements(TaskWcetEntry.class));
    }
}

