/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task.model.impl;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.IQueuingPort;
import org.fortiss.af3.platform.model.ISamplingPort;
import org.fortiss.af3.platform.model.annotation.Frequency;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.TaskPort;
import org.fortiss.af3.task.model.TaskQueuingInputPort;
import org.fortiss.af3.task.model.TaskQueuingOutputPort;
import org.fortiss.af3.task.model.TaskSamplingInputPort;
import org.fortiss.af3.task.model.TaskSamplingOutputPort;
import org.fortiss.af3.task.model.allocation.TaskWcetTable;
import org.fortiss.af3.task.model.timing.TaskStartEvent;
import org.fortiss.af3.timing.model.TimingSpecification;
import org.fortiss.af3.timing.model.annotation.Wcet;
import org.fortiss.af3.timing.utils.TimingUtils;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class TaskStaticImpl {
    public static EList<TaskPort> getTaskPorts(Task task) {
        return EcoreUtils.pickInstanceOf(TaskPort.class, (List)task.getConnectors());
    }

    public static EList<TaskInputPort> getTaskInputPorts(Task task) {
        return EcoreUtils.pickInstanceOf(TaskInputPort.class, (List)task.getConnectors());
    }

    public static EList<TaskOutputPort> getTaskOutputPorts(Task task) {
        return EcoreUtils.pickInstanceOf(TaskOutputPort.class, (List)task.getConnectors());
    }

    public static EList<ISamplingPort> getTaskSamplingPorts(Task task) {
        return EcoreUtils.pickInstanceOf(ISamplingPort.class, (List)task.getConnectors());
    }

    public static EList<TaskSamplingInputPort> getTaskSamplingInputPorts(Task task) {
        return EcoreUtils.pickInstanceOf(TaskSamplingInputPort.class, (List)task.getConnectors());
    }

    public static EList<TaskSamplingOutputPort> getTaskSamplingOuptutPorts(Task task) {
        return EcoreUtils.pickInstanceOf(TaskSamplingOutputPort.class, (List)task.getConnectors());
    }

    public static EList<IQueuingPort> getTaskQueuingPorts(Task task) {
        return EcoreUtils.pickInstanceOf(IQueuingPort.class, (List)task.getConnectors());
    }

    public static EList<TaskQueuingInputPort> getTaskQueuingInputPorts(Task task) {
        return EcoreUtils.pickInstanceOf(TaskQueuingInputPort.class, (List)task.getConnectors());
    }

    public static EList<TaskQueuingOutputPort> getTaskQueuingOutputPorts(Task task) {
        return EcoreUtils.pickInstanceOf(TaskQueuingOutputPort.class, (List)task.getConnectors());
    }

    public static TaskArchitecture getTaskArchitecture(Task task) {
        return (TaskArchitecture)task.eContainer();
    }

    public static BigDecimal getPeriod(Task task, TimingSpecification ts) {
        return TimingUtils.getPeriod((TimingSpecification)ts, (IModelElement)task, TaskStartEvent.class);
    }

    public static void setPeriod(Task task, TimingSpecification ts, BigDecimal period) {
        TimingUtils.setPeriod((TimingSpecification)ts, (IModelElement)task, TaskStartEvent.class, (BigDecimal)period);
    }

    public static BigDecimal getWcet(Task task, ExecutionUnit executionUnit, long frequency) {
        BigDecimal wcet = TaskStaticImpl.getWcet(task, executionUnit);
        if (wcet == null) {
            return null;
        }
        Frequency freq = (Frequency)AnnotationUtils.getAnnotation((IModelElement)executionUnit, Frequency.class);
        Long baseFrequency = freq.getBaseFrequencyHz();
        if (baseFrequency == null || !freq.getFrequenciesHz().contains((Object)frequency)) {
            return null;
        }
        return wcet.multiply(BigDecimal.valueOf(frequency)).divide(BigDecimal.valueOf(baseFrequency));
    }

    public static BigDecimal getWcet(Task task, ExecutionUnit executionUnit) {
        TaskWcetTable wcetTable = task.getTaskArchitecture().getWcetTable();
        BigDecimal wcet = null;
        if (wcetTable != null) {
            wcet = wcetTable.getWcet(task, executionUnit);
        }
        return wcet != null ? wcet : TaskStaticImpl.getWcet(task);
    }

    public static BigDecimal getWcet(Task task) {
        return ((Wcet)AnnotationUtils.getAnnotation((IModelElement)task, Wcet.class)).getValue();
    }
}

