/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task.quality;

import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.tooling.ext.quality.data.MetricData;
import org.fortiss.tooling.ext.quality.data.MetricKey;
import org.fortiss.tooling.ext.quality.data.MetricTreeNode;
import org.fortiss.tooling.ext.quality.service.IMetricProvider;
import org.fortiss.tooling.ext.quality.service.IModelQualityService;

public class AllocationTableMetricProvider
implements IMetricProvider<AllocationTable> {
    public void collectMetrics(MetricTreeNode dictNode, AllocationTable allocTable) {
        MetricTreeNode node;
        IModelQualityService mqs = IModelQualityService.getInstance();
        MetricData metricData = mqs.getMetricData();
        MetricKey TASK_ALLOCATED_COMPONENTS = mqs.getMetricKey("TASK_ALLOCATED_COMPONENTS");
        MetricKey EXECUTION_UNIT_ALLOCATED_TASKS = mqs.getMetricKey("EXECUTION_UNIT_ALLOCATED_TASKS");
        for (Object allocEntry : allocTable.getAllocationEntries(ComponentToTaskAllocationEntry.class)) {
            Task task = allocEntry.getTask();
            if (task == null) continue;
            node = (MetricTreeNode)metricData.getTreeNodeLookupTable().get(task);
            node.getIntegerMetrics().put(TASK_ALLOCATED_COMPONENTS, allocEntry.getComponents().size());
        }
        for (Object allocEntry : allocTable.getAllocationEntries(TaskToExecutionUnitAllocationEntry.class)) {
            ExecutionUnit ecu = allocEntry.getExecutionUnit();
            if (ecu == null) continue;
            node = (MetricTreeNode)metricData.getTreeNodeLookupTable().get(ecu);
            node.getIntegerMetrics().put(EXECUTION_UNIT_ALLOCATED_TASKS, allocEntry.getTasks().size());
        }
    }
}

