/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task.util;

import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.utils.ComponentArchitectureTransformationBase;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.model.allocation.InputPortToTaskInputPortAllocationEntry;
import org.fortiss.af3.task.model.allocation.OutputPortToTaskOutputPortAllocationEntry;
import org.fortiss.af3.task.util.TaskModelElementFactory;

public class ComponentToTaskArchitectureTransformation
extends ComponentArchitectureTransformationBase<TaskArchitecture, ComponentToTaskAllocationTable, Task, TaskInputPort, TaskOutputPort, Signal, ComponentToTaskAllocationEntry, InputPortToTaskInputPortAllocationEntry, OutputPortToTaskOutputPortAllocationEntry> {
    public ComponentToTaskArchitectureTransformation() {
        super(ComponentToTaskAllocationEntry.class, InputPortToTaskInputPortAllocationEntry.class, OutputPortToTaskOutputPortAllocationEntry.class);
    }

    protected TaskArchitecture createEntityArchitecture(Component component) {
        return TaskModelElementFactory.createTaskArchitecture("Task Architecture (generated for: " + component.getName() + ")");
    }

    protected ComponentToTaskAllocationTable createAllocationTable(TaskArchitecture taskArchitecture, ComponentArchitecture componentArchitecture, AllocationTableCollection atc) {
        return TaskModelElementFactory.createComponentToTaskAllocationTable(componentArchitecture.getTopComponent().getName() + "\u2192" + taskArchitecture.getName());
    }

    protected Task createEntity(Component comp) {
        return TaskModelElementFactory.createTask("Task_" + comp.getName());
    }

    protected TaskOutputPort createEntityOutputPort(OutputPort outputPort) {
        return TaskModelElementFactory.createTaskSamplingOutputPort(outputPort.getName());
    }

    protected TaskInputPort createEntityInputPort(InputPort inputPort) {
        return TaskModelElementFactory.createTaskSamplingInputPort(inputPort.getName());
    }

    protected Signal createEntityConnection(TaskOutputPort taskOutputPort, TaskInputPort taskInputPort) {
        String signalName = "Signal " + taskOutputPort.getName() + "\u2192" + taskInputPort.getName();
        return TaskModelElementFactory.createSignal(taskOutputPort, taskInputPort, signalName);
    }

    protected Task getEntity(Component comp, ComponentToTaskAllocationTable ca2ta) {
        EList<Task> tasks = ca2ta.getTasks(comp);
        if (tasks.size() != 1) {
            throw new RuntimeException("The component-to-task architecture transformation should map each logical component to one task.");
        }
        return (Task)tasks.get(0);
    }

    protected TaskInputPort getEntityInputPort(InputPort inputPort, ComponentToTaskAllocationTable ca2ta) {
        EList<TaskInputPort> taskInputPorts = ca2ta.getTaskInputPorts(inputPort);
        if (taskInputPorts.size() != 1) {
            throw new RuntimeException("The component-to-task architecture transformation should map each logical input port to one task input port.");
        }
        return (TaskInputPort)taskInputPorts.get(0);
    }

    protected TaskOutputPort getEntityOutputPort(OutputPort outputPort, ComponentToTaskAllocationTable ca2ta) {
        EList<TaskOutputPort> taskOutputPorts = ca2ta.getTaskOutputPorts(outputPort);
        if (taskOutputPorts.size() != 1) {
            throw new RuntimeException("The component-to-task architecture transformation should map each logical output port to one task output port.");
        }
        return (TaskOutputPort)taskOutputPorts.get(0);
    }
}

