/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.allocation.utils.AllocationModelElementFactory;
import org.fortiss.af3.allocation.utils.AllocationUtils;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Receiver;
import org.fortiss.af3.platform.model.Transceiver;
import org.fortiss.af3.platform.model.Transmitter;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationEntry;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.platform.model.allocation.InputPortToReceiverAllocationEntry;
import org.fortiss.af3.platform.model.allocation.OutputPortToTransmitterAllocationEntry;
import org.fortiss.af3.platform.model.allocation.PortToTransceiverAllocationEntry;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.TaskPort;
import org.fortiss.af3.task.model.TaskReplica;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationEntry;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.model.allocation.InputPortToTaskInputPortAllocationEntry;
import org.fortiss.af3.task.model.allocation.OutputPortToTaskOutputPortAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskInputPortToReceiverAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskOutputPortToTransmitterAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskPortToTransceiverAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.af3.task.util.ComponentToTaskArchitectureTransformation;
import org.fortiss.af3.task.util.TaskModelElementFactory;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class TaskArchitectureUtils {
    public static Collection<Port> getTaskInterfaces(Task task, ComponentToTaskAllocationTable ca2ta) {
        ArrayList<Port> result = new ArrayList<Port>();
        ArrayList inPorts = new ArrayList();
        ArrayList outPorts = new ArrayList();
        EList<Component> allocatedCsToTask = ca2ta.getComponents(task);
        allocatedCsToTask.stream().forEach(c -> {
            boolean bl = inPorts.addAll(c.getInputPorts());
        });
        allocatedCsToTask.stream().forEach(c -> {
            boolean bl = outPorts.addAll(c.getOutputPorts());
        });
        ArrayList<OutputPort> OPsToBeRemoved = new ArrayList<OutputPort>();
        for (OutputPort op : outPorts) {
            for (Channel ch : op.getOutgoingChannels()) {
                Port target = ch.getTarget();
                if (!inPorts.contains(target)) continue;
                inPorts.remove(target);
                OPsToBeRemoved.add(op);
            }
        }
        outPorts.removeAll(OPsToBeRemoved);
        result.addAll(inPorts);
        result.addAll(outPorts);
        return result;
    }

    public static TaskToExecutionUnitAllocationTable getTaskToExecutionUnitAllocationTable(AllocationTableCollection allocationTableCollection) {
        return (TaskToExecutionUnitAllocationTable)EcoreUtils.pickFirstInstanceOf(TaskToExecutionUnitAllocationTable.class, (List)allocationTableCollection.getContainedElements());
    }

    public static TaskToExecutionUnitAllocationTable createTaskToExecutionUnitAllocationTable(ComponentToExecutionUnitAllocationTable ca2hw, String name, ComponentToTaskArchitectureTransformation ca2taTrans) {
        FileProject fileProject = (FileProject)KernelModelElementUtils.getParentElement((EObject)ca2hw, FileProject.class, (boolean)false);
        if (ca2taTrans == null) {
            ca2taTrans = new ComponentToTaskArchitectureTransformation();
        }
        ComponentArchitecture ca = ca2hw.getComponentArchitecture();
        AllocationTableCollection atc = AllocationModelElementFactory.createAllocationTableCollection((String)"Allocations");
        TaskArchitecture ta = (TaskArchitecture)ca2taTrans.transform(ca.getTopComponent(), Collections.emptyList(), atc);
        PlatformArchitecture pa = ca2hw.getPlatformArchitecture();
        TaskToExecutionUnitAllocationTable ta2hw = TaskModelElementFactory.createTaskToExecutionUnitAllocationTable(name, ta, pa);
        atc.getContainedElements().add((Object)ta2hw);
        fileProject.getRootElements().add((Object)atc);
        fileProject.getRootElements().add((Object)ta);
        ComponentToTaskAllocationTable ca2ta = (ComponentToTaskAllocationTable)AllocationUtils.getOrCreateAllocationTable(ComponentToTaskAllocationTable.class, (IProjectRootElement)ca, (IProjectRootElement)ta, null);
        for (ComponentToExecutionUnitAllocationEntry entry : EcoreUtils.pickInstanceOf(ComponentToExecutionUnitAllocationEntry.class, (List)ca2hw.getAllocationEntries())) {
            ExecutionUnit executionUnit = entry.getExecutionUnit();
            for (Component component : entry.getComponents()) {
                for (Task task : ca2ta.getTasks(component)) {
                    AllocationUtils.addAllocationEntry((AllocationTable)ta2hw, TaskToExecutionUnitAllocationEntry.class, (IModelElement)task, (IModelElement)executionUnit);
                }
            }
        }
        for (ComponentToExecutionUnitAllocationEntry entry : EcoreUtils.pickInstanceOf(InputPortToReceiverAllocationEntry.class, (List)ca2hw.getAllocationEntries())) {
            Receiver receiver = entry.getReceiver();
            for (InputPort inputPort : entry.getInputPorts()) {
                for (TaskInputPort taskInputPort : ca2ta.getTaskInputPorts(inputPort)) {
                    AllocationUtils.addAllocationEntry((AllocationTable)ta2hw, TaskInputPortToReceiverAllocationEntry.class, (IModelElement)taskInputPort, (IModelElement)receiver);
                }
            }
        }
        for (ComponentToExecutionUnitAllocationEntry entry : EcoreUtils.pickInstanceOf(OutputPortToTransmitterAllocationEntry.class, (List)ca2hw.getAllocationEntries())) {
            Transmitter transmitter = entry.getTransmitter();
            for (OutputPort outputPort : entry.getOutputPorts()) {
                for (TaskOutputPort taskOutputPort : ca2ta.getTaskOutputPorts(outputPort)) {
                    AllocationUtils.addAllocationEntry((AllocationTable)ta2hw, TaskOutputPortToTransmitterAllocationEntry.class, (IModelElement)taskOutputPort, (IModelElement)transmitter);
                }
            }
        }
        for (ComponentToExecutionUnitAllocationEntry entry : EcoreUtils.pickInstanceOf(PortToTransceiverAllocationEntry.class, (List)ca2hw.getAllocationEntries())) {
            Transceiver transceiver = entry.getTransceiver();
            for (Port port : entry.getPorts()) {
                List taskPorts = Collections.emptyList();
                if (port instanceof InputPort) {
                    taskPorts = ca2ta.getTaskInputPorts((InputPort)port);
                } else if (port instanceof OutputPort) {
                    taskPorts = ca2ta.getTaskOutputPorts((OutputPort)port);
                }
                for (TaskPort taskPort : taskPorts) {
                    AllocationUtils.addAllocationEntry((AllocationTable)ta2hw, TaskPortToTransceiverAllocationEntry.class, (IModelElement)taskPort, (IModelElement)transceiver);
                }
            }
        }
        return ta2hw;
    }

    public static Collection<ExecutionUnit> findTargetExecutionUnits(PlatformArchitecture platformArchitecture) {
        IAllocationService as = IAllocationService.getInstance();
        Collection ecuTypes = as.getTargetEntityTypes(TaskToExecutionUnitAllocationEntry.class);
        return EcoreUtils.getChildrenWithType((EObject)platformArchitecture, ExecutionUnit.class, (Collection)ecuTypes);
    }

    public static Task getTask(Component comp, Collection<ComponentToTaskAllocationEntry> allocations) {
        Optional<ComponentToTaskAllocationEntry> optionalAllocationEntry = allocations.stream().filter(allocation -> allocation.getComponents().contains((Object)comp)).findAny();
        if (optionalAllocationEntry.isPresent()) {
            return optionalAllocationEntry.get().getTask();
        }
        throw new NoSuchElementException();
    }

    public static List<Component> getComponents(Task task, Collection<ComponentToTaskAllocationEntry> allocations) {
        Optional<ComponentToTaskAllocationEntry> optionalAllocationEntry = allocations.stream().filter(allocation -> allocation.getTask() == task).findAny();
        if (optionalAllocationEntry.isPresent()) {
            return optionalAllocationEntry.get().getComponents();
        }
        throw new NoSuchElementException();
    }

    public static List<InputPort> getInputPorts(TaskInputPort tInPort, Collection<InputPortToTaskInputPortAllocationEntry> allocations) {
        Optional<InputPortToTaskInputPortAllocationEntry> optionalAllocationEntry = allocations.stream().filter(allocation -> allocation.getTaskInputPort() == tInPort).findAny();
        if (optionalAllocationEntry.isPresent()) {
            return optionalAllocationEntry.get().getInputPorts();
        }
        throw new NoSuchElementException();
    }

    public static List<OutputPort> getOutputPort(TaskOutputPort tOutPort, Collection<OutputPortToTaskOutputPortAllocationEntry> allocations) {
        Optional<OutputPortToTaskOutputPortAllocationEntry> optionalAllocationEntry = allocations.stream().filter(allocation -> allocation.getTaskOutputPort() == tOutPort).findAny();
        if (optionalAllocationEntry.isPresent()) {
            return optionalAllocationEntry.get().getOutputPorts();
        }
        throw new NoSuchElementException();
    }

    public static Map<Task, List<Task>> createTaskReplicaMap(Collection<Task> tasks) {
        HashMap<Task, List<Task>> replicaMap = new HashMap<Task, List<Task>>();
        for (Task task : tasks) {
            TaskReplica taskReplica = (TaskReplica)EcoreUtils.pickFirstInstanceOf(TaskReplica.class, (List)task.getSpecifications());
            if (taskReplica == null) continue;
            Task origTask = taskReplica.getOrig();
            ArrayList<Task> replicaList = (ArrayList<Task>)replicaMap.get(origTask);
            if (replicaList == null) {
                replicaList = new ArrayList<Task>();
                replicaMap.put(origTask, replicaList);
            }
            replicaList.add(task);
        }
        return replicaMap;
    }

    public static Task getOriginalTask(Task task, Map<Task, List<Task>> replicaMap) {
        Optional<Map.Entry> t;
        List<Task> replicaList = replicaMap.get(task);
        if ((replicaList == null || replicaList.isEmpty()) && (t = replicaMap.entrySet().stream().filter(e -> ((List)e.getValue()).contains(task)).findFirst()).isPresent()) {
            return (Task)t.get().getKey();
        }
        return task;
    }
}

