/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task.util;

import java.util.Arrays;
import org.fortiss.af3.platform.model.IPortSemantics;
import org.fortiss.af3.platform.model.IQueuingPort;
import org.fortiss.af3.platform.model.ISamplingPort;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.task.model.Message;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskModelFactory;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.TaskQueuingInputPort;
import org.fortiss.af3.task.model.TaskQueuingOutputPort;
import org.fortiss.af3.task.model.TaskReplica;
import org.fortiss.af3.task.model.TaskSamplingInputPort;
import org.fortiss.af3.task.model.TaskSamplingOutputPort;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.model.allocation.SignalToRouteAllocationEntry;
import org.fortiss.af3.task.model.allocation.TaskAllocationFactory;
import org.fortiss.af3.task.model.allocation.TaskMemoryAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskWcetTable;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class TaskModelElementFactory {
    public static Task createTask(String name) {
        Task task = TaskModelFactory.eINSTANCE.createTask();
        task.setName(name);
        return task;
    }

    public static Signal createSignal(String name) {
        Signal signal = TaskModelFactory.eINSTANCE.createSignal();
        signal.setName(name);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)signal);
        return signal;
    }

    public static Signal createSignal(TaskOutputPort taskOutputPort, TaskInputPort taskInputPort, String name) {
        Signal signal = TaskModelElementFactory.createSignal(name);
        signal.setSource((IConnector)taskOutputPort);
        signal.setTarget((IConnector)taskInputPort);
        return signal;
    }

    public static Message createMessage(TaskOutputPort sender, TaskInputPort ... receivers) {
        Message message = TaskModelFactory.eINSTANCE.createMessage();
        message.setModelElement((IModelElement)sender);
        message.getReceivers().addAll(Arrays.asList(receivers));
        return message;
    }

    public static TaskOutputPort createTaskOutputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (ISamplingPort.class.isAssignableFrom(semantic)) {
            return TaskModelElementFactory.createTaskSamplingOutputPort(name);
        }
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return TaskModelElementFactory.createTaskQueuingOutputPort(name);
        }
        return null;
    }

    public static TaskQueuingInputPort createTaskQueuingInputPort(String name) {
        TaskQueuingInputPort pInPort = TaskModelFactory.eINSTANCE.createTaskQueuingInputPort();
        pInPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pInPort);
        return pInPort;
    }

    public static TaskQueuingOutputPort createTaskQueuingOutputPort(String name) {
        TaskQueuingOutputPort pOutPort = TaskModelFactory.eINSTANCE.createTaskQueuingOutputPort();
        pOutPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pOutPort);
        return pOutPort;
    }

    public static TaskInputPort createTaskInputPort(String name, Class<? extends IPortSemantics> semantic) {
        if (ISamplingPort.class.isAssignableFrom(semantic)) {
            return TaskModelElementFactory.createTaskSamplingInputPort(name);
        }
        if (IQueuingPort.class.isAssignableFrom(semantic)) {
            return TaskModelElementFactory.createTaskQueuingInputPort(name);
        }
        return null;
    }

    public static TaskSamplingInputPort createTaskSamplingInputPort(String name) {
        TaskSamplingInputPort pInPort = TaskModelFactory.eINSTANCE.createTaskSamplingInputPort();
        pInPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pInPort);
        return pInPort;
    }

    public static TaskSamplingOutputPort createTaskSamplingOutputPort(String name) {
        TaskSamplingOutputPort pOutPort = TaskModelFactory.eINSTANCE.createTaskSamplingOutputPort();
        pOutPort.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)pOutPort);
        return pOutPort;
    }

    public static TaskArchitecture createTaskArchitecture(String name) {
        TaskArchitecture taskArchitecture = TaskModelFactory.eINSTANCE.createTaskArchitecture();
        taskArchitecture.setName(name);
        return taskArchitecture;
    }

    public static ComponentToTaskAllocationTable createComponentToTaskAllocationTable(String name) {
        ComponentToTaskAllocationTable ca2ta = TaskAllocationFactory.eINSTANCE.createComponentToTaskAllocationTable();
        ca2ta.setName(name);
        return ca2ta;
    }

    public static TaskToExecutionUnitAllocationTable createTasksToExecutionUnitAllocationTable(String name) {
        TaskToExecutionUnitAllocationTable ta2pa = TaskAllocationFactory.eINSTANCE.createTaskToExecutionUnitAllocationTable();
        ta2pa.setName(name);
        return ta2pa;
    }

    public static TaskToExecutionUnitAllocationTable createTaskToExecutionUnitAllocationTable(String name, TaskArchitecture ta, PlatformArchitecture pa) {
        TaskToExecutionUnitAllocationTable ta2hw = TaskModelElementFactory.createTasksToExecutionUnitAllocationTable(name);
        ta2hw.setSourceView(ta);
        ta2hw.setTargetView((IProjectRootElement)pa);
        return ta2hw;
    }

    public static TaskWcetTable createTaskWcetTable(String name) {
        TaskWcetTable taskWcetTable = TaskAllocationFactory.eINSTANCE.createTaskWcetTable();
        taskWcetTable.setName(name);
        return taskWcetTable;
    }

    public static TaskMemoryAllocationTable createTaskMemoryAllocationTable(String name) {
        TaskMemoryAllocationTable taskMemoryAllocationTable = TaskAllocationFactory.eINSTANCE.createTaskMemoryAllocationTable();
        taskMemoryAllocationTable.setName(name);
        return taskMemoryAllocationTable;
    }

    public static SignalToRouteAllocationEntry createSignalToRouteAllocationEntry(Signal signal, Route route) {
        SignalToRouteAllocationEntry s2r = TaskAllocationFactory.eINSTANCE.createSignalToRouteAllocationEntry();
        s2r.getSourceElements().add((Object)signal);
        s2r.setTargetElement((IModelElement)route);
        return s2r;
    }

    public static void addTaskReplicaSpecification(Task replicaTask, Task origTask) {
        TaskReplica tr = TaskModelFactory.eINSTANCE.createTaskReplica();
        tr.setOrig(origTask);
        replicaTask.getSpecifications().add((Object)tr);
    }
}

