/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.task.ui;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fortiss.af3.task.ui.DefaultStyle;

public class TaskRectangle
extends Shape {
    private int cornerRadius;
    private Insets insets;

    public TaskRectangle(int cornerRadius, Insets insets) {
        this.cornerRadius = cornerRadius;
        this.insets = insets;
    }

    protected void fillShape(Graphics gfx) {
        gfx.pushState();
        gfx.fillRoundRectangle(this.getCroppedBounds(), this.cornerRadius, this.cornerRadius);
        gfx.fillRectangle(this.getCroppedBounds());
        gfx.setForegroundColor(DefaultStyle.TASK_BACKGROUND);
        gfx.setAlpha(200);
        gfx.fillGradient(this.getCroppedBounds(), true);
        gfx.popState();
    }

    protected void outlineShape(Graphics gfx) {
        gfx.pushState();
        gfx.setAntialias(1);
        gfx.drawRoundRectangle(this.getCroppedBounds().resize(-1, -1), this.cornerRadius, this.cornerRadius);
        gfx.drawRectangle(this.getCroppedBounds());
        gfx.popState();
    }

    protected Rectangle getCroppedBounds() {
        return this.bounds.getShrinked(this.insets);
    }
}

