/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.af3.tools.diagram.ui.commands;

import eu.fbk.af3.tools.diagram.ComponentDescriptor;
import eu.fbk.af3.tools.diagram.DiagramDescriptor;
import eu.fbk.af3.tools.diagram.PortDescriptor;
import eu.fbk.af3.tools.diagram.svg.SVGComponent;
import eu.fbk.af3.tools.diagram.svg.SVGConnection;
import eu.fbk.af3.tools.diagram.svg.SVGInputConnector;
import eu.fbk.af3.tools.diagram.svg.SVGOutputConnector;
import eu.fbk.af3.tools.diagram.ui.DiagramUIActivator;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.fop.svg.PDFTranscoder;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.impl.ChannelImpl;
import org.fortiss.af3.component.utils.ComponentArchitectureUtils;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.Dimension;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.OffsetOrientation;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.model.layout.Points;
import org.fortiss.tooling.base.utils.DimensionUtils;
import org.fortiss.tooling.base.utils.OffsetOrientationUtils;
import org.fortiss.tooling.base.utils.PointUtils;
import org.fortiss.tooling.base.utils.PointsUtils;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractComponentToImage
implements IContextMenuContributor {
    private static final int component_border = 12;
    private static final int connector_border = 12;
    private int xTranslation = 0;
    private int yTranslation = 0;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private boolean showConnections = true;
    private boolean showPortLabels = true;
    private boolean automaticLabelLayout = true;
    private Component selectedComponent;

    public void setXTranslation(int xTranslation) {
        this.xTranslation = xTranslation;
    }

    public void setYTranslation(int yTranslation) {
        this.yTranslation = yTranslation;
    }

    public void setShowConnections(boolean showConnections) {
        this.showConnections = showConnections;
    }

    public void setShowPortLabels(boolean showPortLabels) {
        this.showPortLabels = showPortLabels;
    }

    public void setAutomaticLabelLayout(boolean automaticLabelLayout) {
        this.automaticLabelLayout = automaticLabelLayout;
    }

    public String getMenuSectionID() {
        return "afterglobal";
    }

    protected DiagramDescriptor export(String saveFilePath, Component component) {
        block37: {
            this.maxWidth = 0;
            this.maxHeight = 0;
            this.selectedComponent = component;
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            String svgNS = "http://www.w3.org/2000/svg";
            Document doc = impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
            Element svgRoot = doc.getDocumentElement();
            if (this.showConnections) {
                this.createSVGConnections(doc, svgRoot, component);
            }
            this.createSVGComponents(doc, svgRoot, component);
            this.createSVGPorts(doc, svgRoot, component, true);
            svgRoot.setAttributeNS(null, "width", String.valueOf(this.maxWidth + 200));
            svgRoot.setAttributeNS(null, "height", String.valueOf(this.maxHeight + 200));
            try {
                TranscoderOutput output;
                Closeable ostream;
                Object var10_15;
                Object object;
                SVGTranscoder transcoder;
                TranscoderInput input = new TranscoderInput(doc);
                if (saveFilePath.endsWith("svg")) {
                    transcoder = new SVGTranscoder();
                    object = null;
                    var10_15 = null;
                    try {
                        ostream = new FileWriter(saveFilePath);
                        try {
                            output = new TranscoderOutput((Writer)ostream);
                            transcoder.transcode(input, output);
                            break block37;
                        }
                        finally {
                            if (ostream != null) {
                                ((Writer)ostream).close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                if (saveFilePath.endsWith("png")) {
                    transcoder = new PNGTranscoder();
                    object = null;
                    var10_15 = null;
                    try {
                        ostream = new FileOutputStream(saveFilePath);
                        try {
                            output = new TranscoderOutput((OutputStream)ostream);
                            transcoder.transcode(input, output);
                            break block37;
                        }
                        finally {
                            if (ostream != null) {
                                ((FileOutputStream)ostream).close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                if (saveFilePath.endsWith("pdf")) {
                    transcoder = new PDFTranscoder();
                    object = null;
                    var10_15 = null;
                    try {
                        ostream = new FileOutputStream(saveFilePath);
                        try {
                            output = new TranscoderOutput((OutputStream)ostream);
                            transcoder.transcode(input, output);
                            break block37;
                        }
                        finally {
                            if (ostream != null) {
                                ((FileOutputStream)ostream).close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                LoggingUtils.error((Plugin)DiagramUIActivator.getDefault(), (String)"Unsupported image format");
                return null;
            }
            catch (Exception e) {
                LoggingUtils.error((Plugin)DiagramUIActivator.getDefault(), (String)e.toString());
                return null;
            }
        }
        DiagramDescriptor diagramDescriptor = new DiagramDescriptor();
        diagramDescriptor.name = component.getName();
        diagramDescriptor.width = this.maxWidth;
        diagramDescriptor.height = this.maxHeight;
        try {
            diagramDescriptor.url = FilenameUtils.getName((String)new File(saveFilePath).toURI().toURL().getFile());
        }
        catch (MalformedURLException e) {
            LoggingUtils.error((Plugin)DiagramUIActivator.getDefault(), (String)e.toString());
            return null;
        }
        diagramDescriptor.componentDescriptor = new ComponentDescriptor();
        diagramDescriptor.componentDescriptor.name = component.getName();
        diagramDescriptor.componentDescriptor.type = this.getType(component);
        diagramDescriptor.componentDescriptor.refinementType = this.getRefinementType(component);
        for (IConnector connector : component.getConnectors()) {
            PortDescriptor descriptor = this.getPortDescriptor(component, connector);
            if (descriptor == null) continue;
            if (connector instanceof InputPort) {
                diagramDescriptor.componentDescriptor.inputPortDescriptors.add(descriptor);
                continue;
            }
            if (!(connector instanceof OutputPort)) continue;
            diagramDescriptor.componentDescriptor.outputPortDescriptors.add(descriptor);
        }
        return diagramDescriptor;
    }

    protected PortDescriptor getPortDescriptor(Component component, IConnector connector) {
        PortDescriptor descriptor = new PortDescriptor();
        descriptor.name = ((Port)connector).getName();
        descriptor.type = this.getType((Port)connector);
        descriptor.range = this.getRange(component, (Port)connector);
        descriptor.notes = "";
        if (connector instanceof InputPort) {
            descriptor.direction = "input";
        } else if (connector instanceof OutputPort) {
            descriptor.direction = "output";
        } else {
            return null;
        }
        return descriptor;
    }

    protected Point getPortPosition(Port port, boolean isRootLevel) {
        if (!isRootLevel) {
            OffsetOrientation orientation = OffsetOrientationUtils.getOffsetOrientation((ILayoutedModelElement)port, (String)"coffsetorient");
            if (orientation != null) {
                Component component = port.getComponent();
                Point point = this.getComponentPoint(component);
                Dimension dimension = this.getComponentDimension(component);
                if (orientation.getOrientation().getValue() == 1) {
                    point.setX(point.getX() + dimension.getWidth());
                    point.setY(point.getY() + orientation.getOffset());
                } else if (orientation.getOrientation().getValue() == 3) {
                    point.setY(point.getY() + orientation.getOffset());
                } else if (orientation.getOrientation().getValue() == 0) {
                    point.setX(point.getX() + orientation.getOffset());
                } else if (orientation.getOrientation().getValue() == 2) {
                    point.setX(point.getX() + orientation.getOffset());
                    point.setY(point.getY() + dimension.getHeight());
                }
                return point;
            }
            return this.getComponentPoint(port.getComponent());
        }
        Point point = (Point)EcoreUtil.copy((EObject)PointUtils.getPosition((ILayoutedModelElement)port, (String)"pos"));
        point.setX(this.xTranslation + point.getX() + 12);
        point.setY(this.yTranslation + point.getY() + 12);
        this.maxWidth = Math.max(this.maxWidth, point.getX());
        this.maxHeight = Math.max(this.maxHeight, point.getY());
        return point;
    }

    protected Point getPortLabelPosition(Port port, boolean isRootLevel) {
        int padding = 10;
        Point point = this.getPortPosition(port, isRootLevel);
        if (isRootLevel) {
            if (this.automaticLabelLayout) {
                if (this.isOnLeftSideOfConnection(port)) {
                    point.setX(point.getX() - 10);
                } else if (this.isOnRightSideOfConnection(port)) {
                    point.setX(point.getX() + 10);
                } else {
                    point.setX(point.getX() + 10);
                }
            }
        } else {
            boolean belongsToSelectedComponent;
            OffsetOrientation orientation = OffsetOrientationUtils.getOffsetOrientation((ILayoutedModelElement)port, (String)"coffsetorient");
            boolean bl = belongsToSelectedComponent = port.getComponent().getId() == this.selectedComponent.getId();
            if (orientation != null) {
                if (orientation.getOrientation().getValue() == 1) {
                    point.setY(point.getY() + 4);
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        point.setX(point.getX() - 10);
                    } else {
                        point.setX(point.getX() + 10);
                    }
                } else if (orientation.getOrientation().getValue() == 3) {
                    point.setY(point.getY() + 4);
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        point.setX(point.getX() + 10);
                    } else {
                        point.setX(point.getX() - 10);
                    }
                } else if (orientation.getOrientation().getValue() == 0) {
                    point.setX(point.getX());
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        point.setY(point.getY() + 10);
                    } else {
                        point.setY(point.getY() - 10);
                    }
                } else if (orientation.getOrientation().getValue() == 2) {
                    point.setX(point.getX());
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        point.setY(point.getY() + 10);
                    } else {
                        point.setY(point.getY() + 10);
                    }
                }
            } else {
                point.setY(point.getY() + 4);
                if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                    point.setX(point.getX() - 10);
                } else {
                    point.setX(point.getX() + 10);
                }
            }
        }
        this.maxWidth = Math.max(this.maxWidth, point.getX() + port.getName().length() * 8);
        return point;
    }

    protected String getPortLabelAlignment(Port port, boolean isRootLevel) {
        String alignement = "start";
        if (isRootLevel) {
            if (this.automaticLabelLayout) {
                alignement = this.isOnLeftSideOfConnection(port) ? "end" : (this.isOnRightSideOfConnection(port) ? "start" : "start");
            }
        } else {
            boolean belongsToSelectedComponent;
            OffsetOrientation orientation = OffsetOrientationUtils.getOffsetOrientation((ILayoutedModelElement)port, (String)"coffsetorient");
            boolean bl = belongsToSelectedComponent = port.getComponent().getId() == this.selectedComponent.getId();
            if (orientation != null) {
                if (orientation.getOrientation().getValue() == 1) {
                    alignement = "start";
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        alignement = "end";
                    }
                } else if (orientation.getOrientation().getValue() == 3) {
                    alignement = "end";
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        alignement = "start";
                    }
                } else if (orientation.getOrientation().getValue() == 0) {
                    alignement = "start";
                } else if (orientation.getOrientation().getValue() == 2) {
                    alignement = "start";
                    if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                        alignement = "end";
                    }
                }
            } else {
                alignement = "start";
                if (this.automaticLabelLayout && !belongsToSelectedComponent) {
                    alignement = "end";
                }
            }
        }
        return alignement;
    }

    protected String getPortLabelStyle(Port port) {
        OffsetOrientation orientation = OffsetOrientationUtils.getOffsetOrientation((ILayoutedModelElement)port, (String)"coffsetorient");
        if (orientation != null) {
            if (orientation.getOrientation().getValue() == 1) {
                return "";
            }
            if (orientation.getOrientation().getValue() == 3) {
                return "";
            }
            if (orientation.getOrientation().getValue() == 0 ? this.automaticLabelLayout && port.getComponent().getId() != this.selectedComponent.getId() : orientation.getOrientation().getValue() == 2 && this.automaticLabelLayout && port.getComponent().getId() != this.selectedComponent.getId()) {
                return "writing-mode: lr-tb";
            }
        }
        return "";
    }

    protected String getPortLabelTransform(Port port) {
        OffsetOrientation orientation = OffsetOrientationUtils.getOffsetOrientation((ILayoutedModelElement)port, (String)"coffsetorient");
        if (orientation != null) {
            if (orientation.getOrientation().getValue() == 1) {
                return "";
            }
            if (orientation.getOrientation().getValue() == 3) {
                return "";
            }
            if (orientation.getOrientation().getValue() == 0) {
                if (this.automaticLabelLayout && port.getComponent().getId() != this.selectedComponent.getId()) {
                    Point position = this.getPortPosition(port, false);
                    return String.format("rotate(90 %s,%s)", position.getX(), position.getY() + 8);
                }
            } else if (orientation.getOrientation().getValue() == 2 && this.automaticLabelLayout && port.getComponent().getId() != this.selectedComponent.getId()) {
                Point position = this.getPortPosition(port, false);
                return String.format("rotate(90 %s,%s)", position.getX() + 8, position.getY());
            }
        }
        return "";
    }

    protected Point getComponentPoint(Component component) {
        Point point = (Point)EcoreUtil.copy((EObject)PointUtils.getPosition((ILayoutedModelElement)component, (String)"pos"));
        point.setX(this.xTranslation + point.getX() + 12);
        point.setY(this.yTranslation + point.getY() + 12);
        return point;
    }

    protected Dimension getComponentDimension(Component component) {
        Dimension currentDimension = DimensionUtils.getDimension((ILayoutedModelElement)component, (String)"dim");
        Dimension dimension = (Dimension)EcoreUtil.copy((EObject)currentDimension);
        dimension.setWidth(dimension.getWidth() - 24);
        dimension.setHeight(dimension.getHeight() - 24);
        return dimension;
    }

    private void createSVGConnections(Document doc, Element svgRootElement, Component parentComponent) {
        for (IConnection connection : parentComponent.getConnections()) {
            if (!(connection instanceof ChannelImpl)) continue;
            ChannelImpl channel = (ChannelImpl)connection;
            Port sourcePort = channel.getSource();
            Point sourcePoint = this.getPortPosition(sourcePort, parentComponent.getId() == sourcePort.getComponent().getId());
            Port targetPort = channel.getTarget();
            Point targetPoint = this.getPortPosition(targetPort, parentComponent.getId() == targetPort.getComponent().getId());
            Points points = (Points)EcoreUtil.copy((EObject)PointsUtils.getPoints((ILayoutedModelElement)channel, (String)"points"));
            SVGConnection svgConnection = new SVGConnection(doc, channel.getName(), sourcePoint.getX(), sourcePoint.getY());
            for (Point point : points.getPoints()) {
                point.setX(this.xTranslation + point.getX());
                point.setY(this.yTranslation + point.getY());
                svgConnection.addPoint(point.getX(), point.getY());
                this.maxWidth = Math.max(this.maxWidth, point.getX());
                this.maxHeight = Math.max(this.maxHeight, point.getY());
            }
            svgConnection.addPoint(targetPoint.getX(), targetPoint.getY());
            svgRootElement.appendChild(svgConnection.getElement());
        }
    }

    private void createSVGComponents(Document doc, Element svgRootElement, Component parentComponent) {
        for (Component component : parentComponent.getSubComponents()) {
            Point point = this.getComponentPoint(component);
            Dimension dimension = this.getComponentDimension(component);
            this.maxWidth = Math.max(this.maxWidth, point.getX() + dimension.getWidth());
            this.maxHeight = Math.max(this.maxHeight, point.getY() + dimension.getHeight());
            SVGComponent svgComponent = new SVGComponent(doc, component.getName(), point.getX(), point.getY(), dimension.getWidth(), dimension.getHeight());
            svgRootElement.appendChild(svgComponent.getElement());
            svgRootElement.appendChild(svgComponent.getLabelElement());
        }
    }

    private void createSVGPorts(Document doc, Element svgRootElement, Component parentComponent, boolean isRootLevel) {
        for (IConnector connector : parentComponent.getConnectors()) {
            Object svgPort;
            if (!(connector instanceof Port)) continue;
            Port port = (Port)connector;
            Point point = this.getPortPosition(port, isRootLevel);
            if (connector instanceof InputPort) {
                svgPort = isRootLevel ? new SVGOutputConnector(doc, ((Port)connector).getName(), point.getX(), point.getY()) : new SVGInputConnector(doc, ((Port)connector).getName(), point.getX(), point.getY());
            } else {
                if (!(connector instanceof OutputPort)) continue;
                svgPort = isRootLevel ? new SVGInputConnector(doc, ((Port)connector).getName(), point.getX(), point.getY()) : new SVGOutputConnector(doc, ((Port)connector).getName(), point.getX(), point.getY());
            }
            svgRootElement.appendChild(svgPort.getElement());
            if (!this.showPortLabels) continue;
            Point labelPoint = this.getPortLabelPosition(port, isRootLevel);
            svgPort.setLabelAlignement(this.getPortLabelAlignment(port, isRootLevel));
            svgPort.setLabelX(labelPoint.getX());
            svgPort.setLabelY(labelPoint.getY());
            svgPort.setLabelStyle(this.getPortLabelStyle(port));
            svgPort.setLabelTransform(this.getPortLabelTransform(port));
            svgRootElement.appendChild(svgPort.getLabelElement());
        }
        if (isRootLevel) {
            for (Component component : parentComponent.getSubComponents()) {
                this.createSVGPorts(doc, svgRootElement, component, false);
            }
        }
    }

    protected String getType(Port port) {
        return port.getVariableType().toString();
    }

    protected String getType(Component component) {
        return "";
    }

    protected String getRefinementType(Component component) {
        return "";
    }

    protected String getRange(Component component, Port port) {
        ArrayList<String> enumValues = new ArrayList<String>();
        IType iType = port.getVariableType();
        DataDictionary dataDictionary = ComponentArchitectureUtils.findDataDictionary((Component)component);
        if (iType instanceof TDefinedType && dataDictionary != null) {
            ITypeDefinition typeDefinition = dataDictionary.getDefinitionElement(iType);
            EList contents = typeDefinition.eContents();
            for (EObject content : contents) {
                if (!(content instanceof EnumerationMember)) continue;
                enumValues.add(((EnumerationMember)content).getName());
            }
        } else if (iType instanceof TInt) {
            enumValues.add(Integer.toString(((TInt)iType).getLowerBound()));
            enumValues.add(Integer.toString(((TInt)iType).getUpperBound()));
        } else if (iType instanceof TDouble) assert (false);
        return StringUtils.join(enumValues, (String)", ");
    }

    private boolean isOnLeftSideOfConnection(Port port) {
        int xPortPosition;
        if (((Component)port.getOwner()).getSubComponents().isEmpty()) {
            return false;
        }
        if (port.getOutgoingChannels() != null) {
            for (Channel channel : port.getOutgoingChannels()) {
                Port targetPort;
                int xTargetPortPosition;
                if (!this.belongsToSelectedComponent(channel) || (xTargetPortPosition = this.getPortPosition(targetPort = channel.getTarget(), this.belongsToSelectedComponent(targetPort)).getX()) <= (xPortPosition = this.getPortPosition(port, this.belongsToSelectedComponent(port)).getX())) continue;
                return true;
            }
        }
        if (port.getIncomingChannels() != null) {
            for (Channel channel : port.getIncomingChannels()) {
                Port sourcePort;
                int xSourcePortPosition;
                if (!this.belongsToSelectedComponent(channel) || (xSourcePortPosition = this.getPortPosition(sourcePort = channel.getSource(), this.belongsToSelectedComponent(sourcePort)).getX()) <= (xPortPosition = this.getPortPosition(port, this.belongsToSelectedComponent(port)).getX())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOnRightSideOfConnection(Port port) {
        int xPortPosition;
        if (((Component)port.getOwner()).getSubComponents().isEmpty()) {
            return false;
        }
        if (port.getOutgoingChannels() != null) {
            for (Channel channel : port.getOutgoingChannels()) {
                Port targetPort;
                int xTargetPortPosition;
                if (!this.belongsToSelectedComponent(channel) || (xTargetPortPosition = this.getPortPosition(targetPort = channel.getTarget(), this.belongsToSelectedComponent(targetPort)).getX()) >= (xPortPosition = this.getPortPosition(port, this.belongsToSelectedComponent(port)).getX())) continue;
                return true;
            }
        }
        if (port.getIncomingChannels() != null) {
            for (Channel channel : port.getIncomingChannels()) {
                Port sourcePort;
                int xSourcePortPosition;
                if (!this.belongsToSelectedComponent(channel) || (xSourcePortPosition = this.getPortPosition(sourcePort = channel.getSource(), this.belongsToSelectedComponent(sourcePort)).getX()) >= (xPortPosition = this.getPortPosition(port, this.belongsToSelectedComponent(port)).getX())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean belongsToSelectedComponent(Port port) {
        return port.getComponent().getId() == this.selectedComponent.getId();
    }

    private boolean belongsToSelectedComponent(Channel channel) {
        return channel.getParentComponent().getId() == this.selectedComponent.getId();
    }
}

