/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.af3.tools.diagram.ui.commands;

import eu.fbk.af3.tools.diagram.ui.DiagramUIActivator;
import eu.fbk.af3.tools.diagram.ui.commands.AbstractComponentToImage;
import eu.fbk.af3.tools.diagram.ui.dialog.ComponentToImageDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.internal.views.NavigatorViewPart;

public class ExportComponentToImage
extends AbstractComponentToImage {
    private Component selectedComponent;

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        this.selectedComponent = null;
        ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
        if (contextProvider instanceof NavigatorViewPart) {
            if (selection instanceof ComponentArchitecture) {
                this.selectedComponent = ((ComponentArchitecture)selection).getTopComponent();
                contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new ExportDiagramToImageAction("Export component as image ...")));
            } else if (selection instanceof Component) {
                this.selectedComponent = (Component)selection;
                contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new ExportDiagramToImageAction("Export diagram as image ...")));
            }
        }
        return contributionItems;
    }

    private class ExportDiagramToImageAction
    extends Action {
        ExportDiagramToImageAction(String name) {
            super(name, DiagramUIActivator.getImageDescriptor("icons/diagram.png"));
        }

        public void run() {
            if (ExportComponentToImage.this.selectedComponent != null) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ComponentToImageDialog parameterDialog = new ComponentToImageDialog(shell);
                parameterDialog.open();
                if (!parameterDialog.goAhead()) {
                    return;
                }
                FileDialog fd = new FileDialog(shell, 8192);
                fd.setText("Set target file");
                fd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
                String[] filterExt = new String[]{"*.svg", "*.png", "*.pdf"};
                fd.setFilterExtensions(filterExt);
                fd.setFileName(ExportComponentToImage.this.selectedComponent.getName() + "." + parameterDialog.getImageFormat());
                final String fileName = fd.open();
                if (fileName == null || fileName.isEmpty()) {
                    return;
                }
                ExportComponentToImage.this.setShowPortLabels(parameterDialog.getShowPortLabels());
                ExportComponentToImage.this.setAutomaticLabelLayout(parameterDialog.getAutomaticPortLabelLayout());
                ExportComponentToImage.this.setXTranslation(200);
                ExportComponentToImage.this.setYTranslation(100);
                Runnable exporterJob = new Runnable(){

                    @Override
                    public void run() {
                        ExportComponentToImage.this.export(fileName, ((ExportDiagramToImageAction)ExportDiagramToImageAction.this).ExportComponentToImage.this.selectedComponent);
                    }
                };
                BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)exporterJob);
            }
        }
    }
}

