/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.af3.tools.diagram.ui.commands;

import eu.fbk.af3.tools.diagram.DiagramDescriptor;
import eu.fbk.af3.tools.diagram.DocumentGenerator;
import eu.fbk.af3.tools.diagram.ui.DiagramUIActivator;
import eu.fbk.af3.tools.diagram.ui.commands.AbstractComponentToImage;
import eu.fbk.af3.tools.diagram.ui.dialog.ModelToDocumentDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.internal.views.NavigatorViewPart;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ExportModelToDocument
extends AbstractComponentToImage {
    private Component selectedComponent;
    private String directoryName;
    private boolean showLeafComponents = false;
    private String imageExtension = ".svg";

    public void setShowLeafComponents(boolean showLeafComponents) {
        this.showLeafComponents = showLeafComponents;
    }

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        this.selectedComponent = null;
        if (contextProvider instanceof NavigatorViewPart) {
            if (selection instanceof ComponentArchitecture) {
                this.selectedComponent = ((ComponentArchitecture)selection).getTopComponent();
            } else if (selection instanceof Component) {
                this.selectedComponent = (Component)selection;
            } else {
                return Collections.emptyList();
            }
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new ExportModelToDocumentAction()));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    private String getFullFileName(String directoryName, Component component, String extension) {
        return directoryName + File.separator + component.getName() + extension;
    }

    private void createDiagramDescriptors(Component parentComponent, DiagramDescriptor parentDescriptor) {
        for (Component component : parentComponent.getSubComponents()) {
            if (!this.showLeafComponents && component.getSubComponents().isEmpty()) continue;
            String componentFileName = this.getFullFileName(this.directoryName, component, this.imageExtension);
            DiagramDescriptor diagramDescriptor = this.export(componentFileName, component);
            parentDescriptor.children.add(diagramDescriptor);
            this.createDiagramDescriptors(component, diagramDescriptor);
        }
    }

    private class ExportModelToDocumentAction
    extends Action {
        ExportModelToDocumentAction() {
            super("Export model as document ...", DiagramUIActivator.getImageDescriptor("icons/diagram.png"));
        }

        public void run() {
            if (ExportModelToDocument.this.selectedComponent != null) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                final ModelToDocumentDialog parameterDialog = new ModelToDocumentDialog(shell);
                parameterDialog.open();
                if (!parameterDialog.goAhed()) {
                    return;
                }
                DirectoryDialog dd = new DirectoryDialog(shell);
                dd.setText("Select the directory");
                dd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
                ExportModelToDocument.this.directoryName = dd.open();
                if (ExportModelToDocument.this.directoryName == null || ExportModelToDocument.this.directoryName.isEmpty()) {
                    return;
                }
                FileProject fileProject = (FileProject)EcoreUtils.getFirstParentWithType((EObject)ExportModelToDocument.this.selectedComponent, FileProject.class);
                final DocumentGenerator documentGenerator = new DocumentGenerator();
                documentGenerator.init(fileProject.getName(), parameterDialog.getDocumentFormat());
                if (parameterDialog.getDocumentFormat().equals("tex")) {
                    ExportModelToDocument.this.imageExtension = ".png";
                }
                final String rootComponentFileName = ExportModelToDocument.this.getFullFileName(ExportModelToDocument.this.directoryName, ExportModelToDocument.this.selectedComponent, ExportModelToDocument.this.imageExtension);
                ExportModelToDocument.this.setShowPortLabels(parameterDialog.getShowPortLabels());
                ExportModelToDocument.this.setAutomaticLabelLayout(parameterDialog.getAutomaticPortLabelLayout());
                ExportModelToDocument.this.setXTranslation(150);
                ExportModelToDocument.this.setYTranslation(100);
                Runnable exporterJob = new Runnable(){

                    @Override
                    public void run() {
                        DiagramDescriptor rootDiagramDescriptor = ExportModelToDocument.this.export(rootComponentFileName, ((ExportModelToDocumentAction)ExportModelToDocumentAction.this).ExportModelToDocument.this.selectedComponent);
                        documentGenerator.setDiagramDescriptor(rootDiagramDescriptor);
                        ExportModelToDocument.this.setShowLeafComponents(parameterDialog.getShowLeafComponents());
                        ExportModelToDocument.this.createDiagramDescriptors(((ExportModelToDocumentAction)ExportModelToDocumentAction.this).ExportModelToDocument.this.selectedComponent, rootDiagramDescriptor);
                        documentGenerator.generate(((ExportModelToDocumentAction)ExportModelToDocumentAction.this).ExportModelToDocument.this.directoryName);
                    }
                };
                BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)exporterJob);
            }
        }
    }
}

