/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.ff1.generator.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.conqat.ide.commons.ui.ui.WorkbenchUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PartInitException;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.ff1.generator.ui.AF3FF1GeneratorUIActivator;
import org.fortiss.af3.ff1.generator.ui.FF1GeneratorFXViewPart;
import org.fortiss.tooling.base.utils.SystemUtils;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;

public class FF1GeneratorContextMenuContributor
implements IContextMenuContributor {
    private final String shellTitle = "Deploy/Start fortissimo rover";
    private AllocationTableCollection atc;

    public String getMenuSectionID() {
        return "bottommost";
    }

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof AllocationTableCollection) {
            this.atc = (AllocationTableCollection)selection;
            return Arrays.asList(new ActionContributionItem((IAction)new FF1GeneratorAction()));
        }
        return Collections.emptyList();
    }

    protected ImageDescriptor getActionIcon() {
        return AF3FF1GeneratorUIActivator.getImageDescriptor("icons/ff1.png");
    }

    protected class FF1GeneratorAction
    extends Action {
        public FF1GeneratorAction() {
            super("Deploy/Start fortissimo rover", FF1GeneratorContextMenuContributor.this.getActionIcon());
        }

        public void run() {
            if (!SystemUtils.isLinuxPlatform()) {
                MessageUtilsExtended.showErrorInUIThread((String)"This feature is only available on Linux systems", (String)"Deployment to the fortissimo Rovers is currently supported only on Linux systems.");
                return;
            }
            String secondaryId = Integer.toString(FF1GeneratorContextMenuContributor.this.atc.getId());
            try {
                WorkbenchUtils.getActiveWorkbenchPage().showView(FF1GeneratorFXViewPart.class.getName(), secondaryId, 1);
            }
            catch (PartInitException e) {
                e.printStackTrace();
                MessageUtilsExtended.showInfoInUIThread((String)"Deploy/Start fortissimo rover", (String)e.getMessage());
            }
        }
    }
}

