/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.ff1.generator.ui;

import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.ff1.generator.FF1Generator;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;
import org.fortiss.tooling.kernel.ui.util.SelectionUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class FF1GeneratorFXController
extends CompositeFXControllerBase<Pane, Node>
implements ISelectionListener {
    @FXML
    private ComboBox<String> hostnameECU1;
    @FXML
    private ComboBox<String> hostnameECU2;
    @FXML
    private ComboBox<String> hostnameECU3;
    @FXML
    private ComboBox<String> hostnameECU4;
    private ComboBox<String>[] hostnameBoxes;
    @FXML
    private Button deployAndStartButton;
    @FXML
    private Button deployButton;
    @FXML
    private Button startButton;
    @FXML
    private Button cancelButton;
    @FXML
    private Button stopRoverButton;
    @FXML
    private Label labelECU1;
    @FXML
    private Label labelECU2;
    @FXML
    private Label labelECU3;
    @FXML
    private Label labelECU4;
    private Label[] hostnameLabels;
    @FXML
    private Label modelName;
    @FXML
    private TextArea outputTextArea;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private ImageView imageView;
    @FXML
    private RadioButton radioButton1;
    @FXML
    private RadioButton radioButton2;
    @FXML
    private RadioButton radioButton3;
    @FXML
    private RadioButton radioButton4;
    private RadioButton[] radioButtons;
    private static String FORTISSIMO_PICTURE_PATH = "res/fortissimo_rover.png";
    private static String[] fortissimo_hostnames = new String[]{"whitepi1", "whitepi2", "whitepi3", "whitepi4", "blackpi1", "blackpi2", "blackpi3", "blackpi4", "redpi1", "redpi2", "redpi3", "redpi4", "yellowpi1", "yellowpi2", "yellowpi3", "yellowpi4", "bluepi1", "bluepi2", "bluepi3", "bluepi4", "orangepi1", "orangepi2", "orangepi3", "orangepi4", "pinkpi1", "pinkpi2", "pinkpi3", "pinkpi4"};
    private IProjectRootElement currentRootElement;
    private AllocationTableCollection atc;
    private ArrayList<ExecutionUnit> executionUnits;
    private static final long THREAD_JOIN_TIMEOUT = 2000L;
    private static final long PRE_UPDATE_SLEEP_SECONDS = 1L;
    ToggleGroup toggleGroup = new ToggleGroup();
    private FF1Generator currentGenerator;

    public FF1GeneratorFXController() {
        super(new ICompositeFXController[0]);
    }

    public String getFXMLLocation() {
        return "FF1GeneratorLayout.fxml";
    }

    public void initialize() {
        this.currentGenerator = null;
        this.hostnameBoxes = new ComboBox[]{this.hostnameECU1, this.hostnameECU2, this.hostnameECU3, this.hostnameECU4};
        this.hostnameLabels = new Label[]{this.labelECU1, this.labelECU2, this.labelECU3, this.labelECU4};
        RadioButton[] radioButtonArray = this.radioButtons = new RadioButton[]{this.radioButton1, this.radioButton2, this.radioButton3, this.radioButton4};
        int n = this.radioButtons.length;
        int n2 = 0;
        while (n2 < n) {
            RadioButton radioButton = radioButtonArray[n2];
            radioButton.setToggleGroup(this.toggleGroup);
            ++n2;
        }
        this.clearHardwareToHostnameAllocations();
        Image image = new Image(FORTISSIMO_PICTURE_PATH);
        this.imageView.setImage(image);
        ComboBox<String>[] comboBoxArray = this.hostnameBoxes;
        int n3 = this.hostnameBoxes.length;
        n = 0;
        while (n < n3) {
            ComboBox<String> host = comboBoxArray[n];
            host.setItems(FXCollections.observableArrayList((Object[])fortissimo_hostnames));
            ++n;
        }
    }

    private void clearHardwareToHostnameAllocations() {
        ComboBox<String>[] comboBoxArray = this.hostnameBoxes;
        int n = this.hostnameBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ComboBox<String> host = comboBoxArray[n2];
            host.setVisible(false);
            ++n2;
        }
        comboBoxArray = this.hostnameLabels;
        n = this.hostnameLabels.length;
        n2 = 0;
        while (n2 < n) {
            ComboBox<String> label = comboBoxArray[n2];
            label.setText("");
            ++n2;
        }
        comboBoxArray = this.radioButtons;
        n = this.radioButtons.length;
        n2 = 0;
        while (n2 < n) {
            ComboBox<String> radioButton = comboBoxArray[n2];
            radioButton.setVisible(false);
            ++n2;
        }
        this.modelName.setText("");
        this.disableAllRunButtons();
        this.cancelButton.setDisable(true);
    }

    private void enableAllRunButtonsIfPossible() {
        if (this.currentGenerator == null || this.currentGenerator.isFinished()) {
            this.deployAndStartButton.setDisable(false);
            this.deployButton.setDisable(false);
            this.startButton.setDisable(false);
            this.stopRoverButton.setDisable(false);
            this.cancelButton.setDisable(true);
        }
    }

    private void disableAllRunButtons() {
        this.deployAndStartButton.setDisable(true);
        this.deployButton.setDisable(true);
        this.startButton.setDisable(true);
        this.stopRoverButton.setDisable(true);
    }

    private void resetProgress() {
        this.outputTextArea.setText("");
        this.progressBar.setProgress(0.0);
    }

    public void onDeployAndStart() {
        boolean stopMiddleware = false;
        boolean deployFmus = true;
        boolean startMiddleware = true;
        this.execute(stopMiddleware, deployFmus, startMiddleware);
    }

    public void onDeploy() {
        boolean stopMiddleware = false;
        boolean deployFmus = true;
        boolean startMiddleware = false;
        this.execute(stopMiddleware, deployFmus, startMiddleware);
    }

    public void onStart() {
        boolean stopMiddleware = false;
        boolean deployFmus = false;
        boolean startMiddleware = true;
        this.execute(stopMiddleware, deployFmus, startMiddleware);
    }

    public void onStopRover() {
        boolean stopMiddleware = true;
        boolean deployFmus = false;
        boolean startMiddleware = false;
        this.execute(stopMiddleware, deployFmus, startMiddleware);
    }

    public void onCancel() {
        if (this.currentGenerator != null) {
            this.currentGenerator.cancel();
            this.currentGenerator = null;
        }
    }

    private void execute(boolean stopMiddleware, boolean deployFmus, boolean startMiddleware) {
        if (this.atc == null || this.executionUnits == null) {
            return;
        }
        try {
            HashMap<ExecutionUnit, String> executionUnitToHostnameMap = this.getExecutionUnitToHostnameMap();
            RadioButton selectedButton = (RadioButton)this.toggleGroup.getSelectedToggle();
            if (selectedButton == null) {
                throw new IllegalArgumentException("Master was not selected.");
            }
            ExecutionUnit master = null;
            int i = 0;
            while (i < this.executionUnits.size()) {
                if (this.radioButtons[i].equals(selectedButton)) {
                    master = this.executionUnits.get(i);
                }
                ++i;
            }
            this.disableAllRunButtons();
            this.cancelButton.setDisable(false);
            this.currentGenerator = new FF1Generator(this.atc, executionUnitToHostnameMap, master);
            this.resetProgress();
            FF1GeneratorFXController.trackProgressJob(this, this.currentGenerator, this.outputTextArea, this.progressBar);
            this.currentGenerator.run(stopMiddleware, deployFmus, startMiddleware);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageUtilsExtended.showInfoInUIThread((String)"Error", (String)e.getMessage());
            try {
                try {
                    Thread.currentThread().join(2000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    MessageUtilsExtended.showInfoInUIThread((String)"Error", (String)e.getMessage());
                    this.currentGenerator = null;
                }
            }
            finally {
                this.currentGenerator = null;
            }
        }
    }

    private HashMap<ExecutionUnit, String> getExecutionUnitToHostnameMap() {
        LinkedHashMap<ExecutionUnit, String> executionUnitToHostnameMap = new LinkedHashMap<ExecutionUnit, String>();
        HashSet<String> seenNames = new HashSet<String>();
        int i = 0;
        while (i < this.executionUnits.size()) {
            String hostName = (String)this.hostnameBoxes[i].getValue();
            if (hostName == null || hostName.isBlank()) {
                throw new IllegalArgumentException("One or more hostnames are empty.");
            }
            if (!InetAddresses.isUriInetAddress((String)hostName) && !InternetDomainName.isValid((String)hostName)) {
                throw new IllegalArgumentException("Hostname \"" + hostName + "\" is neither a valid hostname nor a valid IP address.");
            }
            if (seenNames.contains(hostName)) {
                throw new IllegalArgumentException("Hostname \"" + hostName + "\" has been assigned to more than one execution unit.");
            }
            seenNames.add(hostName);
            executionUnitToHostnameMap.put(this.executionUnits.get(i), hostName);
            ++i;
        }
        return executionUnitToHostnameMap;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        EObject selected = (EObject)SelectionUtils.checkAndPickFirst((ISelection)selection, EObject.class);
        if (selected == null) {
            return;
        }
        this.currentRootElement = selected instanceof IProjectRootElement ? (IProjectRootElement)selected : (IProjectRootElement)EcoreUtils.getFirstParentWithType((EObject)selected, IProjectRootElement.class);
        if (this.currentRootElement == null) {
            this.clearHardwareToHostnameAllocations();
            return;
        }
        if (this.currentRootElement instanceof AllocationTableCollection) {
            this.clearHardwareToHostnameAllocations();
            String modelNameString = ((FileProject)EcoreUtils.getFirstParentWithType((EObject)selected, FileProject.class)).getName();
            this.modelName.setText(modelNameString);
            this.atc = (AllocationTableCollection)this.currentRootElement;
            if (FF1Generator.getExecutionUnits((AllocationTableCollection)this.atc) == null) {
                return;
            }
            this.executionUnits = FF1Generator.getExecutionUnits((AllocationTableCollection)this.atc).stream().sorted(Comparator.comparing(INamedElement::getName)).collect(Collectors.toCollection(ArrayList::new));
            int i = 0;
            while (i < this.executionUnits.size()) {
                this.hostnameLabels[i].setText(this.executionUnits.get(i).getName());
                this.hostnameBoxes[i].setVisible(true);
                this.radioButtons[i].setVisible(true);
                ++i;
            }
            this.enableAllRunButtonsIfPossible();
        } else {
            this.clearHardwareToHostnameAllocations();
        }
    }

    private static void trackProgressJob(final FF1GeneratorFXController controller, final FF1Generator ff1Generator, final TextArea outputTextArea, final ProgressBar progressBar) {
        Job job = new Job("FF1 Progress Tracker"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    FF1GeneratorFXController.displayOutput(ff1Generator, outputTextArea, progressBar);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
                LocalDateTime now = LocalDateTime.now();
                if (ff1Generator.getJobStatus() != null && ff1Generator.getJobStatus().isOK()) {
                    outputTextArea.appendText("\n[FF1 Generator] Finished successfully.\n");
                } else {
                    outputTextArea.appendText("\n[FF1 Generator] Finished unsuccessfully.\n");
                }
                outputTextArea.appendText("[FF1 Generator] Finish time: " + dtf.format(now));
                progressBar.setProgress(0.0);
                controller.currentGenerator = null;
                controller.enableAllRunButtonsIfPossible();
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private static void displayOutput(FF1Generator ff1Generator, TextArea outputTextArea, ProgressBar progressBar) throws InterruptedException {
        while (!ff1Generator.isFinished()) {
            TimeUnit.SECONDS.sleep(1L);
            double progress = ff1Generator.getFinishedSubtasks() / ff1Generator.getOverallSubtasks();
            progressBar.setProgress(progress);
            outputTextArea.setText(ff1Generator.getOutputWindowText());
            outputTextArea.setScrollTop(Double.MAX_VALUE);
        }
    }
}

