/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.ui.examples;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Channel;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.code.CodeSpecification;
import org.fortiss.af3.component.ui.examples.SimpleTrafficLightsComponentArchitectureExample;
import org.fortiss.af3.component.utils.BehaviorModelElementFactory;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.mode.model.ModeComponentStructureSpecification;
import org.fortiss.af3.mode.model.SwitchSegment;
import org.fortiss.af3.mode.ui.utils.SwitchLayoutUtils;
import org.fortiss.af3.mode.utils.ModeAutomatonUtils;
import org.fortiss.af3.mode.utils.ModeModelElementFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.ui.utils.EllipseLayoutUIUtils;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class SimpleTrafficLightsModesExample
extends SimpleTrafficLightsComponentArchitectureExample {
    public static final SimpleTrafficLightsModesExample INSTANCE = new SimpleTrafficLightsModesExample();

    protected SimpleTrafficLightsModesExample() {
    }

    public FileProject createProject(String projectName) {
        FileProject project = super.createProject(projectName);
        this.extendComponentArchitectureByUsingModeAutomata(project);
        AnnotationUtils.instantiateAnnotationsRecursive((EObject)project);
        UniqueIDUtils.generateAllIDs((EObject)project);
        this.setExecutionConfigReferencedID(project);
        return project;
    }

    public void extendComponentArchitectureByUsingModeAutomata(FileProject project) {
        ComponentArchitecture ca = (ComponentArchitecture)ReflectionUtils.pickInstanceOf(ComponentArchitecture.class, (Collection)project.getRootElements());
        Component tlarch = ComponentModelElementFactory.createComponent((String)"TL-Architecture", (String)"");
        ca.getContainedElements().add((Object)tlarch);
        TriFunction<String, IType, Integer, InputPort> iPort = (n, ty, scale) -> {
            InputPort res = ComponentModelElementFactory.createInputPortAndAttach((Component)tlarch, (String)n, (IType)ty, (IExpressionTerm)NoVal.NOVAL.toITerm());
            LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)res, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * scale));
            return res;
        };
        Function<TypeDefinition, TDefinedType> dTy = tpDef -> ExpressionModelElementFactory.createDefinedType((TypeDefinition)tpDef);
        InputPort tlarchInIsPoliceMode = iPort.apply("tlarchInIsPoliceMode", (IType)ExpressionModelElementFactory.boolType(), 34);
        InputPort tlarchInButtonA = iPort.apply("tlarchInButtonA", (IType)dTy.apply((TypeDefinition)this.signalEnum), 4);
        InputPort tlarchInButtonB = iPort.apply("tlarchInButtonB", (IType)dTy.apply((TypeDefinition)this.signalEnum), 10);
        TriFunction<String, IType, Integer, OutputPort> oPort = (n, ty, scale) -> {
            OutputPort r = ComponentModelElementFactory.createOutputPortAndAttach((Component)tlarch, (String)n, (IType)ty, (IExpressionTerm)NoVal.NOVAL.toITerm());
            LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)r, (int)(this.GRIDSIZE * 42), (int)(this.GRIDSIZE * scale));
            return r;
        };
        OutputPort tlarchOutTrafficSig = oPort.apply("tlarchOutTrafficSignal", (IType)dTy.apply((TypeDefinition)this.trafficColorEnum), 4);
        OutputPort tlarchOutPedestrianSig = oPort.apply("tlarchOutPedestrianSignal", (IType)dTy.apply((TypeDefinition)this.pedestrianColorEnum), 12);
        OutputPort tlarchOutIndicatorSigA = oPort.apply("tlarchOutIndicatorSignalA", (IType)dTy.apply((TypeDefinition)this.indicatorSignalEnum), 20);
        OutputPort tlarchOutIndicatorSigB = oPort.apply("tlarchOutIndicatorSignalB", (IType)dTy.apply((TypeDefinition)this.indicatorSignalEnum), 28);
        Component modes = ComponentModelElementFactory.createComponentAndAttach((Component)tlarch, (String)"Modes", (String)"", (boolean)false);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)modes, (int)(this.GRIDSIZE * 14), (int)(this.GRIDSIZE * 2), (int)216, (int)(this.GRIDSIZE * 30));
        iPort = (n, ty, scale) -> {
            InputPort res = ComponentModelElementFactory.createInputPortAndAttach((Component)modes, (String)n, (IType)ty, (IExpressionTerm)NoVal.NOVAL.toITerm());
            LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)res, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * scale));
            return res;
        };
        InputPort modesInIsPoliceMode = iPort.apply("modesInIsPoliceMode", (IType)ExpressionModelElementFactory.boolType(), 2);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)modesInIsPoliceMode, (EOrientation)EOrientation.SOUTH, (int)(this.GRIDSIZE * 8));
        InputPort modesInButtonA = iPort.apply("modesInButtonA", (IType)dTy.apply((TypeDefinition)this.signalEnum), 4);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)modesInButtonA, (EOrientation)EOrientation.WEST, (int)(this.GRIDSIZE * 2));
        InputPort modesInButtonB = iPort.apply("modesInButtonB", (IType)dTy.apply((TypeDefinition)this.signalEnum), 6);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)modesInButtonB, (EOrientation)EOrientation.WEST, (int)(this.GRIDSIZE * 8));
        oPort = (n, ty, scale) -> {
            OutputPort r = ComponentModelElementFactory.createOutputPortAndAttach((Component)modes, (String)n, (IType)ty, (IExpressionTerm)NoVal.NOVAL.toITerm());
            LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)r, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * scale));
            return r;
        };
        OutputPort modesOutTrafficSig = oPort.apply("modesOutTrafficSignal", (IType)dTy.apply((TypeDefinition)this.trafficColorEnum), 8);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)modesOutTrafficSig, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 2));
        OutputPort modesOutPedestrianSig = oPort.apply("modesOutPedestrianSignal", (IType)dTy.apply((TypeDefinition)this.pedestrianColorEnum), 10);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)modesOutPedestrianSig, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 10));
        OutputPort modesOutIndicatorSigA = oPort.apply("modesOutIndicatorSignalA", (IType)dTy.apply((TypeDefinition)this.indicatorSignalEnum), 12);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)modesOutIndicatorSigA, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 18));
        OutputPort modesOutIndicatorSigB = oPort.apply("modesOutIndicatorSignalB", (IType)dTy.apply((TypeDefinition)this.indicatorSignalEnum), 14);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)modesOutIndicatorSigB, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 26));
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"buttonA", (Port)tlarchInButtonA, (Port)modesInButtonA);
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"buttonB", (Port)tlarchInButtonB, (Port)modesInButtonB);
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"trafficSignal", (Port)modesOutTrafficSig, (Port)tlarchOutTrafficSig);
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"pedestrianSignal", (Port)modesOutPedestrianSig, (Port)tlarchOutPedestrianSig);
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"indicatorSignalA", (Port)modesOutIndicatorSigA, (Port)tlarchOutIndicatorSigA);
        ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"indicatorSignalB", (Port)modesOutIndicatorSigB, (Port)tlarchOutIndicatorSigB);
        Channel isPoliceMode = ComponentModelElementFactory.createChannelAndAttach((Component)tlarch, (String)"isPoliceMode", (Port)tlarchInIsPoliceMode, (Port)modesInIsPoliceMode);
        LayoutDataUtils.addBendPointToConnection((ILayoutedModelElement)isPoliceMode, (int)(this.GRIDSIZE * 23), (int)(this.GRIDSIZE * 35));
        this.createModeAutomatonBehavior(ca, modes);
    }

    protected void createModeAutomatonBehavior(ComponentArchitecture ca, Component comp) {
        ModeAutomaton modeAutomaton = ModeModelElementFactory.createModeAutomaton();
        comp.getSpecifications().add((Object)modeAutomaton);
        Mode rootMode = modeAutomaton.getRootMode();
        Mode normal = ModeModelElementFactory.createMode((Mode)rootMode, (String)"Normal", (String)"", (boolean)true);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)normal, (int)80, (int)80, (int)162, (int)86);
        Mode police = ModeModelElementFactory.createMode((Mode)rootMode, (String)"Police", (String)"", (boolean)false);
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)police, (int)350, (int)80, (int)162, (int)86);
        SwitchSegment n2p = ModeModelElementFactory.createSwitchSegment((Mode)rootMode, (Mode)normal, (Mode)police, (String)"normalToPolice", (String)"");
        ModeAutomatonUtils.setGuard((SwitchSegment)n2p, (String)"modesInIsPoliceMode == true");
        SwitchLayoutUtils.layoutSegment(n2p, EllipseLayoutUIUtils.getRadianFromDegree((double)340.0), EllipseLayoutUIUtils.getRadianFromDegree((double)200.0), this.GRIDSIZE * 24, this.GRIDSIZE * 5);
        SwitchSegment p2n = ModeModelElementFactory.createSwitchSegment((Mode)rootMode, (Mode)police, (Mode)normal, (String)"policeToNormal", (String)"");
        ModeAutomatonUtils.setGuard((SwitchSegment)p2n, (String)"modesInIsPoliceMode == false");
        SwitchLayoutUtils.layoutSegment(p2n, EllipseLayoutUIUtils.getRadianFromDegree((double)160.0), EllipseLayoutUIUtils.getRadianFromDegree((double)20.0), this.GRIDSIZE * 24, this.GRIDSIZE * 16);
        Component normalMode = (Component)KernelModelElementUtils.findContentElementByNameAndClass((EObject)ca, (String)"TL-Architecture", Component.class);
        normalMode.setName("NormalMode");
        ModeComponentStructureSpecification mcssNormal = ModeModelElementFactory.createModeCompStruSpec((Component)normalMode);
        normal.getSpecifications().add((Object)mcssNormal);
        SimpleTrafficLightsModesExample.changePortPrefix(normalMode, "tlarch", "modes");
        Component policeMode = (Component)EcoreUtils.copy((EObject)normalMode);
        policeMode.setName("PoliceMode");
        SimpleTrafficLightsModesExample.changePortPrefix(policeMode, "tlarch", "modes");
        BiConsumer<String, Integer> layoutOPort = (n, scale) -> {
            OutputPort port = (OutputPort)KernelModelElementUtils.findContentElementByNameAndClass((EObject)policeMode, (String)n, OutputPort.class);
            LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)port, (int)(this.GRIDSIZE * 42), (int)(this.GRIDSIZE * scale));
        };
        layoutOPort.accept("modesOutTrafficSignal", 4);
        layoutOPort.accept("modesOutPedestrianSignal", 12);
        layoutOPort.accept("modesOutIndicatorSignalA", 20);
        layoutOPort.accept("modesOutIndicatorSignalB", 28);
        Component stopAll = ComponentModelElementFactory.createComponent((String)"StopAll", (String)"");
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)stopAll, (int)(this.GRIDSIZE * 14), (int)(this.GRIDSIZE * 2), (int)216, (int)(this.GRIDSIZE * 30));
        policeMode.getContainedElements().add((Object)stopAll);
        InputPort stopAllInButtonA = ComponentModelElementFactory.createInputPortAndAttach((Component)stopAll, (String)"stopAllInButtonA", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.signalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)stopAllInButtonA, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 2));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)stopAllInButtonA, (EOrientation)EOrientation.WEST, (int)(this.GRIDSIZE * 2));
        InputPort stopAllInButtonB = ComponentModelElementFactory.createInputPortAndAttach((Component)stopAll, (String)"stopAllInButtonB", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.signalEnum), (IExpressionTerm)NoVal.NOVAL.toITerm());
        LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)stopAllInButtonB, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * 4));
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)stopAllInButtonB, (EOrientation)EOrientation.WEST, (int)(this.GRIDSIZE * 8));
        TriFunction<String, IType, Integer, OutputPort> oPort = (n, ty, scale) -> {
            OutputPort r = ComponentModelElementFactory.createOutputPortAndAttach((Component)stopAll, (String)n, (IType)ty, (IExpressionTerm)NoVal.NOVAL.toITerm());
            LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)r, (int)(this.GRIDSIZE * 2), (int)(this.GRIDSIZE * scale));
            return r;
        };
        OutputPort stopAllOutTrafficSignal = oPort.apply("stopAllOutTrafficSignal", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.trafficColorEnum), 6);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)stopAllOutTrafficSignal, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 2));
        OutputPort stopAllOutPedestrianSignal = oPort.apply("stopAllOutPedestrianSignal", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.pedestrianColorEnum), 8);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)stopAllOutPedestrianSignal, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 10));
        OutputPort stopAllOutIndicatorSignalA = oPort.apply("stopAllOutIndicatorSignalA", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.indicatorSignalEnum), 10);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)stopAllOutIndicatorSignalA, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 18));
        OutputPort stopAllOutIndicatorSignalB = oPort.apply("stopAllOutIndicatorSignalB", (IType)ExpressionModelElementFactory.createDefinedType((TypeDefinition)this.indicatorSignalEnum), 12);
        LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)stopAllOutIndicatorSignalB, (EOrientation)EOrientation.EAST, (int)(this.GRIDSIZE * 26));
        SimpleTrafficLightsModesExample.findChannelByName(policeMode, "buttonA").setTarget((IConnector)stopAllInButtonA);
        SimpleTrafficLightsModesExample.findChannelByName(policeMode, "buttonB").setTarget((IConnector)stopAllInButtonB);
        SimpleTrafficLightsModesExample.findChannelByName(policeMode, "trafficSignal").setSource((IConnector)stopAllOutTrafficSignal);
        SimpleTrafficLightsModesExample.findChannelByName(policeMode, "pedestrianSignal").setSource((IConnector)stopAllOutPedestrianSignal);
        SimpleTrafficLightsModesExample.findChannelByName(policeMode, "indicatorSignalA").setSource((IConnector)stopAllOutIndicatorSignalA);
        SimpleTrafficLightsModesExample.findChannelByName(policeMode, "indicatorSignalB").setSource((IConnector)stopAllOutIndicatorSignalB);
        policeMode.getConnections().remove((Object)SimpleTrafficLightsModesExample.findChannelByName(policeMode, "request"));
        Component merge = (Component)KernelModelElementUtils.findContentElementByNameAndClass((EObject)policeMode, (String)"Merge", Component.class);
        policeMode.getContainedElements().remove((Object)merge);
        Component controller = (Component)KernelModelElementUtils.findContentElementByNameAndClass((EObject)policeMode, (String)"Controller", Component.class);
        policeMode.getContainedElements().remove((Object)controller);
        String codeSpecStr = "stopAllOutTrafficSignal = Red(); stopAllOutPedestrianSignal = Stop();stopAllOutIndicatorSignalA = Off(); stopAllOutIndicatorSignalB = Off();return;";
        CodeSpecification codeSpec = BehaviorModelElementFactory.createCodeSpecification((StatementSequence)compiler.compileStatementTerm(codeSpecStr));
        stopAll.getSpecifications().add((Object)codeSpec);
        ModeComponentStructureSpecification mcssPolice = ModeModelElementFactory.createModeCompStruSpec((Component)policeMode);
        police.getSpecifications().add((Object)mcssPolice);
    }

    private static Channel findChannelByName(Component container, String channelName) {
        for (Channel ch : container.getChannels()) {
            if (!ch.getName().equals(channelName)) continue;
            return ch;
        }
        return null;
    }

    private static void changePortPrefix(Component container, String oldPrefix, String newPrefix) {
        for (IConnector p : container.getConnectors()) {
            String name;
            if (p instanceof InputPort) {
                name = ((InputPort)p).getName().replaceFirst("^" + oldPrefix, newPrefix);
                ((InputPort)p).setName(name);
                ((InputPort)p).setComment(name);
            }
            if (!(p instanceof OutputPort)) continue;
            name = ((OutputPort)p).getName().replaceFirst("^" + oldPrefix, newPrefix);
            ((OutputPort)p).setName(name);
            ((OutputPort)p).setComment(name);
        }
    }

    @FunctionalInterface
    static interface TriFunction<P1, P2, P3, R> {
        public R apply(P1 var1, P2 var2, P3 var3);
    }
}

