/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.ui.simulator.views.fx;

import java.util.Collection;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.ui.simulatorfx.views.GraphicalSimulationFXView;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.mode.model.SwitchSegment;
import org.fortiss.af3.mode.simulator.ExecutableModeAutomatonSpecification;
import org.fortiss.af3.mode.ui.editor.ModeAutomatonControllerFactory;
import org.fortiss.af3.mode.ui.editor.ModeAutomatonModelFactory;
import org.fortiss.af3.mode.ui.editor.ModeAutomatonVisualFactory;
import org.fortiss.af3.mode.ui.editor.visual.ModeVisual;
import org.fortiss.tooling.base.ui.editor.fx.controller.LayoutedRectangularResizableContentController;
import org.fortiss.tooling.base.ui.editor.fx.visual.NamedLayoutedCurveLinkVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewer;
import org.fortiss.tooling.common.ui.javafx.lwfxef.EDragGesture;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IClickController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IDragController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ClickControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;
import org.fortiss.tooling.common.util.LambdaUtils;

public class GraphicalModeSimulationFXView
extends GraphicalSimulationFXView<Component> {
    public static final String ID = GraphicalModeSimulationFXView.class.getName();

    public GraphicalModeSimulationFXView() {
        super(Component.class);
    }

    public Parent createFXPartScene() {
        ModeAutomaton automaton = this.extractStateAutomaton(this.getModelElement());
        ModeAutomatonModelFactory delegatingModelFactory = new ModeAutomatonModelFactory(automaton);
        SimulationModeAutomatonVisualFactory delegatingVisualFactory = new SimulationModeAutomatonVisualFactory();
        SimulationModeAutomatonControllerFactory delegatingControllerFactory = new SimulationModeAutomatonControllerFactory();
        this.viewer = new DiagramViewer(delegatingModelFactory, delegatingVisualFactory, delegatingControllerFactory, cb -> this.modelSelected(), chg -> this.applyModelChange()){

            public IDragController createDragController(IMVCBundle bundle, EDragGesture gesture, Node source, DiagramCoordinate lastMouseLocation) {
                return null;
            }
        };
        return this.viewer.getVisualNode();
    }

    protected void setModelElement(Component component) {
        ModeAutomaton automaton = this.extractStateAutomaton(this.getModelElement());
        this.viewer.updateModelVisual((Object)automaton);
    }

    private ModeAutomaton extractStateAutomaton(Component component) {
        Optional optional = LambdaUtils.firstOfType((Collection)component.getSpecifications(), ModeAutomaton.class);
        if (optional.isPresent()) {
            return (ModeAutomaton)optional.get();
        }
        return null;
    }

    protected void updateVisuals(Component component) {
        this.viewer.updateAllVisuals();
    }

    protected void setFxFocus() {
        this.viewer.requestFocus();
    }

    public final class SimulationModeAutomatonControllerFactory
    extends ModeAutomatonControllerFactory {
        @Override
        public IController createContentController(IContentMVCBundle model) {
            return new LayoutedRectangularResizableContentController<Mode>(model, Mode.class){

                public IClickController getClickController(Node node, DiagramCoordinate diagramLocation) {
                    return new ClickControllerBase(){

                        public Change doubleClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
                            return null;
                        }
                    };
                }
            };
        }
    }

    public final class SimulationModeAutomatonVisualFactory
    extends ModeAutomatonVisualFactory {
        @Override
        public ILinkVisual createLinkVisual(final ILinkMVCBundle modelBundle) {
            Object linkObj = modelBundle.getModel();
            if (linkObj instanceof SwitchSegment) {
                return new NamedLayoutedCurveLinkVisual<SwitchSegment>(modelBundle, SwitchSegment.class){

                    protected Paint getLineColor() {
                        Object model = modelBundle.getModel();
                        if (model instanceof SwitchSegment && GraphicalModeSimulationFXView.this.executable != null) {
                            SwitchSegment ts = (SwitchSegment)model;
                            ExecutableModeAutomatonSpecification exec = (ExecutableModeAutomatonSpecification)GraphicalModeSimulationFXView.this.executable;
                            boolean wasLastFired = exec.getLastFiredSwitchSegments().stream().anyMatch(tsp -> tsp.getSwitchSegment().equals(ts));
                            if (wasLastFired) {
                                return Color.RED;
                            }
                        }
                        return super.getLineColor();
                    }
                };
            }
            return null;
        }

        @Override
        public IContentVisual createContentVisual(final IContentMVCBundle modelBundle) {
            Object modelObj = modelBundle.getModel();
            if (modelObj instanceof Mode) {
                return new ModeVisual(modelBundle){

                    @Override
                    protected Paint getFillColor() {
                        Object model = modelBundle.getModel();
                        if (model instanceof Mode) {
                            ExecutableModeAutomatonSpecification exec;
                            Mode currentState;
                            Mode state = (Mode)model;
                            if (GraphicalModeSimulationFXView.this.executable != null && (currentState = (exec = (ExecutableModeAutomatonSpecification)GraphicalModeSimulationFXView.this.executable).getCurrentMode()).equals(state)) {
                                return Color.RED;
                            }
                        }
                        return super.getFillColor();
                    }
                };
            }
            return null;
        }
    }
}

