/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.commands;

import java.util.ArrayList;
import java.util.List;
import org.conqat.ide.commons.ui.ui.WorkbenchUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.ui.ToolingReuseUIActivator;
import org.fortiss.tooling.ext.reuse.ui.commands.NameValidator;
import org.fortiss.tooling.ext.reuse.ui.dialog.AddElementToLibDialog;
import org.fortiss.tooling.ext.reuse.ui.utils.ReuseLibraryUIUtils;
import org.fortiss.tooling.ext.reuse.ui.utils.ReuseLibraryViewUtils;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsManipulation;
import org.fortiss.tooling.kernel.internal.PrototypeService;
import org.fortiss.tooling.kernel.service.ICommandStackService;

public class AddElementToLibraryAction
extends Action {
    private static final String SHELL_TITLE = "Add Element to Reuse Library";
    private static final String ACTION_DESCRIPTION = "Adding a selected reuse element to a selected reuse library";
    private EObject selectedElement;
    private ReuseLibrary selectedLibrary;
    private List<String> currentExistingLibraryNames;
    private List<String> currentExistingLibraryElementNames;

    public AddElementToLibraryAction(EObject element) {
        super("Add to Reuse Library", ToolingReuseUIActivator.getImageDescriptor("icons/library_add.png"));
        this.selectedElement = element;
    }

    public void run() {
        String creationText;
        Boolean createNewLibrary;
        this.selectedLibrary = null;
        this.currentExistingLibraryNames = new ArrayList<String>();
        List libraryList = ReuseLibraryUtilsBasics.getAllLocalReuseLibraries();
        if (libraryList != null && !libraryList.isEmpty()) {
            for (ReuseLibrary tmpLibrary : libraryList) {
                this.currentExistingLibraryNames.add(ReuseLibraryUtilsBasics.getReuseElementName((EObject)tmpLibrary));
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            AddElementToLibDialog librarySelectDialog = new AddElementToLibDialog(shell, SHELL_TITLE);
            librarySelectDialog.setLibraryList(libraryList);
            librarySelectDialog.open();
            if (!librarySelectDialog.goAhead()) {
                return;
            }
            this.selectedLibrary = librarySelectDialog.getLibrary();
            createNewLibrary = librarySelectDialog.createNew();
            creationText = "A new library will be created in which the element can be added.\nEnter a name for the library:\n ";
        } else {
            createNewLibrary = true;
            creationText = "No library exists yet to add the element. A new one will be created.\nEnter a name for the library:\n ";
        }
        if (createNewLibrary.booleanValue()) {
            InputDialog creationDialog = new InputDialog(Display.getCurrent().getActiveShell(), SHELL_TITLE, creationText, "Reuse Library", (IInputValidator)new NameValidator(this.currentExistingLibraryNames, "reuse library"));
            if (creationDialog.open() != 0) {
                return;
            }
            if (ReuseLibraryUtilsBasics.doesReuseElementExistWithContext((EObject)this.selectedElement)) {
                ICommandStackService.getInstance().runAsCommand(this.selectedElement, () -> {
                    this.selectedLibrary = ReuseLibraryUtilsManipulation.createAndAddReuseLibrary((String)creationDialog.getValue());
                });
            } else {
                ReuseLibraryUIUtils.warnOfDeletedReuseElem(ACTION_DESCRIPTION, SHELL_TITLE);
                return;
            }
        }
        if (this.selectedLibrary == null) {
            return;
        }
        this.currentExistingLibraryElementNames = new ArrayList<String>();
        EList elementList = this.selectedLibrary.getReuseElementList();
        for (EObject libraryElement : elementList) {
            this.currentExistingLibraryElementNames.add(ReuseLibraryUtilsBasics.getReuseElementName((EObject)libraryElement));
        }
        InputDialog addingDialog = new InputDialog(Display.getCurrent().getActiveShell(), SHELL_TITLE, "Enter the name with which the element should be saved in the library '" + ReuseLibraryUtilsBasics.getReuseElementName((EObject)this.selectedLibrary) + "':\n ", ReuseLibraryUtilsBasics.getReuseElementName((EObject)this.selectedElement), (IInputValidator)new NameValidator(this.currentExistingLibraryElementNames, "reuse library element"));
        if (addingDialog.open() != 0) {
            return;
        }
        String newName = addingDialog.getValue();
        if (!ReuseLibraryUtilsBasics.doesReuseElementExistWithContext((EObject)this.selectedElement)) {
            ReuseLibraryUIUtils.warnOfDeletedReuseElem(ACTION_DESCRIPTION, SHELL_TITLE);
            return;
        }
        ICommandStackService.getInstance().runAsCommand(this.selectedElement, () -> this.addElement(this.selectedLibrary, this.selectedElement, newName));
        ReuseLibraryViewUtils.raiseAndUpdateReuseLibraryView();
    }

    protected void addElement(ReuseLibrary library, EObject elementToAdd, String saveName) {
        if (library == null || elementToAdd == null || saveName == null) {
            return;
        }
        EObject newElementForLibrary = ReuseLibraryUtilsManipulation.createElementForLibrary((EObject)elementToAdd, (ReuseLibrary)library, (String)saveName);
        try {
            ReuseLibraryUtilsManipulation.addElementToLibrary((EObject)newElementForLibrary, (ReuseLibrary)library);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)WorkbenchUtils.getActiveWorkbenchWindow().getShell(), (String)"Error in 'Add Element to Reuse Library'", (String)e.getMessage());
        }
        PrototypeService.getInstance().updatePrototypes();
        String currentActionType = "addToLibrary";
        ReuseLibraryUIUtils.manageExternalReferencesOfReuseElement(elementToAdd, currentActionType, SHELL_TITLE);
    }
}

