/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.commands;

import java.util.List;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.ui.ToolingReuseUIActivator;
import org.fortiss.tooling.ext.reuse.ui.utils.ReuseLibraryUIUtils;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.kernel.service.ICommandStackService;

public class GetUpdatedOriginsAction
extends Action {
    private static final String SHELL_TITLE = "Information about updated reuse origins";
    private static final String ACTION_DESCRIPTION = "Informing the user about updated reuse origins";
    private static final String UPDATED_ORIGIN_CONTEXT_MENU_STRING = "Get reuse update information";
    private EObject selectedElement;

    public GetUpdatedOriginsAction(EObject element) {
        super(UPDATED_ORIGIN_CONTEXT_MENU_STRING, ToolingReuseUIActivator.getImageDescriptor("icons/lib_update_info.png"));
        this.selectedElement = element;
    }

    public void run() {
        if (!ReuseLibraryUtilsBasics.doesReuseElementExistWithContext((EObject)this.selectedElement)) {
            ReuseLibraryUIUtils.warnOfDeletedReuseElem(ACTION_DESCRIPTION, SHELL_TITLE);
            return;
        }
        ICommandStackService.getInstance().runAsCommand(this.selectedElement, () -> this.displayOriginUpdateInfo(this.selectedElement));
    }

    private void displayOriginUpdateInfo(EObject reuseElement) {
        Object infoMessage;
        if (reuseElement == null) {
            return;
        }
        List updatedReuseOrigins = ReuseLibraryUtilsBasics.getAllUpdatedOrigins((EObject)reuseElement);
        if (updatedReuseOrigins.isEmpty()) {
            infoMessage = "None of the found reuse origins was updated since the selected reuse element was reused or updated (based of these origins).\n\nTherefore, it is not needed to get updates from any of them except you want to get the original version (e.g., if you have manipulated the selected reuse element in the meantime and want to reset it).\n\nKeep in mind: Updated reuse origins cannot be found if your local reuse libraries are not up to date as well!";
        } else {
            infoMessage = "The following reuse origins of the selected reuse element were updated since the selected reuse element was reused or updated (based of these origins):\n";
            for (EObject updatedReuseOrigin : updatedReuseOrigins) {
                String reuseElementName = ReuseLibraryUtilsBasics.getReuseElementName((EObject)updatedReuseOrigin);
                ReuseLibrary library = ReuseLibraryUtilsBasics.getFirstSourceLibraryOfElement((EObject)updatedReuseOrigin);
                String libraryName = ReuseLibraryUtilsBasics.getLibraryIDName((ReuseLibrary)library);
                boolean stringIsForDisplay = true;
                String lastUpdate = ReuseLibraryUtilsBasics.getReuseElementLastUpdateString((EObject)updatedReuseOrigin, (boolean)stringIsForDisplay);
                infoMessage = (String)infoMessage + "\nName: '" + reuseElementName + "'\n";
                infoMessage = (String)infoMessage + "Within library: '" + libraryName + "'\n";
                infoMessage = (String)infoMessage + "Last updated: " + lastUpdate + "\n";
            }
            infoMessage = (String)infoMessage + "\nIf you want to get one of these updates, please use the 'Update from Reuse Library' context menu entry.";
        }
        MessageUtils.showInfo((String)SHELL_TITLE, (String)infoMessage);
    }
}

