/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.fortiss.tooling.ext.reuse.model.ReuseElementSpec;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.ui.ToolingReuseUIActivator;
import org.fortiss.tooling.ext.reuse.ui.commands.NameValidator;
import org.fortiss.tooling.ext.reuse.ui.utils.ReuseLibraryUIUtils;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsManipulation;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class UpdateElementFromLibraryAction
extends Action {
    private static final String SHELL_TITLE = "Update Element From Reuse Library";
    private static final String ACTION_DESCRIPTION = "Updating the selected reuse element from a selected reuse library";
    public static final String UPDATE_FROM_CONTEXT_MENU_STRING = "Update from Reuse Library";
    private EObject selectedElement;

    public UpdateElementFromLibraryAction(EObject element) {
        super(UPDATE_FROM_CONTEXT_MENU_STRING, ToolingReuseUIActivator.getImageDescriptor("icons/update_from_library.png"));
        this.selectedElement = element;
    }

    public void run() {
        boolean confirmed;
        EObject originalLibraryElement;
        ReuseElementSpec correctLibrarySpec = ReuseLibraryUIUtils.selectCorrectReuseSpec(this.selectedElement, SHELL_TITLE);
        if (correctLibrarySpec == null) {
            return;
        }
        ReuseLibrary correctLibrary = ReuseLibraryUtilsBasics.getLocalReuseLibraryByID((String)correctLibrarySpec.getSourceLibUUID());
        if (correctLibrary == null) {
            ReuseLibraryUIUtils.warnOfMissingLib(correctLibrarySpec, SHELL_TITLE);
            return;
        }
        String currentNameInProject = ReuseLibraryUtilsBasics.getReuseElementName((EObject)this.selectedElement);
        String currentProjectName = "not found";
        EList parentList = EcoreUtils.getParentsWithType((EObject)this.selectedElement, INamedCommentedElement.class);
        if (parentList != null && !parentList.isEmpty()) {
            INamedCommentedElement root = (INamedCommentedElement)parentList.get(parentList.size() - 1);
            currentProjectName = root.getName();
        }
        if ((originalLibraryElement = ReuseLibraryUIUtils.checkForElementInLibrary(correctLibrary, correctLibrarySpec, SHELL_TITLE)) == null) {
            return;
        }
        boolean keepAdditionalReferences = ReuseLibraryUIUtils.isKeepingAdditionalReferencesRequested(this.selectedElement, correctLibrarySpec, SHELL_TITLE);
        String currentNameInLibrary = ReuseLibraryUtilsBasics.getReuseElementName((EObject)originalLibraryElement);
        ArrayList<Object> textLines = new ArrayList<Object>();
        textLines.add("Confirm the following update (from source to target):");
        textLines.add("\n- Update source: corresponding element in library");
        textLines.add("    > element name: " + currentNameInLibrary);
        textLines.add("    > in library: " + ReuseLibraryUtilsBasics.getLibraryIDName((ReuseLibrary)correctLibrary));
        textLines.add("\n- Update target: element in current project");
        textLines.add("    > element name: " + currentNameInProject);
        textLines.add("    > in project: " + currentProjectName);
        if (ReuseLibraryUtilsBasics.getNumberOfContainedReuseSpecs((EObject)this.selectedElement) > 1) {
            if (keepAdditionalReferences) {
                textLines.add("\nBesides the current update reference, all (old) additional library references will be kept within the element.");
            } else {
                textLines.add("\nAfter this step, the element will only contain the current update reference and all (old) additional library references will be removed.");
            }
        }
        if (!(confirmed = MessageUtils.confirm((String)SHELL_TITLE, (String)String.join((CharSequence)"\n", textLines)))) {
            return;
        }
        InputDialog updateDialog = new InputDialog(Display.getCurrent().getActiveShell(), SHELL_TITLE, "Enter the name with which the element should be updated in the project:\n(Current name in project: " + currentNameInProject + ")\n ", currentNameInProject, (IInputValidator)new NameValidator(Collections.emptyList(), "reuse element"));
        if (updateDialog.open() != 0) {
            return;
        }
        String updateName = updateDialog.getValue();
        if (!ReuseLibraryUtilsBasics.doesReuseElementExistWithContext((EObject)this.selectedElement)) {
            ReuseLibraryUIUtils.warnOfDeletedReuseElem(ACTION_DESCRIPTION, SHELL_TITLE);
            return;
        }
        ICommandStackService.getInstance().runAsCommand(this.selectedElement, () -> this.updateElementFromLibrary(this.selectedElement, correctLibrary, correctLibrarySpec, updateName, keepAdditionalReferences));
    }

    private void updateElementFromLibrary(EObject elementToBeUpdated, ReuseLibrary library, ReuseElementSpec referencingSpec, String newName, boolean keepAdditionalReferences) {
        if (library == null || elementToBeUpdated == null || referencingSpec == null || newName == null) {
            return;
        }
        EObject originalLibraryElement = ReuseLibraryUIUtils.checkForElementInLibrary(library, referencingSpec, SHELL_TITLE);
        if (originalLibraryElement == null) {
            return;
        }
        EObject updatedElement = ReuseLibraryUtilsManipulation.replaceElementInProject((EObject)elementToBeUpdated, (EObject)originalLibraryElement, (String)newName, (boolean)keepAdditionalReferences);
        if (updatedElement == null) {
            String infoTitle = "Update Element From Reuse Library - Replacement Failed";
            String infoMessage = "The replacement of '" + ReuseLibraryUtilsBasics.getReuseElementName((EObject)elementToBeUpdated) + "' with '" + ReuseLibraryUtilsBasics.getReuseElementName((EObject)originalLibraryElement) + "' has failed.";
            MessageUtils.showInfo((String)infoTitle, (String)infoMessage);
            return;
        }
        ReuseLibraryUtilsManipulation.fixIDs((EObject)updatedElement);
        String currentActionType = "updateFromLibrary";
        ReuseLibraryUIUtils.manageExternalReferencesOfReuseElement(originalLibraryElement, currentActionType, SHELL_TITLE);
    }
}

