/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.commands;

import java.util.ArrayList;
import java.util.List;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.conqat.ide.commons.ui.ui.WorkbenchUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.tooling.ext.reuse.model.ReuseElementSpec;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.storage.ReuseLibraryStorageManager;
import org.fortiss.tooling.ext.reuse.ui.ToolingReuseUIActivator;
import org.fortiss.tooling.ext.reuse.ui.utils.ReuseLibraryUIUtils;
import org.fortiss.tooling.ext.reuse.ui.utils.ReuseLibraryViewUtils;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsManipulation;
import org.fortiss.tooling.kernel.internal.PrototypeService;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class UpdateElementInLibraryAction
extends Action {
    private static final String SHELL_TITLE = "Update Element In Reuse Library";
    private static final String ACTION_DESCRIPTION = "Updating the selected reuse element inside the selected reuse library";
    private static final String UPDATE_IN_CONTEXT_MENU_STRING = "Update in Reuse Library";
    private EObject selectedElement;
    private List<String> currentExistingLibraryElementNames;

    public UpdateElementInLibraryAction(EObject element) {
        super(UPDATE_IN_CONTEXT_MENU_STRING, ToolingReuseUIActivator.getImageDescriptor("icons/update_in_library.png"));
        this.selectedElement = element;
    }

    public void run() {
        ReuseElementSpec correctLibrarySpec = ReuseLibraryUIUtils.selectCorrectReuseSpec(this.selectedElement, SHELL_TITLE);
        if (correctLibrarySpec == null) {
            return;
        }
        ReuseLibrary correctLibrary = ReuseLibraryUtilsBasics.getLocalReuseLibraryByID((String)correctLibrarySpec.getSourceLibUUID());
        if (correctLibrary == null) {
            ReuseLibraryUIUtils.warnOfMissingLib(correctLibrarySpec, SHELL_TITLE);
            return;
        }
        EObject originalLibraryElement = ReuseLibraryUIUtils.checkForElementInLibrary(correctLibrary, correctLibrarySpec, SHELL_TITLE);
        if (originalLibraryElement == null) {
            return;
        }
        String currentNameInLibrary = ReuseLibraryUtilsBasics.getReuseElementName((EObject)originalLibraryElement);
        String currentProjectName = "not found";
        EList parentList = EcoreUtils.getParentsWithType((EObject)this.selectedElement, INamedCommentedElement.class);
        if (parentList != null && !parentList.isEmpty()) {
            INamedCommentedElement root = (INamedCommentedElement)parentList.get(parentList.size() - 1);
            currentProjectName = root.getName();
        }
        ArrayList<Object> textLines = new ArrayList<Object>();
        textLines.add("Confirm the following update (from source to target):");
        textLines.add("\n- Update source: element in current project");
        textLines.add("    > element name: " + ReuseLibraryUtilsBasics.getReuseElementName((EObject)this.selectedElement));
        textLines.add("    > in project: " + currentProjectName);
        textLines.add("\n- Update target: element in library");
        textLines.add("    > element name: " + currentNameInLibrary);
        textLines.add("    > in library: " + ReuseLibraryUtilsBasics.getLibraryIDName((ReuseLibrary)correctLibrary));
        boolean confirmed = MessageUtils.confirm((String)SHELL_TITLE, (String)String.join((CharSequence)"\n", textLines));
        if (!confirmed) {
            return;
        }
        this.currentExistingLibraryElementNames = new ArrayList<String>();
        EList elementList = correctLibrary.getReuseElementList();
        for (EObject libraryElement : elementList) {
            String name = ReuseLibraryUtilsBasics.getReuseElementName((EObject)libraryElement);
            if (name.equals(currentNameInLibrary)) continue;
            this.currentExistingLibraryElementNames.add(name);
        }
        InputDialog updateDialog = new InputDialog(Display.getCurrent().getActiveShell(), SHELL_TITLE, "Enter the name with which the element should be updated in the library '" + ReuseLibraryUtilsBasics.getReuseElementName((EObject)correctLibrary) + "':\n(Current name in library: " + currentNameInLibrary + ")\n ", currentNameInLibrary, (IInputValidator)new UpdatedNameValidator());
        if (updateDialog.open() != 0) {
            return;
        }
        String updateName = updateDialog.getValue();
        if (!ReuseLibraryUtilsBasics.doesReuseElementExistWithContext((EObject)this.selectedElement)) {
            ReuseLibraryUIUtils.warnOfDeletedReuseElem(ACTION_DESCRIPTION, SHELL_TITLE);
            return;
        }
        ICommandStackService.getInstance().runAsCommand(this.selectedElement, () -> this.updateElemInLib(this.selectedElement, correctLibrary, correctLibrarySpec, updateName));
        ReuseLibraryViewUtils.raiseAndUpdateReuseLibraryView();
    }

    private void updateElemInLib(EObject newElement, ReuseLibrary library, ReuseElementSpec referencingSpec, String newName) {
        if (library == null || newElement == null || referencingSpec == null || newName == null) {
            return;
        }
        EObject originalLibraryElement = ReuseLibraryUIUtils.checkForElementInLibrary(library, referencingSpec, SHELL_TITLE);
        if (originalLibraryElement == null) {
            return;
        }
        ReuseLibraryUtilsManipulation.replaceElementInLibrary((EObject)originalLibraryElement, (EObject)newElement, (ReuseElementSpec)referencingSpec, (String)newName);
        try {
            ReuseLibraryStorageManager.saveReuseLibrary((ReuseLibrary)library);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)WorkbenchUtils.getActiveWorkbenchWindow().getShell(), (String)"Error in 'Update Element In Reuse Library'", (String)e.getMessage());
        }
        PrototypeService.getInstance().updatePrototypes();
        String currentActionType = "updateInLibrary";
        ReuseLibraryUIUtils.manageExternalReferencesOfReuseElement(newElement, currentActionType, SHELL_TITLE);
    }

    private class UpdatedNameValidator
    implements IInputValidator {
        private UpdatedNameValidator() {
        }

        public String isValid(String newText) {
            if (newText.equals("")) {
                return "A name needs to be specified.";
            }
            for (String name : UpdateElementInLibraryAction.this.currentExistingLibraryElementNames) {
                if (!newText.equals(name)) continue;
                return "This name already exists. Please use another.";
            }
            return null;
        }
    }
}

