/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;

public class AddElementToLibDialog
extends Dialog {
    private static final int CREATE_ID = 100;
    private String title;
    private Combo comboFormat;
    private ReuseLibrary library;
    private boolean goAhead = false;
    private boolean createNew = false;
    private List<ReuseLibrary> libraries = new ArrayList<ReuseLibrary>();

    public AddElementToLibDialog(Shell parentShell, String dialogTitle) {
        super(parentShell);
        this.title = dialogTitle;
        this.setShellStyle(32);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 100) {
            this.createPressed();
        }
    }

    protected void okPressed() {
        this.library = this.libraries.get(this.comboFormat.getSelectionIndex());
        this.goAhead = true;
        super.okPressed();
    }

    protected void createPressed() {
        this.library = null;
        this.createNew = true;
        this.goAhead = true;
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Label initText = new Label(container, 0);
        initText.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        initText.setText("Select the library in which the element should be saved:");
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        Label selectionText = new Label(container2, 0);
        selectionText.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        selectionText.setText("Library (name and UUID): ");
        this.comboFormat = new Combo(container2, 8);
        this.comboFormat.setItems(this.getLibraryIDNames(this.libraries).toArray(new String[0]));
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 315;
        this.comboFormat.setLayoutData((Object)gd_combo);
        this.comboFormat.select(0);
        Label creationText = new Label(container, 0);
        creationText.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        creationText.setText("Or create a new library...");
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 100, "Create new library", false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(520, 190);
    }

    protected List<String> getLibraryIDNames(List<ReuseLibrary> libraries) {
        ArrayList<String> names = new ArrayList<String>();
        for (ReuseLibrary library : libraries) {
            names.add(ReuseLibraryUtilsBasics.getLibraryIDName((ReuseLibrary)library));
        }
        return names;
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public ReuseLibrary getLibrary() {
        return this.library;
    }

    public boolean createNew() {
        return this.createNew;
    }

    public void setLibraryList(List<ReuseLibrary> possibleLibraries) {
        this.libraries = possibleLibraries;
    }
}

