/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.menus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.fortiss.tooling.ext.reuse.ui.ToolingReuseUIActivator;
import org.fortiss.tooling.ext.reuse.ui.commands.AddElementToLibraryAction;
import org.fortiss.tooling.ext.reuse.ui.commands.GetUpdatedOriginsAction;
import org.fortiss.tooling.ext.reuse.ui.commands.UpdateElementFromLibraryAction;
import org.fortiss.tooling.ext.reuse.ui.commands.UpdateElementInLibraryAction;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public class ReuseLibrarySubContextMenu
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection != null && this.canBeAdded(selection)) {
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            MenuManager subMenu = new MenuManager();
            subMenu.setMenuText("Reuse Manager");
            subMenu.setImageDescriptor(ToolingReuseUIActivator.getImageDescriptor("icons/library.png"));
            ArrayList<Action> subMenuActions = new ArrayList<Action>();
            subMenuActions.add(new AddElementToLibraryAction(selection));
            subMenuActions.add(new UpdateElementInLibraryAction(selection));
            subMenuActions.add(new UpdateElementFromLibraryAction(selection));
            subMenuActions.add(new GetUpdatedOriginsAction(selection));
            for (IAction iAction : subMenuActions) {
                ActionContributionItem subMenuItem = new ActionContributionItem(iAction);
                subMenu.add((IContributionItem)subMenuItem);
            }
            contributionItems.add((IContributionItem)subMenu);
            return contributionItems;
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "beforeglobal";
    }

    protected boolean canBeAdded(EObject element) {
        return ReuseLibraryUtilsBasics.hasReusePossibility((EObject)element);
    }
}

