/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.prototypes;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.ui.ToolingReuseUIActivator;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.kernel.extension.base.PrototypeProviderBase;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public final class PrototypeProvider
extends PrototypeProviderBase {
    public static final String DEFAULT_ROOT_REUSE_ELEMENT_NAME = "Reuse Library";

    protected void registerPrototypes() {
        List libraryList = ReuseLibraryUtilsBasics.getAllLocalReuseLibraries();
        if (libraryList == null || libraryList.isEmpty()) {
            return;
        }
        for (ReuseLibrary library : libraryList) {
            String libraryName;
            String categoryName = libraryName = ReuseLibraryUtilsBasics.getReuseElementName((EObject)library);
            this.registerPrimaryPrototype(libraryName, (EObject)library, categoryName);
            try {
                this.setPrototypeCategoryPriority(categoryName, -10);
            }
            catch (IllegalArgumentException e) {
                LoggingUtils.error((Plugin)ToolingReuseUIActivator.getDefault(), (String)("Error setting the category priority for the reuse library '" + categoryName + "'."), (Throwable)e);
                LoggingUtils.showError((String)("Cannot set category priortiy for '" + categoryName + "'."));
            }
            EList reuseElementList = library.getReuseElementList();
            for (EObject libraryElement : reuseElementList) {
                this.registerPrototype(ReuseLibraryUtilsBasics.getReuseElementName((EObject)libraryElement), libraryElement, libraryName);
            }
        }
    }
}

