/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.utils;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.conqat.ide.commons.ui.ui.WorkbenchUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.common.ui.javafx.util.GraphicUtils;
import org.fortiss.tooling.ext.reuse.model.ReuseElementSpec;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.storage.ReuseLibraryStorageManager;
import org.fortiss.tooling.ext.reuse.ui.ToolingReuseUIActivator;
import org.fortiss.tooling.ext.reuse.ui.dialog.SelectLibDialog;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;

public class ReuseLibraryUIUtils {
    private static final Double DIALOG_WINDOW_WIDTH_PREF = 700.0;
    private static final Double DIALOG_WINDOW_HEIGHT_PREF = 500.0;

    public static ReuseElementSpec selectCorrectReuseSpec(EObject element, String dialogTitle) {
        if (element instanceof IModelElement) {
            List specs = ReuseLibraryUtilsBasics.getAllReuseSpecs((EObject)element);
            if (specs.size() == 1) {
                return (ReuseElementSpec)specs.get(0);
            }
            if (specs.size() > 1) {
                ArrayList<String> referencedLibrarySelection = new ArrayList<String>();
                for (ReuseElementSpec spec : specs) {
                    referencedLibrarySelection.add(ReuseLibraryUtilsBasics.getLibraryIDNameFormat((String)spec.getSourceLibUUID(), (String)spec.getSourceLibName()) + " with reference to element '" + spec.getElementName() + "'");
                }
                Shell shell = WorkbenchUtils.getActiveWorkbenchWindow().getShell();
                SelectLibDialog selectLibraryDialog = new SelectLibDialog(shell, dialogTitle);
                selectLibraryDialog.setLibraryNameList(referencedLibrarySelection);
                selectLibraryDialog.open();
                if (selectLibraryDialog.goAhead()) {
                    return (ReuseElementSpec)specs.get(selectLibraryDialog.getSelectionIndex());
                }
            }
        }
        return null;
    }

    public static boolean isKeepingAdditionalReferencesRequested(EObject element, ReuseElementSpec mainReference, String dialogTitle) {
        List specs;
        if (element instanceof IModelElement && (specs = ReuseLibraryUtilsBasics.getAllReuseSpecs((EObject)element)).size() > 1) {
            ArrayList<CallSite> additionalLibraryReferences = new ArrayList<CallSite>();
            for (ReuseElementSpec spec : specs) {
                if (spec == mainReference) continue;
                additionalLibraryReferences.add((CallSite)((Object)("- Library '" + ReuseLibraryUtilsBasics.getLibraryIDNameFormat((String)spec.getSourceLibUUID(), (String)spec.getSourceLibName()) + "' with '" + spec.getElementName() + "' as element name in the library")));
            }
            ArrayList<Object> textLines = new ArrayList<Object>();
            textLines.add("The following additional library references were found in the selected element:");
            textLines.addAll(additionalLibraryReferences);
            textLines.add("\nDo you want to keep them after the update?");
            textLines.add("- Yes: All additional (old) references will be kept together with the one of the current update.");
            textLines.add("- No: Then, only the library reference of the current update will further exist.");
            return MessageUtils.askQuestion((String)dialogTitle, (String)String.join((CharSequence)"\n", textLines));
        }
        return false;
    }

    public static EObject checkForElementInLibrary(ReuseLibrary library, ReuseElementSpec referencingSpec, String dialogTitle) {
        String targetUuid = referencingSpec.getElementUUID();
        EObject originalElementInLibrary = ReuseLibraryUtilsBasics.getElementInsideLibrary((ReuseLibrary)library, (String)targetUuid);
        if (originalElementInLibrary == null) {
            ReuseLibraryUIUtils.warnOfMissingReuseElem(referencingSpec, dialogTitle);
        }
        return originalElementInLibrary;
    }

    public static void warnOfMissingReuseElem(ReuseElementSpec referencingSpec, String dialogTitle) {
        ArrayList<Object> textLines = new ArrayList<Object>();
        textLines.add("The referenced element does not exist in the referenced library.");
        textLines.add("\nSearched for element UUID: " + referencingSpec.getElementUUID());
        textLines.add("in library: " + ReuseLibraryUtilsBasics.getLibraryIDNameFormat((String)referencingSpec.getSourceLibUUID(), (String)referencingSpec.getSourceLibName()));
        MessageUtils.showWarning((String)(dialogTitle + " - Missing Element"), (String)String.join((CharSequence)"\n", textLines));
    }

    public static void warnOfMissingLib(ReuseElementSpec referencingSpec, String dialogTitle) {
        ArrayList<Object> textLines = new ArrayList<Object>();
        textLines.add("The selected library does not exist in the library directory.");
        textLines.add("\nPlease add it there and repeat.");
        textLines.add("\nMissing library (UUID and name): " + ReuseLibraryUtilsBasics.getLibraryIDNameFormat((String)referencingSpec.getSourceLibUUID(), (String)referencingSpec.getSourceLibName()));
        textLines.add("\nLibrary directory location: " + ReuseLibraryStorageManager.REUSE_PROJECT_DIR.getAbsolutePath());
        MessageUtils.showWarning((String)(dialogTitle + " - Missing Library"), (String)String.join((CharSequence)"\n", textLines));
    }

    public static void warnOfDeletedReuseElem(String currentAction, String dialogTitle) {
        ArrayList<Object> textLines = new ArrayList<Object>();
        textLines.add("The following action could not successfully be performed since the initially selected reuse element for this action does not exist anymore.");
        textLines.add("\nFailed action: '" + currentAction + "'.");
        textLines.add("\nPlease, do not delete a reuse element as long as your chosen action for it has not fully terminated.");
        MessageUtils.showWarning((String)(dialogTitle + " - Missing Element"), (String)String.join((CharSequence)"\n", textLines));
    }

    public static void manageExternalReferencesOfReuseElement(EObject reuseElement, String actionType, String shellTitle) {
        String infoTitle = shellTitle + " - External References";
        String actionText = "";
        String currentReuseTest = "";
        String sourceText = "";
        switch (actionType) {
            case "addToLibrary": {
                actionText = "added to the library";
                sourceText = "the added element";
                break;
            }
            case "updateInLibrary": {
                actionText = "updated in the library";
                sourceText = "the source element from the project";
                break;
            }
            case "updateFromLibrary": {
                actionText = "updated from the library";
                currentReuseTest = " (like now)";
                sourceText = "the source element from the library";
                break;
            }
            default: {
                MessageUtils.showInfo((String)infoTitle, (String)("Cannot manage external references of the reuse element, because the given action type is not known: '" + actionType + "'\n\nPlease inform a developer to correct this in the source code."));
                return;
            }
        }
        List externalRefs = ReuseLibraryUtilsBasics.getExternalReferencesOfElement((EObject)reuseElement);
        if (!externalRefs.isEmpty()) {
            String headerText = "The following elements were found as references inside the reuse element you " + actionText + ".\n\nIn case of reusing this element" + currentReuseTest + ", these referenced elements will be needed in the new environment, too. Therefore, you might want to add/update these reference elements as well (if not already done).\n";
            Object bodyText = "";
            for (EObject externalRef : externalRefs) {
                bodyText = (String)bodyText + "\n- " + ReuseLibraryUtilsBasics.getReuseElementName((EObject)externalRef) + " (" + externalRef.getClass().getSimpleName() + ")";
                if (!ReuseLibraryUtilsBasics.getReuseElementName((EObject)externalRef).equals(ReuseLibraryUtilsBasics.getReuseElementName((EObject)reuseElement))) continue;
                bodyText = (String)bodyText + " [ignore this if it is actually " + sourceText + "]";
            }
            ReuseLibraryUIUtils.showBasicScrollableInformation(shellTitle, headerText, (String)bodyText);
        }
    }

    public static void showBasicScrollableInformation(String windowTitle, String headerText, String bodyText) {
        boolean showSymbol = true;
        ReuseLibraryUIUtils.showCustomScrollableAlert(Alert.AlertType.INFORMATION, windowTitle, headerText, bodyText, showSymbol, DIALOG_WINDOW_WIDTH_PREF, DIALOG_WINDOW_HEIGHT_PREF);
    }

    public static void showCustomScrollableAlert(Alert.AlertType alertType, String windowTitle, String headerText, String bodyText, boolean showSymbol, Double windowPrefWidth, Double windowPrefHeight) {
        Alert alert = new Alert(alertType);
        if (!showSymbol) {
            alert.setGraphic(null);
        }
        alert.setTitle(windowTitle);
        alert.setHeaderText(headerText);
        alert.setResizable(true);
        TextArea area = new TextArea(bodyText);
        area.setWrapText(true);
        area.setEditable(false);
        DialogPane dialogPane = alert.getDialogPane();
        Image taskbarIcon = GraphicUtils.getFXImage((String)ToolingReuseUIActivator.PLUGIN_ID, (String)"icons/af3_icon64.png");
        Stage stage = (Stage)dialogPane.getScene().getWindow();
        stage.getIcons().add((Object)taskbarIcon);
        dialogPane.setContent((Node)area);
        if (windowPrefWidth != null && windowPrefWidth > 0.0) {
            dialogPane.setPrefWidth(windowPrefWidth.doubleValue());
        }
        if (windowPrefHeight != null && windowPrefHeight > 0.0) {
            dialogPane.setPrefHeight(windowPrefHeight.doubleValue());
        }
        alert.showAndWait();
    }
}

