/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.view.fx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.ui.view.fx.ReuseLibraryFXController;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;

public class ReuseLibraryFXContentProvider
extends DynamicTreeContentProviderBase<EObject> {
    protected Collection<? extends EObject> getChildren(EObject parent) {
        if (parent instanceof ReuseLibraryFXController.LibraryContainer) {
            return ((ReuseLibraryFXController.LibraryContainer)parent).libraries;
        }
        if (parent instanceof ReuseLibrary) {
            return ((ReuseLibrary)parent).getReuseElementList();
        }
        return Collections.emptyList();
    }

    protected boolean filter(EObject element, String filterValue) {
        if (element == null) {
            return false;
        }
        if (filterValue == null || "".equals(filterValue.trim())) {
            return true;
        }
        return this.filterForReuse(element, filterValue);
    }

    private boolean filterForReuse(EObject element, String filter) {
        if (ReuseLibraryUtilsBasics.isCorrectReuseElementOrLibrary((EObject)element)) {
            ArrayList<EObject> elementsToCheck = new ArrayList<EObject>();
            elementsToCheck.add(element);
            if (element instanceof ReuseLibrary) {
                for (EObject libraryElement : ((ReuseLibrary)element).getReuseElementList()) {
                    elementsToCheck.add(libraryElement);
                }
            }
            boolean matchFound = false;
            boolean isForDisplay = true;
            for (EObject elementToCheck : elementsToCheck) {
                String elementName = ReuseLibraryUtilsBasics.getReuseElementName((EObject)elementToCheck);
                String elementUUID = ReuseLibraryUtilsBasics.getFirstReuseElementUUID((EObject)elementToCheck);
                String elementUpdateDateForDisplay = ReuseLibraryUtilsBasics.getReuseElementLastUpdateString((EObject)elementToCheck, (boolean)isForDisplay);
                String elementUpdateDateForInternalUse = ReuseLibraryUtilsBasics.getReuseElementLastUpdateString((EObject)elementToCheck, (!isForDisplay ? 1 : 0) != 0);
                String elementComment = ReuseLibraryUtilsBasics.getReuseElementComment((EObject)elementToCheck);
                boolean bl = matchFound = this.isNameMatchForFilter(elementName, filter) || this.isNameMatchForFilter(elementUUID, filter) || this.isNameMatchForFilter(elementUpdateDateForDisplay, filter) || this.isNameMatchForFilter(elementUpdateDateForInternalUse, filter) || this.isNameMatchForFilter(elementComment, filter);
                if (!matchFound) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNameMatchForFilter(String name, String filter) {
        return name.toLowerCase().contains(filter.toLowerCase());
    }
}

