/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.view.fx;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeTableView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.ui.view.fx.ReuseLibraryFXContentProvider;
import org.fortiss.tooling.ext.reuse.ui.view.fx.ReuseLibraryFXTreeTableUIProvider;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;

public class ReuseLibraryFXController
extends CompositeFXControllerBase<SplitPane, Node> {
    @FXML
    private TreeTableView<EObject> reuseLibraryTreeTableView;
    @FXML
    private Button refreshButton;
    @FXML
    private Label topLabel;
    @FXML
    private TextField textSearch;
    private DynamicTreeTableViewer<EObject> treeTableViewer;
    private LibraryContainer root = new LibraryContainer();
    private final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss");

    public ReuseLibraryFXController() {
        super(new ICompositeFXController[0]);
    }

    public String getFXMLLocation() {
        return "ReuseLibraryViewFx.fxml";
    }

    public void initialize() {
        this.setupLibraryTreeTable();
    }

    private void setupLibraryTreeTable() {
        ReuseLibraryFXContentProvider contentProvider = new ReuseLibraryFXContentProvider();
        ReuseLibraryFXTreeTableUIProvider uiProvider = new ReuseLibraryFXTreeTableUIProvider(this);
        this.textSearch.textProperty().addListener((obs, oldVal, newVal) -> {
            contentProvider.setFilterExpression((String)newVal);
            this.safelyUpdateViewer();
        });
        boolean showRoot = false;
        int revealLevel = 0;
        this.treeTableViewer = new DynamicTreeTableViewer(this.reuseLibraryTreeTableView, (Object)this.root, showRoot, revealLevel, (DynamicTreeContentProviderBase)contentProvider, (DynamicTreeTableUIProviderBase)uiProvider);
        this.treeTableViewer.addColumn("Reuse Library Name", 200);
        this.treeTableViewer.addColumn("Reuse Element Name", 200);
        this.treeTableViewer.addColumn("UUID", 170);
        this.treeTableViewer.addColumn("Last Update", 120);
        this.treeTableViewer.addColumn("Comment", 300);
        boolean librariesFound = this.updateRootContainer();
        if (librariesFound) {
            this.updateLibraryTreeTable();
        }
    }

    private void safelyUpdateViewer() {
        if (this.treeTableViewer == null) {
            this.setupLibraryTreeTable();
        } else {
            this.treeTableViewer.update();
        }
    }

    private void updateLibraryTreeTable() {
        this.safelyUpdateViewer();
        LocalDateTime currentTime = LocalDateTime.now();
        this.topLabel.setText("Library view was updated at " + this.timeFormat.format(currentTime));
    }

    private boolean updateRootContainer() {
        List libraries = ReuseLibraryUtilsBasics.getAllLocalReuseLibraries();
        if (libraries == null || libraries.isEmpty()) {
            this.root.libraries = Collections.emptyList();
            this.safelyUpdateViewer();
            this.topLabel.setText("No library was found in the local folder.");
            return false;
        }
        this.root.libraries = libraries;
        return true;
    }

    public void updateReuseLibraryView() {
        boolean librariesFound = this.updateRootContainer();
        if (librariesFound) {
            this.updateLibraryTreeTable();
        }
    }

    public void onRefreshButtonSubmit() {
        this.updateReuseLibraryView();
    }

    protected final class LibraryContainer
    extends BasicEObjectImpl {
        List<ReuseLibrary> libraries = new ArrayList<ReuseLibrary>();

        protected LibraryContainer() {
        }
    }
}

