/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.ui.view.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.ui.view.fx.ReuseLibraryFXController;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsManipulation;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

final class ReuseLibraryFXTreeTableUIProvider
extends DynamicTreeTableUIProviderBase<EObject> {
    private final ReuseLibraryFXController viewController;
    private List<String> blockedNames;

    ReuseLibraryFXTreeTableUIProvider(ReuseLibraryFXController reuseLibraryViewFXController) {
        this.viewController = reuseLibraryViewFXController;
        this.blockedNames = new ArrayList<String>();
    }

    public String getLabel(EObject element, int column) {
        switch (column) {
            case 0: {
                if (element instanceof ReuseLibrary) {
                    return ReuseLibraryUtilsBasics.getReuseElementName((EObject)element);
                }
                return "";
            }
            case 1: {
                if (element instanceof ReuseLibrary) {
                    return "";
                }
                return ReuseLibraryUtilsBasics.getReuseElementName((EObject)element);
            }
            case 2: {
                return ReuseLibraryUtilsBasics.getFirstReuseElementUUID((EObject)element);
            }
            case 3: {
                boolean stringIsForDisplay = true;
                return ReuseLibraryUtilsBasics.getReuseElementLastUpdateString((EObject)element, (boolean)stringIsForDisplay);
            }
            case 4: {
                return ReuseLibraryUtilsBasics.getReuseElementComment((EObject)element);
            }
        }
        return "X";
    }

    public Node getIconNode(EObject element, int column) {
        if (this.isElementMatchedWithItsColumn(element, column)) {
            return IModelElementHandlerService.getInstance().getFXIcon(element);
        }
        return null;
    }

    public boolean isEditable(int column) {
        return column == 4;
    }

    public void updateValue(EObject element, int column, Object value) {
        if (column == 4 && value instanceof String) {
            ReuseLibraryUtilsManipulation.updateReuseElementFileWithComment((EObject)element, (String)((String)value));
            this.viewController.updateReuseLibraryView();
        }
    }

    public ContextMenu createContextMenu(EObject element, int column) {
        if (this.isElementMatchedWithItsColumn(element, column)) {
            ContextMenu contextMenu = new ContextMenu();
            contextMenu.getItems().add((Object)this.createDeleteMenuForReuse(element));
            contextMenu.getItems().add((Object)this.createRenameMenuForReuse(element));
            return contextMenu;
        }
        return null;
    }

    private MenuItem createDeleteMenuForReuse(EObject target) {
        MenuItem deleteMenuItem = null;
        if (target instanceof ReuseLibrary) {
            deleteMenuItem = new MenuItem("Delete Library");
            ReuseLibrary targetLibrary = (ReuseLibrary)target;
            deleteMenuItem.setOnAction(event -> {
                String dialogTitle = "Confirm Deleting A Reuse Library";
                String confirmationMessage = "Do you want to completely delete the following reuse library?\n\nDelete: " + ReuseLibraryUtilsBasics.getLibraryIDName((ReuseLibrary)targetLibrary);
                boolean confirmed = MessageUtils.confirm((String)dialogTitle, (String)confirmationMessage);
                if (confirmed) {
                    ReuseLibraryUtilsManipulation.deleteReuseLibrary((ReuseLibrary)targetLibrary);
                    this.viewController.updateReuseLibraryView();
                }
            });
        } else {
            deleteMenuItem = new MenuItem("Delete Reuse Element");
            deleteMenuItem.setOnAction(event -> {
                ReuseLibrary sourceLibrary = ReuseLibraryUtilsBasics.getFirstSourceLibraryOfElement((EObject)target);
                String dialogTitle = "Confirm Deleting A Reuse Element";
                String confirmationMessage = "Do you want to completely delete the following reuse element?\n\nDelete: " + ReuseLibraryUtilsBasics.getReuseElementName((EObject)target) + "\nFrom library: " + ReuseLibraryUtilsBasics.getLibraryIDName((ReuseLibrary)sourceLibrary);
                boolean confirmed = MessageUtils.confirm((String)dialogTitle, (String)confirmationMessage);
                if (confirmed) {
                    ReuseLibraryUtilsManipulation.deleteReuseElementInLibraryFile((EObject)target);
                    this.viewController.updateReuseLibraryView();
                }
            });
        }
        return deleteMenuItem;
    }

    private MenuItem createRenameMenuForReuse(EObject target) {
        MenuItem renameMenuItem = null;
        String type = "";
        ArrayList<String> blockedNamesTmp = new ArrayList<String>();
        if (target instanceof ReuseLibrary) {
            type = "Library";
            for (ReuseLibrary library : ReuseLibraryUtilsBasics.getAllLocalReuseLibraries()) {
                blockedNamesTmp.add(ReuseLibraryUtilsBasics.getReuseElementName((EObject)library));
            }
        } else {
            type = "Reuse Element";
            ReuseLibrary targetLibrary = ReuseLibraryUtilsBasics.getFirstSourceLibraryOfElement((EObject)target);
            for (EObject libraryElement : targetLibrary.getReuseElementList()) {
                blockedNamesTmp.add(ReuseLibraryUtilsBasics.getReuseElementName((EObject)libraryElement));
            }
        }
        String actionName = "Rename " + type;
        String requestText = "Please enter a new name for the selected " + type.toLowerCase();
        String defaultName = ReuseLibraryUtilsBasics.getReuseElementName((EObject)target);
        renameMenuItem = new MenuItem(actionName);
        renameMenuItem.setOnAction(event -> {
            String newName = this.requestName(actionName, requestText, defaultName, blockedNamesTmp);
            if (newName != null) {
                ReuseLibraryUtilsManipulation.updateReuseElementFileWithName((EObject)target, (String)newName);
                this.viewController.updateReuseLibraryView();
            }
        });
        return renameMenuItem;
    }

    private String requestName(String shellTitle, String requestText, String defaultName, List<String> blockedNamesTmp) {
        this.blockedNames.clear();
        this.blockedNames = blockedNamesTmp;
        InputDialog creationDialog = new InputDialog(Display.getCurrent().getActiveShell(), shellTitle, requestText + "\n ", defaultName, (IInputValidator)new NewNameValidator());
        if (creationDialog.open() != 0) {
            return null;
        }
        return creationDialog.getValue();
    }

    private boolean isElementMatchedWithItsColumn(EObject element, int column) {
        return element != null && (column == 0 && element instanceof ReuseLibrary || column == 1 && !(element instanceof ReuseLibrary));
    }

    private class NewNameValidator
    implements IInputValidator {
        private NewNameValidator() {
        }

        public String isValid(String newText) {
            if (newText.equals("")) {
                return "A name needs to be specified.";
            }
            for (String name : ReuseLibraryFXTreeTableUIProvider.this.blockedNames) {
                if (!newText.equals(name)) continue;
                return "This name already exists. Please use another.";
            }
            return null;
        }
    }
}

