/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.quality;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.ext.quality.data.MetricKey;
import org.fortiss.tooling.ext.quality.data.MetricTreeNode;
import org.fortiss.tooling.ext.quality.service.IMetricProvider;
import org.fortiss.tooling.ext.quality.service.IModelQualityService;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class HierarchicElementMetricProvider
implements IMetricProvider<IHierarchicElement> {
    @Override
    public void collectMetrics(MetricTreeNode node, IHierarchicElement currentElement) {
        IModelQualityService mqs = IModelQualityService.getInstance();
        MetricKey NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS = mqs.getMetricKey("NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS");
        MetricKey NUMBER_OF_TOTAL_COMMENTED_ELEMENTS = mqs.getMetricKey("NUMBER_OF_TOTAL_COMMENTED_ELEMENTS");
        MetricKey UNIQUE_ID = mqs.getMetricKey("UNIQUE_ID");
        Map<MetricKey, Integer> intMetrics = node.getIntegerMetrics();
        if (node.getName() == null) {
            if (currentElement instanceof INamedCommentedElement) {
                intMetrics.put(NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS, 1);
                INamedCommentedElement nce = (INamedCommentedElement)currentElement;
                String comment = nce.getComment();
                if (comment != null && comment != "") {
                    intMetrics.put(NUMBER_OF_TOTAL_COMMENTED_ELEMENTS, 1);
                }
                node.setName(nce.getName());
            } else {
                intMetrics.put(NUMBER_OF_TOTAL_COMMENTABLE_ELEMENTS, 0);
                intMetrics.put(NUMBER_OF_TOTAL_COMMENTED_ELEMENTS, 0);
                node.setName("No name existent");
            }
            if (currentElement instanceof IIdLabeled) {
                intMetrics.put(UNIQUE_ID, ((IIdLabeled)currentElement).getId());
            } else {
                intMetrics.put(UNIQUE_ID, -1);
            }
        }
        MetricKey NUMBER_OF_CONNECTORS = mqs.getMetricKey("NUMBER_OF_CONNECTORS");
        MetricKey NUMBER_OF_CONTAINED_ELEMENTS = mqs.getMetricKey("NUMBER_OF_CONTAINED_ELEMENTS");
        MetricKey NUMBER_OF_CONNECTIONS = mqs.getMetricKey("NUMBER_OF_CONNECTIONS");
        MetricKey NUMBER_OF_TOTAL_CONNECTORS = mqs.getMetricKey("NUMBER_OF_TOTAL_CONNECTORS");
        MetricKey NUMBER_OF_TOTAL_ENTRY_CONNECTORS = mqs.getMetricKey("NUMBER_OF_TOTAL_ENTRY_CONNECTORS");
        MetricKey NUMBER_OF_TOTAL_EXIT_CONNECTORS = mqs.getMetricKey("NUMBER_OF_TOTAL_EXIT_CONNECTORS");
        MetricKey NUMBER_OF_TOTAL_ELEMENTS = mqs.getMetricKey("NUMBER_OF_TOTAL_ELEMENTS");
        MetricKey NUMBER_OF_TOTAL_LEAF_ELEMENTS = mqs.getMetricKey("NUMBER_OF_TOTAL_LEAF_ELEMENTS");
        EList connectors = currentElement.getConnectors();
        intMetrics.put(NUMBER_OF_CONNECTORS, connectors.size());
        intMetrics.put(NUMBER_OF_CONTAINED_ELEMENTS, currentElement.getContainedElements().size());
        intMetrics.put(NUMBER_OF_CONNECTIONS, currentElement.getConnections().size());
        intMetrics.put(NUMBER_OF_TOTAL_CONNECTORS, connectors.size());
        EList entry_connectors = EcoreUtils.pickInstanceOf(EntryConnectorBase.class, (List)connectors);
        EList exit_connectors = EcoreUtils.pickInstanceOf(ExitConnectorBase.class, (List)connectors);
        intMetrics.put(NUMBER_OF_TOTAL_ENTRY_CONNECTORS, entry_connectors.size());
        intMetrics.put(NUMBER_OF_TOTAL_EXIT_CONNECTORS, exit_connectors.size());
        intMetrics.put(NUMBER_OF_TOTAL_ELEMENTS, 1);
        if (currentElement.getContainedElements().isEmpty()) {
            intMetrics.put(NUMBER_OF_TOTAL_LEAF_ELEMENTS, 0);
        } else {
            intMetrics.put(NUMBER_OF_TOTAL_LEAF_ELEMENTS, 1);
        }
    }
}

