/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.quality.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.fortiss.tooling.ext.quality.data.MetricKey;

public class MetricTreeNode {
    private List<MetricTreeNode> children = new ArrayList<MetricTreeNode>();
    private Map<MetricKey, Integer> integerMetrics = new HashMap<MetricKey, Integer>();
    private Map<MetricKey, Double> doubleMetrics = new HashMap<MetricKey, Double>();
    private Map<MetricKey, String> stringMetrics = new HashMap<MetricKey, String>();
    private String name;

    public List<MetricTreeNode> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<MetricKey, Integer> getIntegerMetrics() {
        return this.integerMetrics;
    }

    public Map<MetricKey, Double> getDoubleMetrics() {
        return this.doubleMetrics;
    }

    public Map<MetricKey, String> getStringMetrics() {
        return this.stringMetrics;
    }

    public Double getValueAsDouble(MetricKey key) {
        if (key.isDoubleValue()) {
            return this.doubleMetrics.get(key);
        }
        Integer val = this.integerMetrics.get(key);
        return val == null ? null : Double.valueOf(val.doubleValue());
    }

    public void traverseTree(Consumer<MetricTreeNode> consumer) {
        for (MetricTreeNode child : this.getChildren()) {
            child.traverseTree(consumer);
        }
        consumer.accept(this);
    }
}

