/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.quality.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.ext.quality.data.DataRootElement;
import org.fortiss.tooling.ext.quality.data.MetricData;
import org.fortiss.tooling.ext.quality.data.MetricKey;
import org.fortiss.tooling.ext.quality.data.MetricTreeNode;
import org.fortiss.tooling.ext.quality.service.IMetricProvider;
import org.fortiss.tooling.ext.quality.service.IModelQualityService;
import org.fortiss.tooling.ext.quality.storage.CSVFileWriter;
import org.fortiss.tooling.ext.quality.utils.GraphMetricsUtils;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.internal.ConstraintCheckerService;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.base.EObjectAwareServiceBase;
import org.fortiss.tooling.kernel.service.base.IObjectAware;
import org.fortiss.tooling.kernel.service.listener.IPersistencyServiceListener;
import org.fortiss.tooling.kernel.utils.EcoreSerializerBase;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.ResourceUtils;
import org.junit.Assert;

class ModelQualityService
extends EObjectAwareServiceBase<IMetricProvider<EObject>>
implements IModelQualityService,
IIntrospectiveKernelService,
IPersistencyServiceListener {
    private static final ModelQualityService INSTANCE = new ModelQualityService();
    private String modelQualityDirectory;
    private String modelProjectDirectory;
    private EcoreSerializerBase<? extends EObject> modelQualitySerializer;
    private Map<String, MetricKey> metricKeys = new TreeMap<String, MetricKey>();
    private MetricData metricDataContainer = new MetricData();
    private Job metricCollectorJob;

    ModelQualityService() {
    }

    static ModelQualityService getInstance() {
        return INSTANCE;
    }

    protected String getExtensionPointName() {
        return null;
    }

    protected String getConfigurationElementName() {
        return null;
    }

    protected String getHandlerClassAttribute() {
        return null;
    }

    @Override
    public synchronized void initService(String modelProjectDirectory, String modelQualityDirectory, EcoreSerializerBase<? extends EObject> modelQualitySerializer) {
        this.modelProjectDirectory = modelProjectDirectory;
        this.modelQualityDirectory = modelQualityDirectory;
        this.modelQualitySerializer = modelQualitySerializer;
    }

    @Override
    public synchronized void startService() {
        if (this.modelQualityDirectory == null) {
            System.err.println("[MQS]: Failed to start: Model quality directory has not been set.");
            return;
        }
        if (this.modelProjectDirectory == null) {
            System.err.println("[MQS]: Failed to start: Model project directory has not been set.");
            return;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public synchronized boolean isAvailable() {
        if (this.modelQualityDirectory == null || this.modelProjectDirectory == null) {
            return false;
        }
        if (this.metricCollectorJob != null) {
            return false;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            boolean bl;
            Git git;
            Repository repo;
            block18: {
                block17: {
                    repo = this.getGitRepository();
                    git = repo != null ? new Git(repo) : null;
                    bl = git != null;
                    if (git == null) break block17;
                    git.close();
                }
                if (repo == null) break block18;
                repo.close();
            }
            return bl;
            {
                catch (Throwable throwable2) {
                    try {
                        if (git != null) {
                            git.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (repo != null) {
                            repo.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private Repository getGitRepository() {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        IResource modelProjectDir = ws.findMember(this.modelProjectDirectory);
        if (modelProjectDir == null) {
            System.err.println("[MQS] Failed to configure Git repository: \"" + this.modelProjectDirectory + "\" not found in workspace.");
            return null;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)modelProjectDir);
        if (mapping == null) {
            System.err.println("[MQS] Failed to configure Git repository: could not determine repository mapping for \"" + this.modelProjectDirectory + "\".");
            return null;
        }
        Repository repo = mapping.getRepository();
        if (repo == null) {
            System.err.println("[MQS] Failed to configure Git repository: Could not be retrieved from mapping.");
        }
        return repo;
    }

    @Override
    public <T extends EObject> void registerMetricProvider(IMetricProvider<T> provider, Class<T> modelElementClass) {
        this.addHandler(modelElementClass, (IObjectAware)provider);
    }

    @Override
    public MetricKey registerMetricKey(String keyName, MetricKey.MetricKeyType keyType, boolean isAggregator) {
        MetricKey metricKey = new MetricKey(keyName, keyType, isAggregator);
        if (this.metricKeys.containsKey(keyName)) {
            throw new RuntimeException("A metric key with name \"" + keyName + "\" has already been registered.");
        }
        this.metricKeys.put(keyName, metricKey);
        return metricKey;
    }

    @Override
    public synchronized boolean scheduleGitMetricExtraction(EObject model, Path metricDatabaseFilePath) {
        if (!this.isAvailable() || this.metricCollectorJob != null) {
            return false;
        }
        this.metricCollectorJob = new MetricCollectorJob(model, metricDatabaseFilePath);
        this.metricCollectorJob.schedule();
        this.metricCollectorJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ModelQualityService.this.metricCollectorJob = null;
            }
        });
        return true;
    }

    @Override
    public File getModelQualityDirectory() {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        return new File(String.valueOf(ws.getLocation()) + File.separator + this.modelQualityDirectory);
    }

    @Override
    public File getModelProjectDirectory() {
        IWorkspaceRoot ws = ResourcesPlugin.getWorkspace().getRoot();
        return new File(String.valueOf(ws.getLocation()) + File.separator + this.modelProjectDirectory);
    }

    @Override
    public MetricData getMetricData() {
        return this.metricDataContainer;
    }

    @Override
    public MetricKey getMetricKey(String keyName) {
        MetricKey metricKey = this.metricKeys.get(keyName);
        if (metricKey == null) {
            throw new RuntimeException("A metric key with name \"" + keyName + "\" has not been registered.");
        }
        return metricKey;
    }

    @Override
    public Collection<MetricKey> getMetricKeys() {
        return Collections.unmodifiableCollection(this.metricKeys.values());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateModelVersion(String mode) {
        var2_2 = mode;
        tmp = -1;
        switch (var2_2.hashCode()) {
            case -1273775369: {
                if (var2_2.equals("previous")) {
                    tmp = 1;
                }
                break;
            }
            case 3377907: {
                if (!var2_2.equals("next")) break;
                tmp = 1;
                break;
            }
        }
        ** switch (tmp)
lbl16:
        // 2 sources

    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gitHistoryMetricExtraction(EObject model, Path metricsDataBaseFilePath) {
        Path modelProjectPath = ResourceUtils.getModelProjectPath((EObject)model);
        String relativePathString = this.getGitRelativePath(model);
        String modelFileName = ResourceUtils.getModelFileName((EObject)model);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                Repository repo = this.getGitRepository();
                try {
                    try (Git git = new Git(repo);){
                        Assert.assertNotNull((Object)git);
                        String originalBranch = git.getRepository().getBranch();
                        int counter = 0;
                        LogCommand log = git.log().all();
                        Iterable commits = log.addPath(relativePathString).call();
                        for (RevCommit commit : commits) {
                            System.out.println("Extracting Data for Commit " + ++counter + ": " + commit.getFullMessage());
                            git.checkout().setName(commit.getName()).call();
                            EObject currentModel = this.modelQualitySerializer.load(modelProjectPath.toString());
                            this.performMetricCollection(currentModel, commit, modelFileName, metricsDataBaseFilePath);
                            git.reset().setMode(ResetCommand.ResetType.HARD).call();
                        }
                        git.checkout().setName(originalBranch).call();
                    }
                    if (repo == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (repo == null) throw throwable;
                    repo.close();
                    throw throwable;
                }
                repo.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getGitRelativePath(EObject model) {
        String workTreePathString;
        Path modelProjectPath;
        block13: {
            modelProjectPath = ResourceUtils.getModelProjectPath((EObject)model);
            Throwable throwable = null;
            Object var5_5 = null;
            try {
                Repository repo = this.getGitRepository();
                try {
                    try (Git git = new Git(repo);){
                        Assert.assertNotNull((Object)git);
                        workTreePathString = git.getRepository().getWorkTree().getPath();
                    }
                    if (repo == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (repo == null) throw throwable;
                    repo.close();
                    throw throwable;
                }
                repo.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        Path relativePath = Paths.get(workTreePathString, new String[0]).relativize(modelProjectPath);
        return relativePath.toString().replace("\\", "/");
    }

    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service allows to track the evolution of model metrics.\n The service determines the current metrics of a model and stores\n them in a CSV file for later analysis of the modeling history.\n\nThe service extension point is 'not existent'.";
    }

    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }

    public boolean showInIntrospectionNavigation() {
        return true;
    }

    public String getIntrospectionLabel() {
        return "Quality Service";
    }

    public List<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    public void topLevelElementLoaded(ITopLevelElement element) {
    }

    public void topLevelElementAdded(ITopLevelElement element) {
    }

    public void topLevelElementRemoved(ITopLevelElement element) {
    }

    public void topLevelElementContentChanged(ITopLevelElement element) {
    }

    private void performMetricCollection(EObject topLevelElement, RevCommit commit, String fileProjectFileName, Path metricFilePath) throws NoSuchAlgorithmException, IOException, CoreException {
        ArrayList rootElements = new ArrayList(KernelModelElementUtils.getRootElements((EObject)topLevelElement, IProjectRootElement.class));
        String allocationTableClassName = "org.fortiss.af3.allocation.model.impl.AllocationTableCollectionImpl";
        Collections.sort(rootElements, (r1, r2) -> {
            if (allocationTableClassName.equals(r1.getClass().getName())) {
                return 1;
            }
            if (allocationTableClassName.equals(r2.getClass().getName())) {
                return -1;
            }
            return 0;
        });
        int timestamp = commit.getCommitTime();
        HashMap<IProjectRootElement, DataRootElement> updatedElements = new HashMap<IProjectRootElement, DataRootElement>();
        for (IProjectRootElement rootElement : rootElements) {
            MetricTreeNode rootNode = new MetricTreeNode();
            if (rootElement instanceof IHierarchicElement) {
                IHierarchicElement firstElement = (IHierarchicElement)rootElement;
                this.recursivlyCollectMetrics(rootNode, firstElement, 0);
            } else {
                this.collectMetrics(rootNode, (EObject)rootElement);
            }
            List contraintViolations = ConstraintCheckerService.getInstance().performAllConstraintChecksRecursively((EObject)rootElement);
            MetricKey CONSTRAINT_VIOLATIONS_ERROR = this.getMetricKey("CONSTRAINT_VIOLATIONS_ERROR");
            MetricKey CONSTRAINT_VIOLATIONS_WARNING = this.getMetricKey("CONSTRAINT_VIOLATIONS_WARNING");
            for (Map.Entry<EObject, List<IConstraintViolation>> entry : contraintViolations.stream().collect(Collectors.groupingBy(IConstraintViolation::getSource)).entrySet()) {
                MetricTreeNode node = this.metricDataContainer.getTreeNodeLookupTable().get(entry.getKey());
                if (node == null) continue;
                List<IConstraintViolation> violations = entry.getValue();
                Map<MetricKey, Integer> integers = node.getIntegerMetrics();
                integers.put(CONSTRAINT_VIOLATIONS_ERROR, (int)violations.stream().filter(v -> v.getSeverity() == IConstraintViolation.ESeverity.ERROR).count());
                integers.put(CONSTRAINT_VIOLATIONS_WARNING, (int)violations.stream().filter(v -> v.getSeverity() == IConstraintViolation.ESeverity.WARNING).count());
            }
            DataRootElement dataRootElement = new DataRootElement(timestamp, topLevelElement, rootNode);
            this.metricDataContainer.getDataRootElementMap().put(rootElement, dataRootElement);
            updatedElements.put(rootElement, dataRootElement);
            this.metricDataContainer.getTreeNodeLookupTable().put((EObject)rootElement, rootNode);
        }
        CSVFileWriter.metricExtractionToCSV(updatedElements, fileProjectFileName, metricFilePath, commit);
    }

    private void recursivlyCollectMetrics(MetricTreeNode node, IHierarchicElement currentElement, int recursionLevel) {
        MetricKey NESTING_LEVEL = this.getMetricKey("NESTING_LEVEL");
        this.collectMetrics(node, (EObject)currentElement);
        node.getIntegerMetrics().put(NESTING_LEVEL, recursionLevel);
        Optional<IHierarchicElement> hierarchicElementOptional = currentElement.getSpecifications().stream().filter(s -> s instanceof IHierarchicElement).map(s -> (IHierarchicElement)s).findAny();
        if (hierarchicElementOptional.isPresent()) {
            IHierarchicElement specificationElement = hierarchicElementOptional.get();
            EList containedElements = specificationElement.getContainedElements();
            if (containedElements.size() == 1) {
                this.metricDataContainer.getTreeNodeLookupTable().put((EObject)specificationElement, node);
                this.recursivlyCollectMetrics(node, (IHierarchicElement)containedElements.get(0), recursionLevel);
            } else {
                this.recursivlyCollectMetrics(node, specificationElement, recursionLevel);
            }
            this.metricDataContainer.getTreeNodeLookupTable().put((EObject)currentElement, node);
        } else {
            Map<MetricKey, Double> nodeDoubles = node.getDoubleMetrics();
            Map<MetricKey, Integer> nodeIntegers = node.getIntegerMetrics();
            for (IHierarchicElement containedElement : currentElement.getContainedElements()) {
                MetricTreeNode child = new MetricTreeNode();
                node.getChildren().add(child);
                this.recursivlyCollectMetrics(child, containedElement, recursionLevel + 1);
                for (MetricKey metricKey : this.metricKeys.values()) {
                    if (!metricKey.isAggregatorKey()) continue;
                    Map<MetricKey, Double> childDoubles = child.getDoubleMetrics();
                    Map<MetricKey, Integer> childIntegers = child.getIntegerMetrics();
                    if (childDoubles.containsKey(metricKey)) {
                        nodeDoubles.merge(metricKey, childDoubles.get(metricKey), Double::sum);
                    }
                    if (!childIntegers.containsKey(metricKey)) continue;
                    nodeIntegers.merge(metricKey, childIntegers.get(metricKey), Integer::sum);
                }
            }
            this.metricDataContainer.getTreeNodeLookupTable().put((EObject)currentElement, node);
            Map<IHierarchicElement, Double> nonRecursiveBetweeness = GraphMetricsUtils.calculateBetweennessCentrality(currentElement, false);
            Map<IHierarchicElement, Double> recursiveBetweeness = GraphMetricsUtils.calculateBetweennessCentrality(currentElement, true);
            MetricKey BETWEENESS_CENTRALITY = this.getMetricKey("BETWEENESS_CENTRALITY");
            MetricKey BETWEENESS_CENTRALITY_RECURSIVELY = this.getMetricKey("BETWEENESS_CENTRALITY_RECURSIVELY");
            MetricKey CLUSTERING_COEFFICIENT = this.getMetricKey("CLUSTERING_COEFFICIENT");
            ModelQualityService.saveMetric(currentElement, this.metricDataContainer, BETWEENESS_CENTRALITY, nonRecursiveBetweeness);
            ModelQualityService.saveMetric(currentElement, this.metricDataContainer, BETWEENESS_CENTRALITY_RECURSIVELY, recursiveBetweeness);
            node.getDoubleMetrics().put(CLUSTERING_COEFFICIENT, GraphMetricsUtils.calculateClusteringCoefficent(currentElement));
        }
    }

    private static void saveMetric(IHierarchicElement scopeElement, MetricData metricData, MetricKey key, Map<IHierarchicElement, Double> betweenness) {
        for (IHierarchicElement child : scopeElement.getContainedElements()) {
            MetricTreeNode node = metricData.getTreeNodeLookupTable().get(child);
            node.getDoubleMetrics().put(key, betweenness.get(child));
        }
    }

    private void collectMetrics(MetricTreeNode node, EObject object) {
        List<IMetricProvider<EObject>> providers = this.getAllMetricProviders(object);
        for (IMetricProvider<EObject> provider : providers) {
            provider.collectMetrics(node, object);
        }
    }

    private List<IMetricProvider<EObject>> getAllMetricProviders(EObject input) {
        ArrayList<IMetricProvider<EObject>> providers = new ArrayList<IMetricProvider<EObject>>();
        for (Map.Entry migEntry : this.handlerMap.entrySet()) {
            if (!((Class)migEntry.getKey()).isAssignableFrom(input.getClass())) continue;
            providers.addAll((Collection)migEntry.getValue());
        }
        return providers;
    }

    private final class MetricCollectorJob
    extends Job {
        private EObject model;
        private Path metricsDataBaseFilePath;

        public MetricCollectorJob(EObject model, Path metricsDataBaseFilePath) {
            super("Collecting metrics...");
            this.model = model;
            this.metricsDataBaseFilePath = metricsDataBaseFilePath;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ModelQualityService.this.gitHistoryMetricExtraction(this.model, this.metricsDataBaseFilePath);
            return Status.OK_STATUS;
        }
    }
}

