/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.quality.storage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.revwalk.RevCommit;
import org.fortiss.tooling.ext.quality.data.DataRootElement;
import org.fortiss.tooling.ext.quality.data.MetricKey;
import org.fortiss.tooling.ext.quality.data.MetricTreeNode;
import org.fortiss.tooling.ext.quality.service.IModelQualityService;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class CSVFileWriter {
    public static void metricExtractionToCSV(Map<IProjectRootElement, DataRootElement> metricMap, String modelFileName, Path metricFilePath, RevCommit commit) throws NoSuchAlgorithmException, IOException {
        if (metricMap == null || metricMap.isEmpty()) {
            return;
        }
        IModelQualityService mqs = IModelQualityService.getInstance();
        File modelQualityDirectory = mqs.getModelQualityDirectory();
        modelQualityDirectory.mkdir();
        String projectHash = commit.getName();
        List<String> allKeys = new ArrayList<String>();
        boolean createNewIndex = true;
        if (Files.exists(metricFilePath, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(metricFilePath.toFile()));){
                    String line = reader.readLine();
                    if (line != null) {
                        allKeys = Arrays.asList(line.split(","));
                        createNewIndex = false;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        CSVFileWriter.writeMetricsToFile(metricMap, allKeys, metricFilePath, createNewIndex, modelFileName, projectHash);
    }

    private static void writeMetricsToFile(Map<IProjectRootElement, DataRootElement> metricMap, List<String> allKeys, Path metricFilePath, boolean createNewIndex, String modelFileName, String commitHash) {
        IModelQualityService mqs = IModelQualityService.getInstance();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(metricFilePath.toFile(), true));){
                if (createNewIndex) {
                    allKeys.add("nv_timestamp");
                    allKeys.add("nv_project_name");
                    allKeys.add("nv_commit_hash");
                    allKeys.add("nv_root_element_name");
                    allKeys.add("nv_name");
                    allKeys.add("nv_children");
                    allKeys.addAll(mqs.getMetricKeys().stream().map(k -> k.getKeyName()).map(String::toLowerCase).collect(Collectors.toList()));
                    writer.write(String.join((CharSequence)",", allKeys));
                    writer.write("\n");
                }
                List<String> valueKeys = allKeys.subList(6, allKeys.size());
                MetricKey UNIQUE_ID = mqs.getMetricKey("UNIQUE_ID");
                metricMap.forEach((rootElement, dataRootElement) -> {
                    String rootName = rootElement.getClass().getSimpleName();
                    MetricTreeNode rootNode = dataRootElement.getRootNode();
                    int commitTime = dataRootElement.getCommitTime();
                    Instant instant = Instant.ofEpochSecond(commitTime);
                    LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                    rootNode.traverseTree(node -> {
                        Map<MetricKey, Integer> integers = node.getIntegerMetrics();
                        Map<MetricKey, Double> doubles = node.getDoubleMetrics();
                        Map<MetricKey, String> strings = node.getStringMetrics();
                        String children_ids = node.getChildren().stream().map(n -> n.getIntegerMetrics().get(UNIQUE_ID)).map(id -> id.toString()).reduce((a, b) -> a + " " + b).orElse("");
                        Stream<String> startStream = Stream.of(dateTime.toString(), modelFileName, commitHash, rootName, node.getName(), children_ids);
                        String values = Stream.concat(startStream, valueKeys.stream().map(String::toUpperCase).map(keyName -> {
                            MetricKey key = mqs.getMetricKey((String)keyName);
                            if (key.isStringValue()) {
                                return (Serializable)strings.get(key);
                            }
                            if (key.isDoubleValue()) {
                                return (Serializable)doubles.get(key);
                            }
                            return (Serializable)integers.get(key);
                        }).map(String::valueOf)).collect(Collectors.joining(","));
                        try {
                            writer.write(values);
                            writer.write("\n");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

