/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.quality.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class GraphMetricsUtils {
    private static Set<IHierarchicElement> getLocalGraphView(IHierarchicElement scopeElement, boolean recursively) {
        HashSet<IHierarchicElement> graphNodes = new HashSet<IHierarchicElement>();
        if (recursively) {
            GraphMetricsUtils.recursivelyGetLeafElements(scopeElement, graphNodes);
        } else {
            graphNodes.addAll((Collection<IHierarchicElement>)scopeElement.getContainedElements());
        }
        for (ExitConnectorBase exitConnector : EcoreUtils.pickInstanceOf(ExitConnectorBase.class, (List)scopeElement.getConnectors())) {
            for (IConnection exitConnection : exitConnector.getOutgoing()) {
                graphNodes.add(exitConnection.getTarget().getOwner());
            }
        }
        for (EntryConnectorBase entryConnector : EcoreUtils.pickInstanceOf(EntryConnectorBase.class, (List)scopeElement.getConnectors())) {
            for (IConnection entryConnection : entryConnector.getIncoming()) {
                graphNodes.add(entryConnection.getSource().getOwner());
            }
        }
        return graphNodes;
    }

    private static void recursivelyGetLeafElements(IHierarchicElement element, Set<IHierarchicElement> allElements) {
        allElements.add(element);
        for (IHierarchicElement containedElement : element.getContainedElements()) {
            GraphMetricsUtils.recursivelyGetLeafElements(containedElement, allElements);
        }
    }

    private static void recursivlyFollowOutgoingConnection(IConnector connector, Set<IHierarchicElement> allElements) {
        EList outgoingConnections = connector.getOutgoing();
        if (outgoingConnections.isEmpty()) {
            allElements.add(connector.getOwner());
            return;
        }
        for (IConnection outgoingConnection : outgoingConnections) {
            GraphMetricsUtils.recursivlyFollowOutgoingConnection(outgoingConnection.getTarget(), allElements);
        }
    }

    private static void recursivlyFollowIncomingConnection(IConnector connector, Set<IHierarchicElement> allElements) {
        EList incomingConnections = connector.getIncoming();
        if (incomingConnections.isEmpty()) {
            allElements.add(connector.getOwner());
            return;
        }
        for (IConnection incomingConnection : incomingConnections) {
            GraphMetricsUtils.recursivlyFollowIncomingConnection(incomingConnection.getSource(), allElements);
        }
    }

    private static Set<IHierarchicElement> getUndirectedNeighbors(IHierarchicElement element) {
        HashSet<IHierarchicElement> neighbors = new HashSet<IHierarchicElement>();
        for (ExitConnectorBase exitConnectors : EcoreUtils.pickInstanceOf(ExitConnectorBase.class, (List)element.getConnectors())) {
            GraphMetricsUtils.recursivlyFollowOutgoingConnection((IConnector)exitConnectors, neighbors);
        }
        for (EntryConnectorBase entryConnectors : EcoreUtils.pickInstanceOf(EntryConnectorBase.class, (List)element.getConnectors())) {
            GraphMetricsUtils.recursivlyFollowIncomingConnection((IConnector)entryConnectors, neighbors);
        }
        return neighbors;
    }

    public static double calculateClusteringCoefficent(IHierarchicElement element) {
        Set<IHierarchicElement> neighbors = GraphMetricsUtils.getUndirectedNeighbors(element);
        int totalEdges = neighbors.size();
        if (totalEdges < 2) {
            return 0.0;
        }
        int triangles = 0;
        for (IHierarchicElement neighbor : neighbors) {
            Set<IHierarchicElement> neighborNeighbors = GraphMetricsUtils.getUndirectedNeighbors(neighbor);
            for (IHierarchicElement secondNeighbor : neighbors) {
                if (secondNeighbor == neighbor || !neighborNeighbors.contains(secondNeighbor)) continue;
                ++triangles;
            }
        }
        double clusteringCoefficient = (double)triangles / (double)(totalEdges * (totalEdges - 1));
        return clusteringCoefficient;
    }

    public static Map<IHierarchicElement, Double> calculateBetweennessCentrality(IHierarchicElement scopeElement, boolean recursively) {
        if (scopeElement.getContainedElements().isEmpty()) {
            return null;
        }
        Set<IHierarchicElement> graphNodes = GraphMetricsUtils.getLocalGraphView(scopeElement, recursively);
        HashMap<IHierarchicElement, Double> betweenness = new HashMap<IHierarchicElement, Double>();
        for (IHierarchicElement elementNode : graphNodes) {
            betweenness.put(elementNode, 0.0);
        }
        for (IHierarchicElement elementNode : graphNodes) {
            Stack<IHierarchicElement> stack = new Stack<IHierarchicElement>();
            HashMap<IHierarchicElement, List<IHierarchicElement>> predecessors = new HashMap<IHierarchicElement, List<IHierarchicElement>>();
            HashMap<IHierarchicElement, Integer> distance = new HashMap<IHierarchicElement, Integer>();
            HashMap<IHierarchicElement, Double> dependency = new HashMap<IHierarchicElement, Double>();
            LinkedList<IHierarchicElement> queue = new LinkedList<IHierarchicElement>();
            for (IHierarchicElement v : graphNodes) {
                predecessors.put(v, new ArrayList());
                distance.put(v, -1);
                dependency.put(v, 0.0);
            }
            dependency.put(elementNode, 1.0);
            distance.put(elementNode, 0);
            queue.add(elementNode);
            GraphMetricsUtils.processCentrality(queue, stack, predecessors, distance, dependency, graphNodes, elementNode, recursively);
            HashMap<IHierarchicElement, Double> delta = new HashMap<IHierarchicElement, Double>();
            for (IHierarchicElement v : graphNodes) {
                delta.put(v, 0.0);
            }
            while (!stack.isEmpty()) {
                IHierarchicElement w = stack.pop();
                for (IHierarchicElement v : (List)predecessors.get(w)) {
                    double c = (Double)dependency.get(v) / (Double)dependency.get(w) * (1.0 + (Double)delta.get(w));
                    delta.put(v, (Double)delta.get(v) + c);
                }
                if (w.equals(elementNode)) continue;
                betweenness.put(w, (Double)betweenness.get(w) + (Double)delta.get(w));
            }
        }
        return betweenness;
    }

    private static void processCentrality(Queue<IHierarchicElement> queue, Stack<IHierarchicElement> stack, Map<IHierarchicElement, List<IHierarchicElement>> predecessor, Map<IHierarchicElement, Integer> distance, Map<IHierarchicElement, Double> dependency, Set<IHierarchicElement> graphNodes, IHierarchicElement scopeElement, boolean recursively) {
        while (!queue.isEmpty()) {
            IHierarchicElement v = queue.remove();
            stack.push(v);
            for (ExitConnectorBase exitConnectors : EcoreUtils.pickInstanceOf(ExitConnectorBase.class, (List)v.getConnectors())) {
                for (IConnection outgoingConnection : exitConnectors.getOutgoing()) {
                    HashSet<IHierarchicElement> targetElements = new HashSet<IHierarchicElement>();
                    if (recursively) {
                        GraphMetricsUtils.recursivlyFollowOutgoingConnection(outgoingConnection.getTarget(), targetElements);
                    } else {
                        IHierarchicElement primaryTargetElement = outgoingConnection.getTarget().getOwner();
                        if (scopeElement == primaryTargetElement) {
                            IConnector targetConnector = outgoingConnection.getTarget();
                            for (IConnection secondaryOutgoingConnection : targetConnector.getOutgoing()) {
                                targetElements.add(secondaryOutgoingConnection.getTarget().getOwner());
                            }
                        } else {
                            targetElements.add(primaryTargetElement);
                        }
                    }
                    for (IHierarchicElement targetElement : targetElements) {
                        if (!graphNodes.contains(targetElement)) continue;
                        Integer targetDistance = distance.get(targetElement);
                        Integer vDistance = distance.get(v);
                        if (targetDistance < 0) {
                            queue.add(targetElement);
                            distance.put(targetElement, vDistance + 1);
                            continue;
                        }
                        if (targetDistance != vDistance + 1) continue;
                        dependency.put(targetElement, dependency.get(targetElement) + dependency.get(v));
                        predecessor.get(targetElement).add(v);
                    }
                }
            }
        }
    }
}

