/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.compose;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.utils.StateModelElementFactory;
import org.fortiss.tooling.base.compose.ConnectorConnectionCompositorBase;
import org.fortiss.tooling.base.model.base.ConnectionSegmentBase;
import org.fortiss.tooling.base.model.base.ConnectorBase;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;

public class ConnectorConnectionCompositor
extends ConnectorConnectionCompositorBase<State, ConnectorBase, ConnectorBase> {
    public boolean canConnect(ConnectorBase source, ConnectorBase target, State parent, IConnectionCompositionContext context) {
        boolean freeSource = false;
        boolean freeTarget = false;
        if (source.eContainer() == target.eContainer()) {
            freeSource = this.isSameLevelPortFree(source);
            freeTarget = this.isSameLevelPortFree(target);
        } else if (source.eContainer() == target.eContainer().eContainer()) {
            freeSource = this.isCrossLevelPortFree(source);
            freeTarget = this.isSameLevelPortFree(target);
        } else if (source.eContainer() != target.eContainer().eContainer()) {
            freeSource = this.isSameLevelPortFree(source);
            freeTarget = this.isCrossLevelPortFree(target);
        }
        if (freeSource && freeTarget) {
            return super.canConnect((IConnector)source, (IConnector)target, (IHierarchicElement)parent, context);
        }
        return false;
    }

    private boolean isSameLevelPortFree(ConnectorBase connector) {
        return connector.getOutgoing().isEmpty() && connector.getIncoming().isEmpty();
    }

    private boolean isCrossLevelPortFree(ConnectorBase connector) {
        boolean isFree = connector instanceof EntryConnectorBase ? connector.getOutgoing().isEmpty() : connector.getIncoming().isEmpty();
        return isFree;
    }

    protected ConnectionSegmentBase createConnection() {
        return StateModelElementFactory.createTransitionSegment();
    }

    protected boolean allowManyToOne() {
        return false;
    }

    public boolean canDisconnect(EObject connection) {
        if (connection instanceof IConnection && ((IConnection)connection).getSource() != null) {
            return ((IConnection)connection).getSource().getOwner() instanceof State;
        }
        return false;
    }
}

