/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.compose;

import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.model.TransitionSegmentConnector;
import org.fortiss.af3.state.model.TransitionSegmentEntryConnector;
import org.fortiss.af3.state.model.TransitionSegmentExitConnector;
import org.fortiss.af3.state.utils.StateAutomatonUtils;
import org.fortiss.tooling.base.compose.HierarchicElementCompositorBase;
import org.fortiss.tooling.base.dnd.ElementDropContext;
import org.fortiss.tooling.base.model.base.ConnectorBase;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.EllipseLayoutUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.RectangleLayoutUtils;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;

public class StateCompositor
extends HierarchicElementCompositorBase<State> {
    public boolean canCompose(State container, EObject contained, IElementCompositionContext context) {
        return this.isCorrectElementClass(contained);
    }

    public boolean compose(State container, EObject contained, IElementCompositionContext context) {
        super.compose((EObject)container, contained, context);
        if (contained instanceof State) {
            State state = (State)contained;
            LayoutDataUtils.layoutModelElement((EObject)state, (IElementCompositionContext)context);
            container.getContainedElements().add((Object)state);
            return true;
        }
        if (contained instanceof ConnectorBase) {
            ConnectorBase connector = (ConnectorBase)contained;
            if (context instanceof ElementDropContext) {
                ElementDropContext ctx = (ElementDropContext)context;
                if (ctx.isRoot()) {
                    int size = 12;
                    RectangleLayoutUtils.layoutNodeInRoot((ILayoutedModelElement)connector, (ElementDropContext)ctx, (int)size, (boolean)true);
                } else {
                    Point ctxPosition = ctx.getPosition();
                    if (ctx.isRootFigureCanvas()) {
                        ctxPosition.translate(ctx.getViewLocationZoomed());
                    }
                    EllipseLayoutUtils.layoutConnectorInEllipse((ILayoutedModelElement)connector, (ILayoutedModelElement)container, (Point)ctxPosition);
                }
            }
            StateCompositor.avoidDuplicatePointName((TransitionSegmentConnector)connector, container);
            container.getConnectors().add((Object)connector);
            return true;
        }
        return false;
    }

    public boolean canComposePrototype(Prototype prototype) {
        return this.isCorrectElementClass(prototype.getPrototype());
    }

    private boolean isCorrectElementClass(EObject element) {
        return ReflectionUtils.isInstanceOfAny((Object)element, (Class[])new Class[]{State.class, TransitionSegmentExitConnector.class, TransitionSegmentEntryConnector.class, TransitionSegment.class});
    }

    public boolean canDecompose(EObject contained) {
        return this.isCorrectElementClass(contained);
    }

    static void avoidDuplicatePointName(TransitionSegmentConnector connector, State container) {
        if (connector.getState() == container) {
            return;
        }
        int num = 1;
        String orig = connector.getName();
        while (StateAutomatonUtils.findTransitionConnector(container, connector.getName()) != null) {
            connector.setName(orig + num);
            ++num;
        }
    }
}

