/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.constraint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.state.constraint.ConstraintMessage;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.utils.StateAutomatonUtils;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.ext.variability.util.VariabilityUtils;
import org.fortiss.tooling.kernel.extension.base.ConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class StateAutomatonConstraintChecker
extends ConstraintCheckerBase<StateAutomaton> {
    public boolean isApplicable(StateAutomaton modelElement) {
        return modelElement != null;
    }

    public List<? extends IConstraintViolation<? extends EObject>> apply(StateAutomaton modelElement) {
        ArrayList<IConstraintViolation<? extends EObject>> result = new ArrayList<IConstraintViolation<? extends EObject>>();
        if (!VariabilityUtils.containsVariability((IModelElement)modelElement)) {
            this.doInitialStateCheck(modelElement, result);
        }
        this.doLooseTransitionSegmentCheck(modelElement, result);
        return result;
    }

    private void doLooseTransitionSegmentCheck(StateAutomaton modelElement, List<IConstraintViolation<? extends EObject>> result) {
        TreeIterator iter = modelElement.eAllContents();
        while (iter.hasNext()) {
            EObject n = (EObject)iter.next();
            if (!(n instanceof TransitionSegment)) continue;
            TransitionSegment seg = (TransitionSegment)n;
            if (!seg.getSourceConnector().getState().isAtomic() && seg.getSourceConnector().getIncomingTransitionSegments().isEmpty()) {
                result.add((IConstraintViolation<? extends EObject>)ConstraintMessage.createNonAtomicTransitionSegment(seg, modelElement));
                continue;
            }
            if (seg.getTargetConnector().getState().isAtomic() || !seg.getTargetConnector().getOutgoingTransitionSegments().isEmpty()) continue;
            result.add((IConstraintViolation<? extends EObject>)ConstraintMessage.createNonAtomicTransitionSegment(seg, modelElement));
        }
    }

    private void doInitialStateCheck(StateAutomaton modelElement, List<IConstraintViolation<? extends EObject>> result) {
        State initial = null;
        for (State st : StateAutomatonUtils.getSubStatesRecursively(modelElement.getRootState())) {
            if (!st.getContainedElements().isEmpty()) {
                if (!st.isInitial()) continue;
                result.add((IConstraintViolation<? extends EObject>)ConstraintMessage.createNonAtomicInitialStateViolation(modelElement));
                continue;
            }
            if (!st.isInitial()) continue;
            if (initial == null) {
                initial = st;
                continue;
            }
            if (VariabilityUtils.hasPresenceCondition((EObject)st) && VariabilityUtils.hasPresenceCondition((EObject)initial)) continue;
            result.add((IConstraintViolation<? extends EObject>)ConstraintMessage.createMultipleInitialStatesViolation(modelElement));
        }
        if (initial == null) {
            result.add((IConstraintViolation<? extends EObject>)ConstraintMessage.createMissingInitialStateViolation(modelElement));
        }
    }
}

