/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.constraint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.variability.HasInitialStateConstraint;
import org.fortiss.af3.state.variability.SimplifiedOneInitialStateConstraint;
import org.fortiss.af3.state.variability.StateProductLineAnalysis;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.ext.variability.util.VariabilityUtils;
import org.fortiss.tooling.kernel.extension.base.ConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.base.ConstraintViolationBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.analysis.constraint.IProductLineConstraint;
import org.fortiss.variability.analysis.constraint.ProductLineConstraintViolation;

public class StateProductLineAnalysisChecker
extends ConstraintCheckerBase<StateAutomaton> {
    public boolean isApplicable(StateAutomaton modelElement) {
        return EcoreUtils.getFirstParentWithType((EObject)modelElement, FileProject.class) != null && VariabilityUtils.containsVariability((IModelElement)modelElement);
    }

    public List<? extends IConstraintViolation<? extends EObject>> apply(StateAutomaton fileProject) {
        ArrayList<ConstraintViolationBase> ret = new ArrayList<ConstraintViolationBase>();
        StateProductLineAnalysis analysis = new StateProductLineAnalysis();
        List plConstraintViolations = analysis.doCheck((EObject)fileProject);
        for (ProductLineConstraintViolation plViolation : plConstraintViolations) {
            String msg = plViolation.getErrorMessage();
            for (EObject eo : plViolation.getViolatingElements()) {
                IProductLineConstraint constraint = plViolation.getConstraint();
                if (constraint instanceof HasInitialStateConstraint || constraint instanceof SimplifiedOneInitialStateConstraint) {
                    eo = EcoreUtils.getFirstParentWithType((EObject)eo, Component.class);
                }
                ret.add(new ConstraintViolationBase(eo, IConstraintViolation.ESeverity.ERROR, msg));
            }
        }
        return ret;
    }
}

