/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.generator.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.generator.component.ComponentFunctionIdentifierUtils;
import org.fortiss.af3.component.generator.component.ComponentProgramTransformationBase;
import org.fortiss.af3.component.generator.component.PortVariableUtils;
import org.fortiss.af3.component.generator.component.TermReplacement;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.generator.LocalFunction;
import org.fortiss.af3.component.model.generator.LocalVariable;
import org.fortiss.af3.component.utils.GeneratorModelElementFactory;
import org.fortiss.af3.expression.model.terms.BoolConst;
import org.fortiss.af3.expression.model.terms.ComplexVar;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.utils.VariableScopeUtils;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.model.TransitionSegmentConnector;
import org.fortiss.af3.state.model.TransitionSegmentSpecification;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.IdentifierUtils;

public class StateAutomatonTransformation
extends ComponentProgramTransformationBase {
    public static final String STATE_FIRE_FUNCTION_NAME_PREFIX = "fire_state_";
    public static final String TRANSITION_FIRE_FUNCTION_NAME_PREFIX = "fire_transition_";
    public static final String CURRENT_STATE_VAR_NAME = "current_state";
    public static final String SCRATCH_PAPER_NAME_PREFIX = "scratch_paper_";
    public static final String COPY_SCRATCH_PAPER_FUNCTION_NAME = "copy_scratch_paper";

    protected List<LocalVariable> createLocalVariables(Component component) {
        StateAutomaton automaton = this.getSpecification(component);
        return this.createLocalVariables(automaton);
    }

    protected List<LocalVariable> createLocalVariables(StateAutomaton automaton) {
        ArrayList<LocalVariable> vars = new ArrayList<LocalVariable>();
        vars.add(GeneratorModelElementFactory.createLocalVariable((String)CURRENT_STATE_VAR_NAME, (IType)ExpressionModelElementFactory.intType()));
        for (DataStateVariable dsv : automaton.getDataStateVariables()) {
            vars.add(GeneratorModelElementFactory.createLocalVariable((String)dsv.getIdentifier(), (IType)dsv.getType()));
            vars.add(GeneratorModelElementFactory.createLocalVariable((String)this.getScratchPaperVariableName(dsv), (IType)dsv.getType()));
        }
        return vars;
    }

    protected List<LocalFunction> createLocalFunctions(Component component) {
        StateAutomaton automaton = this.getSpecification(component);
        return this.createLocalFunctions(automaton);
    }

    protected List<LocalFunction> createLocalFunctions(StateAutomaton automaton) {
        ArrayList<LocalFunction> funs = new ArrayList<LocalFunction>();
        if (automaton.getDataStateVariables().size() > 0) {
            funs.add(this.createCopyScratchPaperFunction(automaton));
        }
        for (IConnection seg : automaton.getRootState().getConnections()) {
            funs.add(this.createTransitionFireFunction((TransitionSegment)seg));
        }
        for (State s : automaton.getRootState().getSubStates()) {
            funs.add(this.createStateFireFunction(s));
        }
        return funs;
    }

    protected StatementSequence createInitialization(Component component) {
        StateAutomaton automaton = this.getSpecification(component);
        StatementSequence init = this.createPortInitialization(component);
        return this.createInitialization(automaton, init);
    }

    protected StatementSequence createInitialization(StateAutomaton automaton, StatementSequence init) {
        IntConst initStateID = ExpressionModelElementFactory.intConst((int)automaton.getInitialState().getId());
        Assignment assign = ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.createVar((String)CURRENT_STATE_VAR_NAME), (IExpressionTerm)initStateID);
        init.getStatements().add((Object)assign);
        for (DataStateVariable dsv : automaton.getDataStateVariables()) {
            IExpressionTerm i = dsv.getInitialValue();
            IExpressionTerm inititialValue = (IExpressionTerm)new TermReplacement((ITerm)i).apply();
            if (inititialValue == null) continue;
            assign = ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.createVar((String)dsv.getIdentifier()), (IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)inititialValue)));
            init.getStatements().add((Object)assign);
            assign = ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.createVar((String)this.getScratchPaperVariableName(dsv)), (IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)inititialValue)));
            init.getStatements().add((Object)assign);
        }
        return init;
    }

    protected StatementSequence createPerformStep(Component component) {
        StateAutomaton automaton = this.getSpecification(component);
        return this.createPerformStep(component, automaton);
    }

    protected StatementSequence createPerformStep(Component component, StateAutomaton automaton) {
        LinkedList<Object> body = new LinkedList<Object>();
        body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)ComponentFunctionIdentifierUtils.getClearOutputsFunctionName((Component)component))));
        IfThenElse lastBlock = null;
        for (State s : automaton.getRootState().getSubStates()) {
            FunctionCall guard = ExpressionModelElementFactory.equal((IExpressionTerm)ExpressionModelElementFactory.createVar((String)CURRENT_STATE_VAR_NAME), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)s.getId()));
            Assignment callStateFire = ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)this.getStateFireFunctionName(s)));
            lastBlock = lastBlock == null ? ExpressionModelElementFactory.ifthenelse((IExpressionTerm)guard, (StatementSequence)ExpressionModelElementFactory.sequence((IStatementTerm)callStateFire), null) : ExpressionModelElementFactory.ifthenelse((IExpressionTerm)guard, (StatementSequence)ExpressionModelElementFactory.sequence((IStatementTerm)callStateFire), (StatementSequence)ExpressionModelElementFactory.sequence(lastBlock));
        }
        if (lastBlock != null) {
            body.add(lastBlock);
        }
        if (automaton.getDataStateVariables().size() > 0) {
            body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)COPY_SCRATCH_PAPER_FUNCTION_NAME)));
        }
        return ExpressionModelElementFactory.sequence(body);
    }

    protected boolean canTransformComponent(Component source, ITransformationContext context) {
        return this.getSpecification(source) != null;
    }

    protected StateAutomaton getSpecification(Component source) {
        return (StateAutomaton)ReflectionUtils.pickInstanceOf(StateAutomaton.class, (Collection)source.getSpecifications());
    }

    protected LocalFunction createTransitionFireFunction(TransitionSegment segment) {
        BoolConst guard;
        TransitionSegmentSpecification spec = segment.getTransitionSegmentSpecification();
        List<IStatementTerm> body = this.createActionsCode((List<Action>)spec.getActions());
        body.add((IStatementTerm)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.createVar((String)CURRENT_STATE_VAR_NAME), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)segment.getTargetState().getId())));
        body.add((IStatementTerm)ExpressionModelElementFactory.returns((IExpressionTerm)ExpressionModelElementFactory.boolConst((boolean)true)));
        if (spec.getGuard() == null) {
            guard = ExpressionModelElementFactory.boolConst((boolean)true);
        } else {
            TermReplacement repl = new TermReplacement((ITerm)spec.getGuard().getExpression());
            guard = (IExpressionTerm)repl.apply();
        }
        IfThenElse ifte = ExpressionModelElementFactory.ifthenelse((IExpressionTerm)guard, (StatementSequence)ExpressionModelElementFactory.sequence(body), (StatementSequence)ExpressionModelElementFactory.sequence((IStatementTerm)ExpressionModelElementFactory.returns((IExpressionTerm)ExpressionModelElementFactory.boolConst((boolean)false))));
        return GeneratorModelElementFactory.createLocalFunction((String)StateAutomatonTransformation.getTransitionFireFunctionName(segment), (IType)ExpressionModelElementFactory.boolType(), (StatementSequence)ExpressionModelElementFactory.sequence((IStatementTerm)ifte));
    }

    protected List<IStatementTerm> createActionsCode(List<Action> actions) {
        ArrayList<IStatementTerm> body = new ArrayList<IStatementTerm>();
        for (Action a : actions) {
            IVariableDefinition def = VariableScopeUtils.getVarDefinition((VarBase)a.getVariable());
            if (def instanceof DataStateVariable) {
                Assignment aCopy = ExpressionModelElementFactory.assignment((IExpressionTerm)((IExpressionTerm)new TermReplacement((ITerm)a.getVariable()).apply()), (IExpressionTerm)((IExpressionTerm)new TermReplacement((ITerm)a.getValue()).apply()));
                String scratchname = this.getScratchPaperVariableName((DataStateVariable)def);
                Var variable = aCopy.getVariable();
                if (variable instanceof ComplexVar) {
                    if (ExpressionUtils.isArrayAccess((Var)variable)) {
                        var = ExpressionUtils.getAccessedArrayVar((ComplexVar)((ComplexVar)variable));
                        var.setIdentifier(scratchname);
                    } else if (ExpressionUtils.isStructureAccess((ITerm)variable)) {
                        var = ExpressionUtils.getAccessedStructureVar((ComplexVar)((ComplexVar)variable));
                        var.setIdentifier(scratchname);
                    }
                } else {
                    aCopy.getVariable().setIdentifier(scratchname);
                }
                body.add((IStatementTerm)aCopy);
                continue;
            }
            if (!(def instanceof OutputPort)) continue;
            body.add((IStatementTerm)PortVariableUtils.getPortAssignment((Port)((OutputPort)def), (IExpressionTerm)a.getValue()));
        }
        return body;
    }

    protected String getStateFireFunctionName(State s) {
        return STATE_FIRE_FUNCTION_NAME_PREFIX + IdentifierUtils.getUniqueIdentifier((INamedElement)s);
    }

    public static String getTransitionFireFunctionName(TransitionSegment s) {
        return TRANSITION_FIRE_FUNCTION_NAME_PREFIX + IdentifierUtils.getUniqueIdentifier((INamedElement)s);
    }

    protected String getScratchPaperVariableName(DataStateVariable dsv) {
        return SCRATCH_PAPER_NAME_PREFIX + dsv.getIdentifier();
    }

    protected LocalFunction createCopyScratchPaperFunction(StateAutomaton automaton) {
        ArrayList<Assignment> body = new ArrayList<Assignment>();
        for (DataStateVariable dsv : automaton.getDataStateVariables()) {
            body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.createVar((String)dsv.getIdentifier()), (IExpressionTerm)ExpressionModelElementFactory.createVar((String)this.getScratchPaperVariableName(dsv))));
        }
        return GeneratorModelElementFactory.createLocalFunction((String)COPY_SCRATCH_PAPER_FUNCTION_NAME, null, (StatementSequence)ExpressionModelElementFactory.sequence(body));
    }

    protected LocalFunction createStateFireFunction(State s) {
        LinkedList<TransitionSegment> transitions = new LinkedList<TransitionSegment>();
        for (TransitionSegmentConnector tsc : s.getTransitionSegmentExitConnectors()) {
            transitions.addAll((Collection<TransitionSegment>)tsc.getOutgoingTransitionSegments());
        }
        LinkedList<Object> body = new LinkedList<Object>();
        if (!transitions.isEmpty()) {
            if (s.getIdleTransitionSpecification().getActions().size() == 0) {
                body.add(ExpressionModelElementFactory.returns((IExpressionTerm)this.getOrCascade(transitions)));
            } else {
                body.add(ExpressionModelElementFactory.ifthenelse((IExpressionTerm)ExpressionModelElementFactory.not((IExpressionTerm)this.getOrCascade(transitions)), (StatementSequence)ExpressionModelElementFactory.sequence(this.createActionsCode((List<Action>)s.getIdleTransitionSpecification().getActions())), null));
                body.add(ExpressionModelElementFactory.returns((IExpressionTerm)ExpressionModelElementFactory.boolConst((boolean)true)));
            }
        } else if (s.getIdleTransitionSpecification().getActions().size() == 0) {
            body.add(ExpressionModelElementFactory.returns((IExpressionTerm)ExpressionModelElementFactory.boolConst((boolean)false)));
        } else {
            body.addAll(this.createActionsCode((List<Action>)s.getIdleTransitionSpecification().getActions()));
            body.add(ExpressionModelElementFactory.returns((IExpressionTerm)ExpressionModelElementFactory.boolConst((boolean)true)));
        }
        return GeneratorModelElementFactory.createLocalFunction((String)this.getStateFireFunctionName(s), (IType)ExpressionModelElementFactory.boolType(), (StatementSequence)ExpressionModelElementFactory.sequence(body));
    }

    protected IExpressionTerm getOrCascade(LinkedList<TransitionSegment> transitions) {
        FunctionCall cascade = ExpressionModelElementFactory.funcCall((String)StateAutomatonTransformation.getTransitionFireFunctionName(transitions.getLast()));
        ListIterator<TransitionSegment> it = transitions.listIterator(transitions.size() - 1);
        while (it.hasPrevious()) {
            FunctionCall funCall = ExpressionModelElementFactory.funcCall((String)StateAutomatonTransformation.getTransitionFireFunctionName(it.previous()));
            cascade = ExpressionModelElementFactory.or((IExpressionTerm)funCall, (IExpressionTerm)cascade);
        }
        return cascade;
    }
}

