/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.listener;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.state.AF3StateActivator;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class StateRenameListener
extends EContentAdapter {
    private static volatile StateRenameListener INSTANCE;

    private StateRenameListener() {
    }

    public static synchronized StateRenameListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StateRenameListener();
        }
        return INSTANCE;
    }

    public static void installRenamingListeners(ITopLevelElement element) {
        EObject rootElement = element.getRootModelElement();
        if (!(rootElement instanceof FileProject)) {
            LoggingUtils.warning((Plugin)AF3StateActivator.getDefault(), (String)"Got a root element that is not a file project while trying to install listeners. This could indicate a model corruption.");
            return;
        }
        FileProject fileProject = (FileProject)rootElement;
        EList componentArchitectures = EcoreUtils.pickInstanceOf(ComponentArchitecture.class, (List)fileProject.getRootElements());
        LambdaUtils.filter((Collection)componentArchitectures, ca -> !ca.eAdapters().contains((Object)StateRenameListener.getInstance())).forEach(ca -> {
            boolean bl = ca.eAdapters().add((Object)StateRenameListener.getInstance());
        });
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getNotifier() instanceof Port && notification.getEventType() == 1) {
            if (!(notification.getFeature() instanceof EAttribute)) {
                return;
            }
            EAttribute attribute = (EAttribute)notification.getFeature();
            if (!attribute.getName().equals("name")) {
                return;
            }
            Component parentComponent = ((Port)notification.getNotifier()).getComponent();
            StateAutomaton stateAutomaton = (StateAutomaton)EcoreUtils.pickFirstInstanceOf(StateAutomaton.class, (List)parentComponent.getSpecifications());
            if (stateAutomaton == null) {
                return;
            }
            for (Guard guard : EcoreUtils.getChildrenWithType((EObject)stateAutomaton, Guard.class)) {
                this.renameVariables(notification, (EObject)guard.getExpression());
                guard.setStringRepresentation(null);
                guard.setStringRepresentation(guard.toString());
            }
            for (Action action : EcoreUtils.getChildrenWithType((EObject)stateAutomaton, Action.class)) {
                this.renameVariables(notification, (EObject)action);
                action.setStringRepresentation(null);
                action.setStringRepresentation(ExpressionUtils.formatStatements((String)action.toString()));
            }
        }
    }

    private void renameVariables(Notification notification, EObject container) {
        EList variables = EcoreUtils.getChildrenWithType((EObject)container, Var.class);
        String oldName = notification.getOldStringValue();
        String newName = notification.getNewStringValue();
        Collection variableMatch = LambdaUtils.filter((Collection)variables, v -> v.getIdentifier().equals(oldName));
        variableMatch.forEach(v -> v.setIdentifier(newName));
    }
}

