/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.simulator;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.component.simulator.ExecutableAtomicComponentBase;
import org.fortiss.af3.component.simulator.ExecutionException;
import org.fortiss.af3.expression.language.evaluation.BoolValue;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.services.ITypeSystemService;
import org.fortiss.af3.project.typesystem.IEvaluationContext;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.model.TransitionSegmentConnector;
import org.fortiss.af3.state.model.TransitionSegmentExitConnector;
import org.fortiss.af3.state.model.TransitionSegmentSpecification;
import org.fortiss.af3.state.simulator.IStateTraceListener;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ExecutableStateAutomatonSpecification
extends ExecutableAtomicComponentBase<StateAutomaton> {
    protected StateAutomaton automaton;
    private List<TransitionSegmentSpecification> lastFiredTransition = new LinkedList<TransitionSegmentSpecification>();
    protected Deque<List<TransitionSegmentSpecification>> lastFiredTransitionHistory = new LinkedList<List<TransitionSegmentSpecification>>();
    private IEvaluationContext scratchPaper;

    public List<TransitionSegmentSpecification> getLastFiredTransitionSegments() {
        return this.lastFiredTransition;
    }

    public ExecutableStateAutomatonSpecification(StateAutomaton automaton) {
        super((IModelElementSpecification)automaton);
        this.automaton = automaton;
        this.scratchPaper = ITypeSystemService.INSTANCE.createEvaluationContext((EObject)this.modelElement);
    }

    public void setCurrentState(State state) {
        this.setInternalValue((EObject)this.automaton, state);
    }

    public State getCurrentState() {
        return (State)this.getInternalValue((EObject)this.automaton);
    }

    public List<DataStateVariable> getVariables() {
        return this.automaton.getDataStateVariables();
    }

    public void initialize() {
        super.initialize();
        this.setCurrentState(this.automaton.getInitialState());
        this.notifyStateChange(null, this.automaton.getInitialState());
        for (DataStateVariable dsv : this.automaton.getDataStateVariables()) {
            Term initialValue = this.termEvaluator.evaluate((ITerm)dsv.getInitialValue(), this.evaluationContext);
            this.setInternalValue((EObject)dsv, initialValue);
            this.dataStateVariables.put(dsv.getVariable(), dsv);
        }
    }

    public void backupState() {
        super.backupState();
        this.lastFiredTransitionHistory.addLast(this.lastFiredTransition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAtomicStep() {
        ExecutableStateAutomatonSpecification executableStateAutomatonSpecification = this;
        synchronized (executableStateAutomatonSpecification) {
            Term value;
            for (DataStateVariable dsv : this.automaton.getDataStateVariables()) {
                this.evaluationContext.setValue((VarBase)dsv.getVariable(), (Term)this.getInternalValue((EObject)dsv));
            }
            this.scratchPaper.clear();
            State newState = this.simulateInternal(this.getCurrentState());
            State oldState = this.getCurrentState();
            this.setCurrentState(newState);
            for (OutputPort port : this.outputPortVariables.keySet()) {
                value = this.evaluationContext.getValue((VarBase)this.outputPortVariables.get(port));
                if (value == null) {
                    value = NoVal.NOVAL;
                }
                this.setInternalOutputValue(port, value);
            }
            for (DataStateVariable dsv : this.automaton.getDataStateVariables()) {
                value = this.scratchPaper.getValue((VarBase)dsv.getVariable());
                if (value == null) continue;
                if (NoVal.NOVAL.equals((Object)value)) {
                    throw new RuntimeException("Data variable \"" + dsv.getIdentifier() + "\" was assigned \"NoVal\".");
                }
                this.setInternalValue((EObject)dsv, value);
            }
            if (!newState.equals(oldState)) {
                this.notifyStateChange(oldState, newState);
            }
        }
    }

    public void restoreState() {
        super.restoreState();
        this.lastFiredTransition = this.lastFiredTransitionHistory.removeLast();
    }

    public void clearHistory() {
        this.lastFiredTransitionHistory.clear();
        if (this.lastFiredTransition != null) {
            this.lastFiredTransition.clear();
        }
        super.clearHistory();
    }

    protected State simulateInternal(State startState) {
        List<TransitionSegmentSpecification> fire;
        List<List<TransitionSegmentSpecification>> ready = this.computeReadyTransitions(startState);
        if (ready.size() == 0) {
            this.fireTransitionSegment(startState.getIdleTransitionSpecification());
            this.lastFiredTransition.clear();
            this.notifyIdleAction(startState);
            return startState;
        }
        if (ready.size() == 1) {
            fire = ready.get(0);
        } else {
            int i = this.chooseNondeterministically(ready.size());
            fire = ready.get(i);
        }
        return this.fireTransition(startState, fire);
    }

    protected int chooseNondeterministically(int numChoices) {
        return (int)(Math.random() * (double)numChoices);
    }

    protected State fireTransition(State currentState, List<TransitionSegmentSpecification> transitionSpecifications) {
        this.lastFiredTransition = transitionSpecifications;
        if (transitionSpecifications == null) {
            this.notifyIdleAction(currentState);
            return currentState;
        }
        for (TransitionSegmentSpecification spec : transitionSpecifications) {
            this.fireTransitionSegment(spec);
        }
        return transitionSpecifications.get(transitionSpecifications.size() - 1).getTransitionSegment().getTargetConnector().getState();
    }

    protected List<List<TransitionSegmentSpecification>> computeReadyTransitions(State start) {
        LinkedList<List<TransitionSegmentSpecification>> retColl = new LinkedList<List<TransitionSegmentSpecification>>();
        ArrayList<TransitionSegmentSpecification> singlePath = new ArrayList<TransitionSegmentSpecification>();
        for (TransitionSegmentExitConnector tp : start.getTransitionSegmentExitConnectors()) {
            if (tp.getOutgoing().size() <= 0) continue;
            this.findSegmentPath(tp, retColl, singlePath);
            singlePath.clear();
        }
        return retColl;
    }

    protected void findSegmentPath(TransitionSegmentConnector tp, List<List<TransitionSegmentSpecification>> pathList, List<TransitionSegmentSpecification> currentPath) {
        for (TransitionSegmentSpecification tseg : currentPath) {
            if (tseg.getTransitionSegment().getSource() != tp) continue;
            throw new ExecutionException("Found cycle connector point " + tp.getName() + " in state " + tp.getState().getName());
        }
        if (tp.getOutgoing().size() == 0 && tp.getState().getSubStates().size() > 0) {
            throw new ExecutionException("Found terminating connector point " + tp.getName() + " in state " + ((INamedElement)tp.eContainer()).getName() + ", but target state " + tp.getState().getName() + " is not atomic.");
        }
        if (tp.getOutgoing().size() == 0) {
            pathList.add(currentPath);
            return;
        }
        for (TransitionSegment ts : tp.getOutgoingTransitionSegments()) {
            TransitionSegmentSpecification spec = this.canFireTransitionSegment(ts);
            if (spec == null) continue;
            ArrayList<TransitionSegmentSpecification> nextPath = new ArrayList<TransitionSegmentSpecification>(currentPath.size() + 1);
            nextPath.addAll(currentPath);
            nextPath.add(spec);
            this.findSegmentPath(ts.getTargetConnector(), pathList, nextPath);
        }
    }

    protected TransitionSegmentSpecification canFireTransitionSegment(TransitionSegment ts) {
        TransitionSegmentSpecification spec = ts.getTransitionSegmentSpecification();
        Guard guard = spec.getGuard();
        if (guard == null) {
            return spec;
        }
        Term result = this.termEvaluator.evaluate((ITerm)guard.getExpression(), this.evaluationContext);
        if (result instanceof BoolValue) {
            if (result.equals(BoolValue.FALSE)) {
                return null;
            }
        } else {
            if (NoVal.NOVAL.equals((Object)result)) {
                throw new NoValExecutionException(ts);
            }
            throw new ExecutionException(guard.getExpression().toString() + " evaluated to " + result.toString() + "; expected boolean value!");
        }
        return spec;
    }

    protected void fireTransitionSegment(TransitionSegmentSpecification spec) {
        for (Action action : spec.getActions()) {
            Term val = this.termEvaluator.evaluate((ITerm)action.getValue(), this.evaluationContext);
            if (this.dataStateVariables.containsKey(action.getVariable())) {
                this.scratchPaper.setValue((VarBase)action.getVariable(), val);
                continue;
            }
            this.termEvaluator.evaluate((ITerm)ExpressionModelElementFactory.assignment((IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)action.getVariable())), (IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)action.getValue()))), this.evaluationContext);
        }
        this.notifyTransitionSegmentFired((TransitionSegment)spec.getSpecificationOf());
    }

    private void notifyStateChange(State oldState, State newState) {
        for (IStateTraceListener listener : EcoreUtils.pickInstanceOf(IStateTraceListener.class, (List)this.listeners)) {
            listener.notifyStateChanged(oldState, newState);
        }
    }

    private void notifyTransitionSegmentFired(TransitionSegment transitionSegment) {
        for (IStateTraceListener listener : EcoreUtils.pickInstanceOf(IStateTraceListener.class, (List)this.listeners)) {
            listener.notifyTransitionSegmentFired(transitionSegment);
        }
    }

    private void notifyIdleAction(State IdleState) {
        for (IStateTraceListener listener : EcoreUtils.pickInstanceOf(IStateTraceListener.class, (List)this.listeners)) {
            listener.notifyIdleAction(IdleState);
        }
    }

    public static class NoValExecutionException
    extends ExecutionException {
        public TransitionSegment transitionSegment;

        public NoValExecutionException(TransitionSegment ts) {
            super(ts.getTransitionSegmentSpecification().getGuard().toString() + " evaluated to NoVal during the execution");
            this.transitionSegment = ts;
        }
    }
}

