/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.component.utils.BehaviorModelElementFactory;
import org.fortiss.af3.expression.language.Compiler;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.model.TransitionSegmentConnector;
import org.fortiss.af3.state.model.TransitionSegmentEntryConnector;
import org.fortiss.af3.state.model.TransitionSegmentExitConnector;
import org.fortiss.af3.state.model.TransitionSegmentSpecification;
import org.fortiss.af3.state.utils.StateModelElementFactory;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class StateAutomatonUtils {
    private static Compiler compiler = new Compiler();

    public static StateAutomaton findStateAutomatonRecursively(Component parent, String childName) {
        Component childComponent = parent.findSubComponentRecursively(childName);
        if (childComponent == null) {
            return null;
        }
        return StateAutomatonUtils.getStateAutomaton(childComponent);
    }

    public static boolean hasStateAutomaton(Component component) {
        return ReflectionUtils.pickInstanceOf(StateAutomaton.class, (Collection)component.getSpecifications()) != null;
    }

    public static StateAutomaton getStateAutomaton(State state) {
        if (state.getContainer() instanceof StateAutomaton) {
            return (StateAutomaton)state.getContainer();
        }
        return StateAutomatonUtils.getStateAutomaton((State)state.getContainer());
    }

    public static Guard getGuard(TransitionSegment segment) {
        return segment.getTransitionSegmentSpecification().getGuard();
    }

    private static void setGuard(TransitionSegment transitionSegment, Guard guard) {
        transitionSegment.getTransitionSegmentSpecification().setGuard(guard);
    }

    private static void setGuard(TransitionSegment transitionSegment, IExpressionTerm guardExpression) {
        StateAutomatonUtils.setGuard(transitionSegment, BehaviorModelElementFactory.createGuard((IExpressionTerm)guardExpression));
    }

    public static void setGuard(TransitionSegment transitionSegment, String guard) {
        StateAutomatonUtils.setGuard(transitionSegment, compiler.compileTerm(guard, (EObject)transitionSegment));
    }

    public static IExpressionTerm getGuardExpressionByName(StateAutomaton automaton, String transitionSegmentName) {
        TransitionSegment ts = StateAutomatonUtils.findTransitionSegmentByName(automaton, transitionSegmentName);
        return StateAutomatonUtils.getGuard(ts).getExpression();
    }

    public static IExpressionTerm getGuardExpressionByName(State state, String transitionSegmentName) {
        TransitionSegment ts = StateAutomatonUtils.findTransitionSegmentByName(state, transitionSegmentName);
        return StateAutomatonUtils.getGuard(ts).getExpression();
    }

    private static void addAction(TransitionSegment transitionSegment, String variableName, IExpressionTerm value) {
        Action a = BehaviorModelElementFactory.createAction((String)variableName, (IExpressionTerm)value);
        transitionSegment.getTransitionSegmentSpecification().getActions().add((Object)a);
    }

    public static void addAction(TransitionSegment transitionSegment, String variableName, String value) {
        StateAutomatonUtils.addAction(transitionSegment, variableName, compiler.compileTerm(value, (EObject)transitionSegment));
    }

    public static EList<Action> getActions(TransitionSegment segment) {
        return segment.getTransitionSegmentSpecification().getActions();
    }

    public static EList<Action> getActions(State state) {
        return state.getIdleTransitionSpecification().getActions();
    }

    public static void setActions(State state, EList<Action> newActions) {
        EList<Action> actions = state.getIdleTransitionSpecification().getActions();
        actions.clear();
        actions.addAll(newActions);
    }

    public static StateAutomaton getStateAutomaton(Component component) {
        return (StateAutomaton)EcoreUtils.pickFirstInstanceOf(StateAutomaton.class, (List)component.getSpecifications());
    }

    public static State getInitialState(StateAutomaton automaton) {
        for (State state : automaton.getRootState().getSubStates()) {
            if (!state.isInitial()) continue;
            return state;
        }
        return null;
    }

    public static DataStateVariable findVariableByName(StateAutomaton automaton, String varName) {
        for (DataStateVariable dsv : automaton.getDataStateVariables()) {
            if (!dsv.getVariable().getIdentifier().equals(varName)) continue;
            return dsv;
        }
        return null;
    }

    public static List<State> getStatesRecursively(StateAutomaton automaton) {
        return StateAutomatonUtils.getSubStatesRecursively(automaton.getRootState());
    }

    public static List<State> getSubStatesRecursively(State aState) {
        ArrayList<State> subStates = new ArrayList<State>();
        if (aState != null && aState.getSubStates().size() > 0) {
            subStates.addAll((Collection<State>)aState.getSubStates());
            for (State subState : aState.getSubStates()) {
                subStates.addAll(StateAutomatonUtils.getSubStatesRecursively(subState));
            }
        }
        return subStates;
    }

    public static List<TransitionSegment> getTransitionSegmentsRecursively(StateAutomaton automaton) {
        List<State> allStates = StateAutomatonUtils.getStatesRecursively(automaton);
        ArrayList<TransitionSegment> transitionSegments = new ArrayList<TransitionSegment>();
        for (State state : allStates) {
            transitionSegments.addAll((Collection<TransitionSegment>)state.getOutgoingTransitionSegments());
        }
        return transitionSegments;
    }

    public static State findStateByName(StateAutomaton automaton, String name) {
        for (State s : StateAutomatonUtils.getStatesRecursively(automaton)) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public static IVariableDefinition getDefinitionElement(StateAutomaton stateAutomaton, VarBase var) {
        return StateAutomatonUtils.findVariableByName(stateAutomaton, var.getIdentifier());
    }

    public static TransitionSegment findTransitionSegmentByName(StateAutomaton stateAutomaton, String name) {
        for (State state : stateAutomaton.getRootState().getSubStates()) {
            TransitionSegment ts = StateAutomatonUtils.findTransitionSegmentByName(state, name);
            if (ts == null) continue;
            return ts;
        }
        return null;
    }

    public static TransitionSegment findTransitionSegmentByName(State state, String name) {
        for (TransitionSegment ts : state.getOutgoingTransitionSegments()) {
            if (!ts.getName().equals(name)) continue;
            return ts;
        }
        for (State subState : state.getSubStates()) {
            TransitionSegment ts = StateAutomatonUtils.findTransitionSegmentByName(subState, name);
            if (ts == null) continue;
            return ts;
        }
        return null;
    }

    public static TransitionSegmentConnector findTransitionConnector(State state, String name) {
        for (IConnector c : state.getConnectors()) {
            if (!(c instanceof TransitionSegmentConnector) || !name.equals(((TransitionSegmentConnector)c).getName())) continue;
            return (TransitionSegmentConnector)c;
        }
        return null;
    }

    public static List<TransitionSegment> findSelfTransitions(State state) {
        if (state.getOutgoingTransitionSegments() == null) {
            return null;
        }
        ArrayList<TransitionSegment> result = new ArrayList<TransitionSegment>();
        for (TransitionSegment ts : state.getOutgoingTransitionSegments()) {
            if (!ts.getSourceState().equals(state) || !ts.getTargetState().equals(state)) continue;
            result.add(ts);
        }
        return result;
    }

    public static List<TransitionSegment> findStateChangeTransitions(State state) {
        if (state.getOutgoingTransitionSegments() == null) {
            return null;
        }
        ArrayList<TransitionSegment> result = new ArrayList<TransitionSegment>();
        for (TransitionSegment ts : state.getOutgoingTransitionSegments()) {
            if (!ts.getSourceState().equals(state) || ts.getTargetState().equals(state)) continue;
            result.add(ts);
        }
        return result;
    }

    public static TransitionSegment findTransitionWithoutGuard(State state) {
        if (state.getOutgoingTransitionSegments() == null) {
            return null;
        }
        for (TransitionSegment ts : state.getOutgoingTransitionSegments()) {
            if (ts.getTransitionSegmentSpecification().getGuard() != null) continue;
            return ts;
        }
        return null;
    }

    public static List<TransitionSegment> findTransitionWithGuard(State state) {
        if (state.getOutgoingTransitionSegments() == null) {
            return null;
        }
        ArrayList<TransitionSegment> result = new ArrayList<TransitionSegment>();
        for (TransitionSegment ts : state.getOutgoingTransitionSegments()) {
            if (ts.getTransitionSegmentSpecification().getGuard() == null) continue;
            result.add(ts);
        }
        return result;
    }

    public static State getParentState(State state) {
        IHierarchicElementContainer parent = state.getContainer();
        if (parent == null) {
            return null;
        }
        if (parent instanceof State) {
            return (State)parent;
        }
        if (parent instanceof StateAutomaton) {
            return ((StateAutomaton)parent).getRootState();
        }
        return null;
    }

    public static void setSourceState(TransitionSegment ts, State source, int id) {
        TransitionSegmentExitConnector sourcePoint = StateModelElementFactory.createTransitionSegmentExitConnector("Source", "");
        sourcePoint.setId(id);
        source.getConnectors().add((Object)sourcePoint);
        ts.setSource((IConnector)sourcePoint);
    }

    public static void setTargetState(TransitionSegment ts, State target, int id) {
        TransitionSegmentEntryConnector targetPoint = StateModelElementFactory.createTransitionSegmentEntryConnector("Target", "");
        targetPoint.setId(id);
        target.getConnectors().add((Object)targetPoint);
        ts.setTarget((IConnector)targetPoint);
    }

    public static List<TransitionSegmentSpecification> getAllTransitionSpecifications(StateAutomaton sa) {
        ArrayList<TransitionSegmentSpecification> tss = new ArrayList<TransitionSegmentSpecification>();
        StateAutomatonUtils.getTransitionSegmentsRecursively(sa).forEach(ts -> {
            boolean bl = tss.add(ts.getTransitionSegmentSpecification());
        });
        StateAutomatonUtils.getStatesRecursively(sa).forEach(s -> {
            boolean bl = tss.add(s.getIdleTransitionSpecification());
        });
        return tss;
    }

    public static StateAutomaton getStateAutomaton(TransitionSegmentSpecification tss) {
        return (StateAutomaton)EcoreUtils.getFirstParentWithType((EObject)tss, StateAutomaton.class);
    }
}

