/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.utils;

import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.behavior.common.Action;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.component.utils.BehaviorModelElementFactory;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.state.model.AF3StateFactory;
import org.fortiss.af3.state.model.InternalState;
import org.fortiss.af3.state.model.State;
import org.fortiss.af3.state.model.StateAutomaton;
import org.fortiss.af3.state.model.StateSpecification;
import org.fortiss.af3.state.model.TransitionSegment;
import org.fortiss.af3.state.model.TransitionSegmentEntryConnector;
import org.fortiss.af3.state.model.TransitionSegmentExitConnector;
import org.fortiss.af3.state.model.TransitionSegmentSpecification;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;

public class StateModelElementFactory {
    public static StateAutomaton createStateAutomaton() {
        return StateModelElementFactory.createStateAutomaton("RootState");
    }

    public static StateAutomaton createStateAutomaton(String rootStateName) {
        StateAutomaton automaton = AF3StateFactory.eINSTANCE.createStateAutomaton();
        State rootState = StateModelElementFactory.createState(rootStateName, "", false);
        automaton.getContainedElements().add((Object)rootState);
        return automaton;
    }

    public static StateAutomaton createStateAutomaton(Component component) {
        StateAutomaton stateAutomaton = StateModelElementFactory.createStateAutomaton();
        component.getSpecifications().add((Object)stateAutomaton);
        return stateAutomaton;
    }

    public static State createState() {
        return StateModelElementFactory.createState("State", "", false);
    }

    public static State createState(String name, String comment, boolean isInitial) {
        State state = AF3StateFactory.eINSTANCE.createState();
        state.setName(name);
        state.setComment(comment);
        LayoutModelElementFactory.createNodeElementLayout((ILayoutedModelElement)state);
        StateSpecification stateSpecification = AF3StateFactory.eINSTANCE.createStateSpecification();
        stateSpecification.setInitial(isInitial);
        state.getSpecifications().add((Object)stateSpecification);
        TransitionSegmentSpecification idleTransitionSpecification = AF3StateFactory.eINSTANCE.createTransitionSegmentSpecification();
        stateSpecification.getIdleTransitionsSpecifications().add((Object)idleTransitionSpecification);
        return state;
    }

    public static State createInternalState(String name) {
        InternalState state = AF3StateFactory.eINSTANCE.createInternalState();
        state.setName(name);
        return state;
    }

    public static State createState(State parentState, String name, String comment, boolean isInitial) {
        State state = StateModelElementFactory.createState(name, comment, isInitial);
        parentState.getSubStates().add((Object)state);
        return state;
    }

    public static State createState(State parentState, String name, boolean isInitial) {
        return StateModelElementFactory.createState(parentState, name, "", isInitial);
    }

    public static TransitionSegmentEntryConnector createTransitionSegmentEntryConnector(String name, String comment) {
        TransitionSegmentEntryConnector connector = AF3StateFactory.eINSTANCE.createTransitionSegmentEntryConnector();
        connector.setName(name);
        connector.setComment(comment);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)connector);
        return connector;
    }

    public static TransitionSegmentExitConnector createTransitionSegmentExitConnector(String name, String comment) {
        TransitionSegmentExitConnector connector = AF3StateFactory.eINSTANCE.createTransitionSegmentExitConnector();
        connector.setName(name);
        connector.setComment(comment);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)connector);
        return connector;
    }

    public static TransitionSegment createTransitionSegment() {
        return StateModelElementFactory.createTransitionSegment("Transition Segment", "");
    }

    public static TransitionSegment createTransitionSegment(String name, String comment) {
        TransitionSegment transitionSegment = AF3StateFactory.eINSTANCE.createTransitionSegment();
        transitionSegment.setName(name);
        transitionSegment.setComment(comment);
        TransitionSegmentSpecification transitionSegmentSpecification = AF3StateFactory.eINSTANCE.createTransitionSegmentSpecification();
        transitionSegment.getSpecifications().add((Object)transitionSegmentSpecification);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)transitionSegment);
        return transitionSegment;
    }

    public static TransitionSegment createTransitionSegment(State parent, State source, State target, String name, String comment) {
        TransitionSegment segment = StateModelElementFactory.createTransitionSegment(name, comment);
        parent.getConnections().add((Object)segment);
        TransitionSegmentExitConnector sourcePoint = StateModelElementFactory.createTransitionSegmentExitConnector("Source", "");
        source.getConnectors().add((Object)sourcePoint);
        TransitionSegmentEntryConnector targetPoint = StateModelElementFactory.createTransitionSegmentEntryConnector("Target", "");
        target.getConnectors().add((Object)targetPoint);
        segment.setSource((IConnector)sourcePoint);
        segment.setTarget((IConnector)targetPoint);
        return segment;
    }

    public static TransitionSegment createTransitionSegment(State parent, State source, State target, String name) {
        return StateModelElementFactory.createTransitionSegment(parent, source, target, name, "");
    }

    public static Guard createGuard(TransitionSegment parent, IExpressionTerm guardTerm) {
        Guard guard = BehaviorModelElementFactory.createGuard((IExpressionTerm)guardTerm);
        parent.getTransitionSegmentSpecification().setGuard(guard);
        return guard;
    }

    public static Action createAction(TransitionSegment parent, String varName, IExpressionTerm actionTerm) {
        Action action = BehaviorModelElementFactory.createAction((String)varName, (IExpressionTerm)actionTerm);
        parent.getTransitionSegmentSpecification().getActions().add((Object)action);
        return action;
    }

    public static Action createAction(State state, String varName, IExpressionTerm actionTerm) {
        Action action = BehaviorModelElementFactory.createAction((String)varName, (IExpressionTerm)actionTerm);
        state.getIdleTransitionSpecification().getActions().add((Object)action);
        return action;
    }

    public static Action createAction(TransitionSegment parent, Var variable, IExpressionTerm actionTerm) {
        Action action = BehaviorModelElementFactory.createAction((Var)variable, (IExpressionTerm)actionTerm);
        parent.getTransitionSegmentSpecification().getActions().add((Object)action);
        return action;
    }

    public static Action createAction(State state, Var variable, IExpressionTerm actionTerm) {
        Action action = BehaviorModelElementFactory.createAction((Var)variable, (IExpressionTerm)actionTerm);
        state.getIdleTransitionSpecification().getActions().add((Object)action);
        return action;
    }

    public static DataStateVariable createDataStateVariable(StateAutomaton parent, String name, IType type, IExpressionTerm initVal) {
        DataStateVariable dsvar = BehaviorModelElementFactory.createDataStateVariable((String)name, (IType)type, (IExpressionTerm)initVal);
        parent.getDataStateVariables().add((Object)dsvar);
        return dsvar;
    }

    public static TransitionSegmentSpecification createTransitionSegmentSpecification() {
        TransitionSegmentSpecification transitionSegmentSpecification = AF3StateFactory.eINSTANCE.createTransitionSegmentSpecification();
        return transitionSegmentSpecification;
    }

    public static TransitionSegment createTransitionSegmentWithoutSpecification() {
        return StateModelElementFactory.createTransitionSegmentWithoutSpecification("Transition Segment", "");
    }

    public static TransitionSegment createTransitionSegmentWithoutSpecification(String name, String comment) {
        TransitionSegment transitionSegment = AF3StateFactory.eINSTANCE.createTransitionSegment();
        transitionSegment.setName(name);
        transitionSegment.setComment(comment);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)transitionSegment);
        return transitionSegment;
    }
}

