/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.state.variability;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.state.model.AF3StatePackage;
import org.fortiss.af3.state.variability.InitialStatePredicate;
import org.fortiss.tooling.base.model.element.ElementPackage;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.analysis.IProductLineTranslation;
import org.fortiss.variability.analysis.constraint.IPreComputedFunction;
import org.fortiss.variability.analysis.constraint.ProductLineConstraintBase;
import org.fortiss.variability.analysis.constraint.QuantifierVariable;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;

public class HasInitialStateConstraint
extends ProductLineConstraintBase {
    private static final EReference REF_CONTAINED_ELEMENTS = ElementPackage.Literals.IHIERARCHIC_ELEMENT_CONTAINER__CONTAINED_ELEMENTS;
    private static final EClass STATE_CLASS = AF3StatePackage.Literals.STATE;

    public HasInitialStateConstraint(IProductLineTranslation translation) {
        super(translation);
    }

    public String getConstraintName() {
        return "At least one initial state constraint";
    }

    public String createErrorMessage(List<EObject> violatingObjects, VariantConfiguration violatingConfiguration) {
        Component parentComp;
        Object compName = "";
        if (violatingObjects != null && violatingObjects.size() > 0 && (parentComp = (Component)EcoreUtils.getFirstParentWithType((EObject)violatingObjects.get(0), Component.class)) != null) {
            compName = " " + parentComp.getName();
        }
        return "There is not always an initial state in the component" + (String)compName + ".";
    }

    public boolean isForAll() {
        return true;
    }

    public Collection<EClass> getTranslatedClasses() {
        return Arrays.asList(STATE_CLASS);
    }

    public Collection<EReference> getTranslatedReferences() {
        return Arrays.asList(REF_CONTAINED_ELEMENTS);
    }

    public QuantifierVariable[] getQuantifierVariables() {
        return new QuantifierVariable[]{new QuantifierVariable(STATE_CLASS, "s0")};
    }

    protected BoolExpr createBody() {
        Context ctx = this.translation.getContext();
        Expr z3S0 = this.getZ3Variable("s0");
        FuncDecl initialFun = this.translation.getAttributeReferenceFunctionDeclaration(STATE_CLASS, "isInitial");
        return ctx.mkNot((Expr)((BoolExpr)ctx.mkApp(initialFun, new Expr[]{z3S0})));
    }

    public void addReferenceTypeExceptions(IProductLineTranslation translation) {
        translation.setTranslatedClassForEReferences(REF_CONTAINED_ELEMENTS, STATE_CLASS, STATE_CLASS);
    }

    public Collection<IPreComputedFunction<?, ?>> getPrecomputedFunctions() {
        return Arrays.asList(new IPreComputedFunction[]{new InitialStatePredicate()});
    }
}

